/*
 * Decompiled with CFR 0.152.
 */
package com.github.mreutegg.laszip4j.laslib;

import com.github.mreutegg.laszip4j.clib.Cstdio;
import com.github.mreutegg.laszip4j.clib.Cstring;
import com.github.mreutegg.laszip4j.laslib.LASheader;
import com.github.mreutegg.laszip4j.laslib.LASwriteOpener;
import com.github.mreutegg.laszip4j.laslib.LASwriter;
import com.github.mreutegg.laszip4j.laszip.ByteStreamOutArray;
import com.github.mreutegg.laszip4j.laszip.LASattribute;
import com.github.mreutegg.laszip4j.laszip.LASattributer;
import com.github.mreutegg.laszip4j.laszip.LASpoint;
import com.github.mreutegg.laszip4j.laszip.LASquantizer;
import com.github.mreutegg.laszip4j.laszip.MyDefs;
import java.io.PrintStream;

public class LASwriterCompatibleDown
extends LASwriter {
    private static final PrintStream stderr = System.err;
    private LASpoint pointCompatibleDown;
    private LASheader header = null;
    private LASwriter writer = null;
    private int start_scan_angle = -1;
    private int start_extended_returns = -1;
    private int start_classification = -1;
    private int start_flags_and_channel = -1;
    private int start_NIR_band = -1;

    @Override
    public boolean chunk() {
        return Boolean.FALSE;
    }

    public boolean open(LASheader header, LASwriteOpener laswriteopener, boolean moveCRSfromEVLRtoVLR, boolean moveEVLRtoVLR) {
        int i;
        if (header == null) {
            return Boolean.FALSE;
        }
        if (laswriteopener == null) {
            return Boolean.FALSE;
        }
        if (header.version_minor < 4) {
            return Boolean.FALSE;
        }
        if (header.point_data_format <= 5) {
            return Boolean.FALSE;
        }
        if (header.point_data_format > 10) {
            return Boolean.FALSE;
        }
        this.header = header;
        if (header.point_data_format <= 8) {
            header.version_minor = (byte)2;
            header.header_size = (char)(header.header_size - 148);
            header.offset_to_point_data -= 148;
        } else {
            header.version_minor = (byte)3;
            header.header_size = (char)(header.header_size - 140);
            header.offset_to_point_data -= 140;
        }
        header.global_encoding = (char)(header.global_encoding & 0xFFFFFFEF);
        header.point_data_record_length = (char)(header.point_data_record_length - 2);
        header.point_data_record_length = (char)(header.point_data_record_length + 5);
        ByteStreamOutArray out = new ByteStreamOutArray();
        char lastools_version = '\u73da';
        out.put16bitsLE(lastools_version);
        char compatible_version = '\u0003';
        out.put16bitsLE(compatible_version);
        int unused = 0;
        out.put32bitsLE(unused);
        long start_of_waveform_data_packet_record = header.start_of_waveform_data_packet_record;
        if (start_of_waveform_data_packet_record != 0L) {
            Cstdio.fprintf(stderr, "WARNING: header.start_of_waveform_data_packet_record is %lld. writing 0 instead.\n", start_of_waveform_data_packet_record);
            start_of_waveform_data_packet_record = 0L;
        }
        out.put64bitsLE(start_of_waveform_data_packet_record);
        long start_of_first_extended_variable_length_record = header.start_of_first_extended_variable_length_record;
        if (start_of_first_extended_variable_length_record != 0L) {
            Cstdio.fprintf(stderr, "WARNING: EVLRs not supported. header.start_of_first_extended_variable_length_record is %lld. writing 0 instead.\n", start_of_first_extended_variable_length_record);
            start_of_first_extended_variable_length_record = 0L;
        }
        out.put64bitsLE(start_of_first_extended_variable_length_record);
        int number_of_extended_variable_length_records = header.number_of_extended_variable_length_records;
        if (number_of_extended_variable_length_records != 0) {
            Cstdio.fprintf(stderr, "WARNING: EVLRs not supported. header.number_of_extended_variable_length_records is %d. writing 0 instead.\n", number_of_extended_variable_length_records);
            number_of_extended_variable_length_records = 0;
        }
        out.put32bitsLE(number_of_extended_variable_length_records);
        long extended_number_of_point_records = header.number_of_point_records != 0 ? (long)header.number_of_point_records : header.extended_number_of_point_records;
        out.put64bitsLE(extended_number_of_point_records);
        for (i = 0; i < 15; ++i) {
            long extended_number_of_points_by_return = i < 5 && header.number_of_points_by_return[i] != 0 ? (long)header.number_of_points_by_return[i] : header.extended_number_of_points_by_return[i];
            out.put64bitsLE(extended_number_of_points_by_return);
        }
        header.add_vlr("lascompatible\u0000\u0000", '\u56bc', '\u009c', out.takeData().array());
        LASattribute lasattribute_scan_angle = new LASattribute(3, "LAS 1.4 scan angle", "additional attributes");
        lasattribute_scan_angle.set_scale(0.006, 0);
        int index_scan_angle = header.add_attribute(lasattribute_scan_angle);
        this.start_scan_angle = header.get_attribute_start(index_scan_angle);
        LASattribute lasattribute_extended_returns = new LASattribute(0, "LAS 1.4 extended returns", "additional attributes");
        int index_extended_returns = header.add_attribute(lasattribute_extended_returns);
        this.start_extended_returns = header.get_attribute_start(index_extended_returns);
        LASattribute lasattribute_classification = new LASattribute(0, "LAS 1.4 classification", "additional attributes");
        int index_classification = header.add_attribute(lasattribute_classification);
        this.start_classification = header.get_attribute_start(index_classification);
        LASattribute lasattribute_flags_and_channel = new LASattribute(0, "LAS 1.4 flags and channel", "additional attributes");
        int index_flags_and_channel = header.add_attribute(lasattribute_flags_and_channel);
        this.start_flags_and_channel = header.get_attribute_start(index_flags_and_channel);
        if (header.point_data_format == 8 || header.point_data_format == 10) {
            LASattribute lasattribute_NIR_band = new LASattribute(2, "LAS 1.4 NIR band", "additional attributes");
            int index_NIR_band = header.add_attribute(lasattribute_NIR_band);
            this.start_NIR_band = header.get_attribute_start(index_NIR_band);
        }
        header.update_extra_bytes_vlr(Boolean.TRUE);
        header.point_data_format = header.point_data_format == 6 ? (byte)1 : (header.point_data_format <= 8 ? (byte)3 : (byte)(header.point_data_format - 5));
        if ((moveEVLRtoVLR || moveCRSfromEVLRtoVLR) && header.evlrs != null) {
            for (i = 0; i < header.number_of_extended_variable_length_records; ++i) {
                if (moveEVLRtoVLR) {
                    if (header.evlrs[i].record_length_after_header <= 65535L) {
                        header.add_vlr("LASF_Projection", header.evlrs[i].record_id, (char)header.evlrs[i].record_length_after_header, header.evlrs[i].data);
                        header.evlrs[i].record_length_after_header = 0L;
                        header.evlrs[i].data = null;
                        continue;
                    }
                    Cstdio.fprintf(stderr, "large EVLR with user ID '%s' and record ID %d with payload size %lld not moved to VLRs.\n", header.evlrs[i].user_id, Character.valueOf(header.evlrs[i].record_id), header.evlrs[i].record_length_after_header);
                    continue;
                }
                if (Cstring.strcmp(new String(header.evlrs[i].user_id), "LASF_Projection") != 0) continue;
                if (header.evlrs[i].record_id == '\u87af') {
                    header.add_vlr("LASF_Projection", header.evlrs[i].record_id, (char)header.evlrs[i].record_length_after_header, header.evlrs[i].data);
                    header.evlrs[i].record_length_after_header = 0L;
                    header.evlrs[i].data = null;
                    continue;
                }
                if (header.evlrs[i].record_id == '\u87b0') {
                    header.add_vlr("LASF_Projection", header.evlrs[i].record_id, (char)header.evlrs[i].record_length_after_header, header.evlrs[i].data);
                    header.evlrs[i].record_length_after_header = 0L;
                    header.evlrs[i].data = null;
                    continue;
                }
                if (header.evlrs[i].record_id == '\u87b1') {
                    header.add_vlr("LASF_Projection", header.evlrs[i].record_id, (char)header.evlrs[i].record_length_after_header, header.evlrs[i].data);
                    header.evlrs[i].record_length_after_header = 0L;
                    header.evlrs[i].data = null;
                    continue;
                }
                if (header.evlrs[i].record_id == '\u083f') {
                    header.add_vlr("LASF_Projection", header.evlrs[i].record_id, (char)header.evlrs[i].record_length_after_header, header.evlrs[i].data);
                    header.evlrs[i].record_length_after_header = 0L;
                    header.evlrs[i].data = null;
                    continue;
                }
                if (header.evlrs[i].record_id == '\u0840') {
                    header.add_vlr("LASF_Projection", header.evlrs[i].record_id, (char)header.evlrs[i].record_length_after_header, header.evlrs[i].data);
                    header.evlrs[i].record_length_after_header = 0L;
                    header.evlrs[i].data = null;
                    continue;
                }
                Cstdio.fprintf(stderr, "unknown LASF_Projection EVLR with record ID %d not moved to VLRs.\n", Character.valueOf(header.evlrs[i].record_id));
            }
        }
        this.writer = laswriteopener.open(header);
        if (this.writer == null) {
            return Boolean.FALSE;
        }
        this.pointCompatibleDown.init((LASquantizer)header, header.point_data_format, header.point_data_record_length, (LASattributer)header);
        return Boolean.TRUE;
    }

    @Override
    public boolean write_point(LASpoint point) {
        this.pointCompatibleDown = new LASpoint(point);
        int scan_angle_remainder = this.pointCompatibleDown.getExtended_scan_angle() - MyDefs.I16_QUANTIZE((float)this.pointCompatibleDown.getScan_angle_rank() / 0.006f);
        if (this.pointCompatibleDown.getExtended_number_of_returns() <= 7) {
            this.pointCompatibleDown.setNumber_of_returns(this.pointCompatibleDown.getExtended_number_of_returns());
            if (this.pointCompatibleDown.getExtended_return_number() <= 7) {
                this.pointCompatibleDown.setReturn_number(this.pointCompatibleDown.getExtended_return_number());
            } else {
                this.pointCompatibleDown.setReturn_number((byte)7);
            }
        } else {
            this.pointCompatibleDown.setNumber_of_returns((byte)7);
            if (this.pointCompatibleDown.getExtended_return_number() <= 4) {
                this.pointCompatibleDown.setReturn_number(this.pointCompatibleDown.getExtended_return_number());
            } else {
                int return_count_difference = this.pointCompatibleDown.getExtended_number_of_returns() - this.pointCompatibleDown.getExtended_return_number();
                if (return_count_difference <= 0) {
                    this.pointCompatibleDown.setReturn_number((byte)7);
                } else if (return_count_difference >= 3) {
                    this.pointCompatibleDown.setReturn_number((byte)4);
                } else {
                    this.pointCompatibleDown.setReturn_number((byte)(7 - return_count_difference));
                }
            }
        }
        int return_number_increment = this.pointCompatibleDown.getExtended_return_number() - this.pointCompatibleDown.getReturn_number();
        assert (return_number_increment >= 0);
        int number_of_returns_increment = this.pointCompatibleDown.getExtended_number_of_returns() - this.pointCompatibleDown.getNumber_of_returns();
        assert (number_of_returns_increment >= 0);
        if (this.pointCompatibleDown.getExtended_classification() > 31) {
            this.pointCompatibleDown.set_classification((byte)0);
        } else {
            this.pointCompatibleDown.setExtended_classification((byte)0);
        }
        byte scanner_channel = this.pointCompatibleDown.getExtended_scanner_channel();
        int overlap_bit = this.pointCompatibleDown.getExtended_classification_flags() >>> 3;
        this.pointCompatibleDown.set_attribute(this.start_scan_angle, (short)scan_angle_remainder);
        this.pointCompatibleDown.set_attribute(this.start_extended_returns, (byte)(return_number_increment << 4 | number_of_returns_increment));
        this.pointCompatibleDown.set_attribute(this.start_classification, this.pointCompatibleDown.getExtended_classification());
        this.pointCompatibleDown.set_attribute(this.start_flags_and_channel, (byte)(scanner_channel << 1 | overlap_bit));
        if (this.start_NIR_band != -1) {
            this.pointCompatibleDown.set_attribute(this.start_NIR_band, this.pointCompatibleDown.getRgb(3));
        }
        this.writer.write_point(this.pointCompatibleDown);
        ++this.p_count;
        return Boolean.TRUE;
    }

    @Override
    public boolean update_header(LASheader header, boolean use_inventory, boolean update_extra_bytes) {
        return this.writer.update_header(header, use_inventory, update_extra_bytes);
    }

    @Override
    public long close(boolean update_header) {
        long bytes = this.writer.close(update_header);
        this.npoints = this.p_count;
        this.p_count = 0L;
        return bytes;
    }
}

