/*
 * Decompiled with CFR 0.152.
 */
package com.github.mreutegg.laszip4j.laslib;

import com.github.mreutegg.laszip4j.clib.Cstdio;
import com.github.mreutegg.laszip4j.clib.Cstring;
import com.github.mreutegg.laszip4j.laslib.LASheader;
import com.github.mreutegg.laszip4j.laslib.LASvlr;
import com.github.mreutegg.laszip4j.laslib.LASwriteOpener;
import com.github.mreutegg.laszip4j.laslib.LASwriter;
import com.github.mreutegg.laszip4j.laszip.ByteStreamInArray;
import com.github.mreutegg.laszip4j.laszip.LASattributer;
import com.github.mreutegg.laszip4j.laszip.LASpoint;
import com.github.mreutegg.laszip4j.laszip.LASquantizer;
import com.github.mreutegg.laszip4j.laszip.MyDefs;
import java.io.PrintStream;

public class LASwriterCompatibleUp
extends LASwriter {
    private static final PrintStream stderr = System.err;
    private LASpoint pointCompatibleUp;
    private LASheader header = null;
    private LASwriter writer = null;
    private int start_scan_angle = -1;
    private int start_extended_returns = -1;
    private int start_classification = -1;
    private int start_flags_and_channel = -1;
    private int start_NIR_band = -1;

    @Override
    public boolean chunk() {
        return Boolean.FALSE;
    }

    public boolean open(LASheader header, LASwriteOpener laswriteopener) {
        int index_NIR_band;
        int i;
        if (header == null) {
            return Boolean.FALSE;
        }
        if (laswriteopener == null) {
            return Boolean.FALSE;
        }
        if (header.version_minor > 3) {
            return Boolean.FALSE;
        }
        if (header.point_data_format == 0) {
            return Boolean.FALSE;
        }
        if (header.point_data_format == 2) {
            return Boolean.FALSE;
        }
        if (header.point_data_format > 5) {
            return Boolean.FALSE;
        }
        LASvlr compatibility_vlr = header.get_vlr("lascompatible", 22204);
        if (compatibility_vlr == null) {
            Cstdio.fprintf(stderr, "ERROR: no compatibility VLR in header\n", new Object[0]);
            return Boolean.FALSE;
        }
        if (compatibility_vlr.record_length_after_header != '\u009c') {
            Cstdio.fprintf(stderr, "ERROR: compatibility VLR has %d instead of %d bytes in payload\n", Character.valueOf(compatibility_vlr.record_length_after_header), 156);
            return Boolean.FALSE;
        }
        int index_scan_angle = header.get_attribute_index("LAS 1.4 scan angle");
        if (index_scan_angle == -1) {
            Cstdio.fprintf(stderr, "ERROR: attribute \"LAS 1.4 scan angle\" is not in EXTRA_BYTES\n", new Object[0]);
            return Boolean.FALSE;
        }
        this.start_scan_angle = header.get_attribute_start(index_scan_angle);
        int index_extended_returns = header.get_attribute_index("LAS 1.4 extended returns");
        if (index_extended_returns == -1) {
            Cstdio.fprintf(stderr, "ERROR: attribute \"LAS 1.4 extended returns\" is not in EXTRA_BYTES\n", new Object[0]);
            return Boolean.FALSE;
        }
        this.start_extended_returns = header.get_attribute_start(index_extended_returns);
        int index_classification = header.get_attribute_index("LAS 1.4 classification");
        if (index_classification == -1) {
            Cstdio.fprintf(stderr, "ERROR: attribute \"LAS 1.4 classification\" is not in EXTRA_BYTES\n", new Object[0]);
            return Boolean.FALSE;
        }
        this.start_classification = header.get_attribute_start(index_classification);
        int index_flags_and_channel = header.get_attribute_index("LAS 1.4 flags and channel");
        if (index_flags_and_channel == -1) {
            Cstdio.fprintf(stderr, "ERROR: attribute \"LAS 1.4 flags and channel\" is not in EXTRA_BYTES\n", new Object[0]);
            return Boolean.FALSE;
        }
        this.start_flags_and_channel = header.get_attribute_start(index_flags_and_channel);
        this.header = header;
        if (header.version_minor < 3) {
            header.header_size = (char)(header.header_size + 148);
            header.offset_to_point_data += 148;
        } else if (header.version_minor == 3) {
            header.header_size = (char)(header.header_size + 140);
            header.offset_to_point_data += 140;
        }
        header.version_minor = (byte)4;
        for (i = 0; i < header.number_of_variable_length_records; ++i) {
            if (Cstring.strncmp(MyDefs.stringFromByteArray(header.vlrs[i].user_id), "LASF_Projection", 16) != 0 || header.vlrs[i].record_id != '\u0840') continue;
            header.global_encoding = (char)(header.global_encoding | 0x10);
            break;
        }
        ByteStreamInArray in = new ByteStreamInArray(compatibility_vlr.data, compatibility_vlr.record_length_after_header);
        char lastools_version = in.get16bitsLE();
        char compatible_version = in.get16bitsLE();
        if (compatible_version != '\u0003') {
            Cstdio.fprintf(stderr, "ERROR: compatibility mode version %d not implemented\n", Character.valueOf(compatible_version));
            return Boolean.FALSE;
        }
        int unused = in.get32bitsLE();
        if (unused != 0) {
            Cstdio.fprintf(stderr, "WARNING: unused is %d instead of 0\n", unused);
        }
        header.start_of_waveform_data_packet_record = in.get64bitsLE();
        header.start_of_first_extended_variable_length_record = in.get64bitsLE();
        header.number_of_extended_variable_length_records = in.get32bitsLE();
        header.extended_number_of_point_records = in.get64bitsLE();
        for (i = 0; i < 15; ++i) {
            header.extended_number_of_points_by_return[i] = in.get64bitsLE();
        }
        header.remove_vlr("lascompatible", 22204);
        header.number_of_point_records = 0;
        for (i = 0; i < 5; ++i) {
            header.number_of_points_by_return[i] = 0;
        }
        header.point_data_record_length = (char)(header.point_data_record_length + 2);
        header.point_data_record_length = (char)(header.point_data_record_length - 5);
        if ((header.point_data_format == 3 || header.point_data_format == 5) && (index_NIR_band = header.get_attribute_index("LAS 1.4 NIR band")) != -1) {
            this.start_NIR_band = header.get_attribute_start(index_NIR_band);
            header.remove_attribute(index_NIR_band);
        }
        header.remove_attribute(index_flags_and_channel);
        header.remove_attribute(index_classification);
        header.remove_attribute(index_extended_returns);
        header.remove_attribute(index_scan_angle);
        header.update_extra_bytes_vlr(Boolean.TRUE);
        header.point_data_format = header.point_data_format == 1 ? (byte)6 : (header.point_data_format == 3 ? (this.start_NIR_band != -1 ? (byte)8 : (byte)7) : (byte)(header.point_data_format + 5));
        header.clean_laszip();
        this.writer = laswriteopener.open(header);
        if (this.writer == null) {
            return Boolean.FALSE;
        }
        this.pointCompatibleUp.init((LASquantizer)header, header.point_data_format, header.point_data_record_length, (LASattributer)header);
        return Boolean.TRUE;
    }

    @Override
    public boolean write_point(LASpoint point) {
        this.pointCompatibleUp = new LASpoint(point);
        short scan_angle = point.get_attributeShort(this.start_scan_angle);
        byte extended_returns = point.get_attributeByte(this.start_extended_returns);
        byte classification = point.get_attributeByte(this.start_classification);
        byte flags_and_channel = point.get_attributeByte(this.start_flags_and_channel);
        if (this.start_NIR_band != -1) {
            this.pointCompatibleUp.setRgb(3, point.get_attributeChar(this.start_NIR_band));
        }
        int return_number_increment = extended_returns >>> 4 & 0xF;
        int number_of_returns_increment = extended_returns & 0xF;
        int scanner_channel = flags_and_channel >>> 1 & 3;
        int overlap_bit = flags_and_channel & 1;
        this.pointCompatibleUp.setExtended_scan_angle((short)(scan_angle + MyDefs.I16_QUANTIZE((float)this.pointCompatibleUp.getScan_angle_rank() / 0.006f)));
        this.pointCompatibleUp.setExtended_return_number((byte)(return_number_increment + this.pointCompatibleUp.getReturn_number()));
        this.pointCompatibleUp.setExtended_number_of_returns((byte)(number_of_returns_increment + this.pointCompatibleUp.getNumber_of_returns()));
        this.pointCompatibleUp.setExtended_classification((byte)(classification + this.pointCompatibleUp.get_classification()));
        this.pointCompatibleUp.setExtended_scanner_channel((byte)scanner_channel);
        this.pointCompatibleUp.setExtended_classification_flags((byte)(overlap_bit << 3 | this.pointCompatibleUp.getClassification() >>> 5));
        this.writer.write_point(this.pointCompatibleUp);
        ++this.p_count;
        return Boolean.TRUE;
    }

    @Override
    public boolean update_header(LASheader header, boolean use_inventory, boolean update_extra_bytes) {
        return this.writer.update_header(header, use_inventory, update_extra_bytes);
    }

    @Override
    public long close(boolean update_header) {
        long bytes = this.writer.close(update_header);
        this.npoints = this.p_count;
        this.p_count = 0L;
        return bytes;
    }
}

