/*
 * Decompiled with CFR 0.152.
 */
package com.github.mreutegg.laszip4j.laszip;

public class ArithmeticModel {
    static final int AC_BUFFER_SIZE = 1024;
    static final int AC__MinLength = 0x1000000;
    static final int AC__MaxLength = -1;
    static final int BM__LengthShift = 13;
    static final int BM__MaxCount = 8192;
    static final int DM__LengthShift = 15;
    static final int DM__MaxCount = 32768;
    private final boolean compress;
    int[] u_distribution;
    int[] u_symbol_count;
    int[] u_decoder_table;
    int u_total_count;
    int u_update_cycle;
    int u_symbols_until_update;
    int u_symbols;
    int u_last_symbol;
    int u_table_size;
    int u_table_shift;

    public ArithmeticModel(int u_symbols, boolean compress) {
        this.u_symbols = u_symbols;
        this.compress = compress;
    }

    public int init(int[] u_table) {
        int k;
        if (this.u_distribution == null) {
            if (this.u_symbols < 2 || this.u_symbols > 2048) {
                return -1;
            }
            this.u_last_symbol = this.u_symbols - 1;
            if (!this.compress && this.u_symbols > 16) {
                int table_bits = 3;
                while (this.u_symbols > 1 << table_bits + 2) {
                    ++table_bits;
                }
                this.u_table_size = 1 << table_bits;
                this.u_table_shift = 15 - table_bits;
                this.u_distribution = new int[this.u_symbols];
                this.u_decoder_table = new int[this.u_table_size + 2];
            } else {
                this.u_decoder_table = null;
                this.u_table_shift = 0;
                this.u_table_size = 0;
                this.u_distribution = new int[this.u_symbols];
            }
            this.u_symbol_count = new int[this.u_symbols];
        }
        this.u_total_count = 0;
        this.u_update_cycle = this.u_symbols;
        if (u_table != null) {
            for (k = 0; k < this.u_symbols; ++k) {
                this.u_symbol_count[k] = u_table[k];
            }
        } else {
            for (k = 0; k < this.u_symbols; ++k) {
                this.u_symbol_count[k] = 1;
            }
        }
        this.update();
        this.u_symbols_until_update = this.u_update_cycle = this.u_symbols + 6 >>> 1;
        return 0;
    }

    void update() {
        int k;
        if ((this.u_total_count += this.u_update_cycle) > 32768) {
            this.u_total_count = 0;
            for (int n = 0; n < this.u_symbols; ++n) {
                this.u_symbol_count[n] = this.u_symbol_count[n] + 1 >>> 1;
                this.u_total_count += this.u_symbol_count[n];
            }
        }
        int sum = 0;
        int s = 0;
        int scale = Integer.divideUnsigned(Integer.MIN_VALUE, this.u_total_count);
        if (this.compress || this.u_table_size == 0) {
            for (k = 0; k < this.u_symbols; ++k) {
                this.u_distribution[k] = scale * sum >>> 16;
                sum += this.u_symbol_count[k];
            }
        } else {
            for (k = 0; k < this.u_symbols; ++k) {
                this.u_distribution[k] = scale * sum >>> 16;
                sum += this.u_symbol_count[k];
                int w = this.u_distribution[k] >>> this.u_table_shift;
                while (s < w) {
                    this.u_decoder_table[++s] = k - 1;
                }
            }
            this.u_decoder_table[0] = 0;
            while (s <= this.u_table_size) {
                this.u_decoder_table[++s] = this.u_symbols - 1;
            }
        }
        this.u_update_cycle = 5 * this.u_update_cycle >>> 2;
        int max_cycle = this.u_symbols + 6 << 3;
        if (Integer.compareUnsigned(this.u_update_cycle, max_cycle) > 0) {
            this.u_update_cycle = max_cycle;
        }
        this.u_symbols_until_update = this.u_update_cycle;
    }
}

