/*
 * Decompiled with CFR 0.152.
 */
package com.github.mreutegg.laszip4j.laszip;

import com.github.mreutegg.laszip4j.laszip.ByteStreamInDataInput;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ByteStreamInStream
extends ByteStreamInDataInput {
    private final CountingInputStream cIn;

    public ByteStreamInStream(InputStream in) {
        super(null);
        this.cIn = new CountingInputStream(in);
        this.dataIn = new DataInputStream(this.cIn);
    }

    @Override
    public boolean isSeekable() {
        return false;
    }

    @Override
    public long tell() {
        return this.cIn.getCount();
    }

    @Override
    public boolean seek(long position) {
        return false;
    }

    @Override
    public boolean seekEnd(long distance) {
        return false;
    }

    @Override
    public void close() throws IOException {
        this.cIn.close();
    }

    private static class CountingInputStream
    extends FilterInputStream {
        private long count = 0L;

        CountingInputStream(InputStream in) {
            super(in);
        }

        long getCount() {
            return this.count;
        }

        @Override
        public int read() throws IOException {
            int c = super.read();
            if (c != -1) {
                ++this.count;
            }
            return c;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int num = super.read(b, off, len);
            if (num != -1) {
                this.count += (long)num;
            }
            return num;
        }
    }
}

