/*
 * Decompiled with CFR 0.152.
 */
package com.github.mreutegg.laszip4j.laszip;

import com.github.mreutegg.laszip4j.clib.Cstdio;
import com.github.mreutegg.laszip4j.laszip.LASattributer;
import com.github.mreutegg.laszip4j.laszip.LASitem;
import com.github.mreutegg.laszip4j.laszip.LASquantizer;
import com.github.mreutegg.laszip4j.laszip.LASwavepacket;
import com.github.mreutegg.laszip4j.laszip.LASzip;
import com.github.mreutegg.laszip4j.laszip.MyDefs;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class LASpoint {
    private static final PrintStream stderr = System.err;
    private final ByteBuffer point10 = ByteBuffer.allocate(20);
    private short extended_scan_angle;
    private byte extended_point_type;
    private byte extended_scanner_channel;
    private byte extended_classification_flags;
    private byte extended_classification;
    private byte extended_return_number;
    private byte extended_number_of_returns;
    public byte[] dummy = new byte[3];
    private int deleted_flag;
    private ByteBuffer gps_time = ByteBuffer.allocate(8);
    private ByteBuffer rgb = ByteBuffer.allocate(8);
    public LASwavepacket wavepacket = new LASwavepacket();
    public byte[] extra_bytes;
    public LASquantizer quantizer;
    public double[] coordinates = new double[3];
    public LASattributer attributer;
    public ByteBuffer[] point;
    public boolean have_gps_time;
    public boolean have_rgb;
    public boolean have_nir;
    public boolean have_wavepacket;
    public int extra_bytes_number;
    public int total_point_size;
    public char num_items;
    public LASitem[] items;

    public LASpoint(LASpoint other) {
        this.setX(other.getX());
        this.setY(other.getY());
        this.setZ(other.getZ());
        this.setIntensity(other.getIntensity());
        this.setReturn_number(other.getReturn_number());
        this.setNumber_of_returns(other.getNumber_of_returns());
        this.setScan_direction_flag(other.getScan_direction_flag());
        this.setEdge_of_flight_line(other.getEdge_of_flight_line());
        this.setClassification(other.getClassification());
        this.setSynthetic_flag(other.getSynthetic_flag());
        this.setKeypoint_flag(other.getKeypoint_flag());
        this.setWithheld_flag(other.getWithheld_flag());
        this.setScan_angle_rank(other.getScan_angle_rank());
        this.setUser_data(other.getUser_data());
        this.setPoint_source_ID(other.getPoint_source_ID());
        this.setDeleted_flag(other.getDeleted_flag());
        if (other.have_gps_time) {
            this.setGps_time(other.getGps_time());
        }
        if (other.have_rgb) {
            this.setRgb(0, other.getRgb(0));
            this.setRgb(1, other.getRgb(1));
            this.setRgb(2, other.getRgb(2));
            if (other.have_nir) {
                this.setRgb(3, other.getRgb(3));
            }
        }
        if (other.have_wavepacket) {
            this.wavepacket = other.wavepacket;
        }
        if (other.extra_bytes != null) {
            this.extra_bytes = new byte[other.extra_bytes.length];
            System.arraycopy(other.extra_bytes, 0, this.extra_bytes, 0, other.extra_bytes_number);
            this.extra_bytes_number = other.extra_bytes_number;
        }
        if (other.getExtended_point_type() != 0) {
            this.setExtended_classification(other.getExtended_classification());
            this.setExtended_classification_flags(other.getExtended_classification_flags());
            this.setExtended_number_of_returns(other.getExtended_number_of_returns());
            this.setExtended_return_number(other.getExtended_return_number());
            this.setExtended_scan_angle(other.getExtended_scan_angle());
            this.setExtended_scanner_channel(other.getExtended_scanner_channel());
        }
    }

    void copy_to(byte[] buffer) {
        int b = 0;
        for (int i = 0; i < this.num_items; ++i) {
            System.arraycopy(this.point[i].array(), 0, buffer, b, this.items[i].size);
            b += this.items[i].size;
        }
    }

    void copy_from(byte[] buffer) {
        int b = 0;
        for (int i = 0; i < this.num_items; ++i) {
            this.point[i] = ByteBuffer.allocate(this.items[i].size);
            System.arraycopy(buffer, b, this.point[i].array(), 0, this.point[i].capacity());
            b += this.items[i].size;
        }
    }

    public boolean init(LASquantizer quantizer, byte point_type, char point_size, LASattributer attributer) {
        this.clean();
        char[] _num_items = new char[1];
        LASitem[][] _items = new LASitem[1][];
        if (!new LASzip().setup(_num_items, _items, point_type, point_size, '\u0000')) {
            Cstdio.fprintf(stderr, "ERROR: unknown point type %d with point size %d\n", point_type, point_size);
            return Boolean.FALSE;
        }
        this.num_items = _num_items[0];
        this.items = _items[0];
        this.point = new ByteBuffer[this.num_items];
        block9: for (int i = 0; i < this.num_items; ++i) {
            this.total_point_size += this.items[i].size;
            switch (this.items[i].type) {
                case POINT14: {
                    this.have_gps_time = Boolean.TRUE;
                    this.setExtended_point_type((byte)1);
                }
                case POINT10: {
                    this.point[i] = ByteBuffer.wrap(this.point10.array());
                    continue block9;
                }
                case GPSTIME11: {
                    this.have_gps_time = Boolean.TRUE;
                    this.point[i] = ByteBuffer.wrap(this.gps_time.array());
                    continue block9;
                }
                case RGBNIR14: {
                    this.have_nir = Boolean.TRUE;
                }
                case RGB12: {
                    this.have_rgb = Boolean.TRUE;
                    this.point[i] = ByteBuffer.wrap(this.rgb.array());
                    continue block9;
                }
                case WAVEPACKET13: {
                    this.have_wavepacket = Boolean.TRUE;
                    this.point[i] = ByteBuffer.wrap(this.wavepacket.asByteArray());
                    continue block9;
                }
                case BYTE: {
                    this.extra_bytes_number = this.items[i].size;
                    this.extra_bytes = new byte[this.extra_bytes_number];
                    this.point[i] = ByteBuffer.wrap(this.extra_bytes);
                    continue block9;
                }
                default: {
                    return Boolean.FALSE;
                }
            }
        }
        this.quantizer = quantizer;
        this.attributer = attributer;
        return Boolean.TRUE;
    }

    public boolean init(LASquantizer quantizer, int u_num_items, LASitem[] items, LASattributer attributer) {
        this.clean();
        this.num_items = (char)u_num_items;
        this.items = new LASitem[u_num_items];
        this.point = new ByteBuffer[u_num_items];
        int u_i = 0;
        while (Integer.compareUnsigned(u_i, u_num_items) < 0) {
            this.items[u_i] = items[u_i];
            this.total_point_size += items[u_i].size;
            switch (items[u_i].type) {
                case POINT14: {
                    this.have_gps_time = Boolean.TRUE;
                    this.setExtended_point_type((byte)1);
                }
                case POINT10: {
                    this.point[u_i] = ByteBuffer.wrap(this.point10.array());
                    break;
                }
                case GPSTIME11: {
                    this.have_gps_time = Boolean.TRUE;
                    this.point[u_i] = ByteBuffer.wrap(this.gps_time.array());
                    break;
                }
                case RGBNIR14: {
                    this.have_nir = Boolean.TRUE;
                }
                case RGB12: {
                    this.have_rgb = Boolean.TRUE;
                    this.point[u_i] = ByteBuffer.wrap(this.rgb.array());
                    break;
                }
                case WAVEPACKET13: {
                    this.have_wavepacket = Boolean.TRUE;
                    this.point[u_i] = ByteBuffer.wrap(this.wavepacket.asByteArray());
                    break;
                }
                case BYTE: {
                    this.extra_bytes_number = items[u_i].size;
                    this.extra_bytes = new byte[this.extra_bytes_number];
                    this.point[u_i] = ByteBuffer.wrap(this.extra_bytes);
                    break;
                }
                default: {
                    return Boolean.FALSE;
                }
            }
            ++u_i;
        }
        this.quantizer = quantizer;
        this.attributer = attributer;
        return Boolean.TRUE;
    }

    public boolean inside_rectangle(double r_min_x, double r_min_y, double r_max_x, double r_max_y) {
        double xy = this.get_x();
        if (xy < r_min_x || xy >= r_max_x) {
            return Boolean.FALSE;
        }
        xy = this.get_y();
        if (xy < r_min_y || xy >= r_max_y) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public boolean inside_tile(float ll_x, float ll_y, float ur_x, float ur_y) {
        double xy = this.get_x();
        if (xy < (double)ll_x || xy >= (double)ur_x) {
            return Boolean.FALSE;
        }
        xy = this.get_y();
        if (xy < (double)ll_y || xy >= (double)ur_y) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public boolean inside_circle(double center_x, double center_y, double squared_radius) {
        double dy;
        double dx = center_x - this.get_x();
        return dx * dx + (dy = center_y - this.get_y()) * dy < squared_radius;
    }

    public boolean inside_box(double min_x, double min_y, double min_z, double max_x, double max_y, double max_z) {
        double xyz = this.get_x();
        if (xyz < min_x || xyz >= max_x) {
            return Boolean.FALSE;
        }
        xyz = this.get_y();
        if (xyz < min_y || xyz >= max_y) {
            return Boolean.FALSE;
        }
        xyz = this.get_z();
        if (xyz < min_z || xyz >= max_z) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    boolean inside_bounding_box(double min_x, double min_y, double min_z, double max_x, double max_y, double max_z) {
        double xyz = this.get_x();
        if (xyz < min_x || xyz > max_x) {
            return Boolean.FALSE;
        }
        xyz = this.get_y();
        if (xyz < min_y || xyz > max_y) {
            return Boolean.FALSE;
        }
        xyz = this.get_z();
        if (xyz < min_z || xyz > max_z) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    boolean is_zero() {
        if (this.getX() != 0) {
            return Boolean.FALSE;
        }
        if (this.have_gps_time && this.getGps_time() != 0.0) {
            return Boolean.FALSE;
        }
        if (this.have_rgb) {
            if (this.getRgb(0) != '\u0000' || this.getRgb(1) != '\u0000' || this.getRgb(2) != '\u0000') {
                return Boolean.FALSE;
            }
            if (this.have_nir && this.getRgb(3) != '\u0000') {
                return Boolean.FALSE;
            }
        }
        return Boolean.TRUE;
    }

    void zero() {
        this.setX(0);
        this.setY(0);
        this.setZ(0);
        this.setIntensity('\u0000');
        this.setReturn_number((byte)1);
        this.setNumber_of_returns((byte)1);
        this.setScan_direction_flag((byte)0);
        this.setEdge_of_flight_line((byte)0);
        this.setClassification((byte)0);
        this.setSynthetic_flag((byte)0);
        this.setKeypoint_flag((byte)0);
        this.setWithheld_flag((byte)0);
        this.setScan_angle_rank((byte)0);
        this.setUser_data((byte)0);
        this.setPoint_source_ID('\u0000');
        this.setExtended_scan_angle((short)0);
        this.setExtended_scanner_channel((byte)0);
        this.setExtended_classification_flags((byte)0);
        this.setExtended_classification((byte)0);
        this.setExtended_return_number((byte)1);
        this.setExtended_number_of_returns((byte)1);
        this.setDeleted_flag(0);
        this.setGps_time(0.0);
        this.setRgb(0, '\u0000');
        this.setRgb(1, '\u0000');
        this.setRgb(2, '\u0000');
        this.setRgb(3, '\u0000');
        this.wavepacket.zero();
    }

    void clean() {
        this.zero();
        this.extra_bytes = null;
        this.point = null;
        this.have_gps_time = Boolean.FALSE;
        this.have_rgb = Boolean.FALSE;
        this.have_wavepacket = Boolean.FALSE;
        this.have_nir = Boolean.FALSE;
        this.extra_bytes_number = 0;
        this.total_point_size = 0;
        this.num_items = '\u0000';
        this.items = null;
        this.setExtended_point_type((byte)0);
    }

    public LASpoint() {
        this.extra_bytes = null;
        this.point = null;
        this.items = null;
        this.clean();
    }

    public boolean is_first() {
        return this.get_return_number() <= 1;
    }

    public boolean is_intermediate() {
        return !this.is_first() && !this.is_last();
    }

    public boolean is_last() {
        return this.get_return_number() >= this.get_number_of_returns();
    }

    public boolean is_single() {
        return this.get_number_of_returns() <= 1;
    }

    public boolean is_first_of_many() {
        return !this.is_single() && this.is_first();
    }

    public boolean is_last_of_many() {
        return !this.is_single() && this.is_last();
    }

    public int get_X() {
        return this.getX();
    }

    public int get_Y() {
        return this.getY();
    }

    public int get_Z() {
        return this.getZ();
    }

    public char get_intensity() {
        return this.getIntensity();
    }

    public byte get_return_number() {
        return this.getReturn_number();
    }

    public byte get_number_of_returns() {
        return this.getNumber_of_returns();
    }

    public byte get_scan_direction_flag() {
        return this.getScan_direction_flag();
    }

    public byte get_edge_of_flight_line() {
        return this.getEdge_of_flight_line();
    }

    public byte get_classification() {
        return this.getClassification();
    }

    public byte get_synthetic_flag() {
        return this.getSynthetic_flag();
    }

    public byte get_keypoint_flag() {
        return this.getKeypoint_flag();
    }

    public byte get_withheld_flag() {
        return this.getWithheld_flag();
    }

    public byte get_scan_angle_rank() {
        return this.getScan_angle_rank();
    }

    public byte get_user_data() {
        return this.getUser_data();
    }

    public char get_point_source_ID() {
        return this.getPoint_source_ID();
    }

    public int get_deleted_flag() {
        return this.getDeleted_flag();
    }

    public double get_gps_time() {
        return this.getGps_time();
    }

    public char[] get_rgb() {
        return this.getRgb();
    }

    public char get_R() {
        return this.getRgb(0);
    }

    public char get_G() {
        return this.getRgb(1);
    }

    public char get_B() {
        return this.getRgb(2);
    }

    public char get_I() {
        return this.getRgb(3);
    }

    public void set_X(int X) {
        this.setX(X);
    }

    public void set_Y(int Y) {
        this.setY(Y);
    }

    public void set_Z(int Z) {
        this.setZ(Z);
    }

    public void set_intensity(char intensity) {
        this.setIntensity(intensity);
    }

    public void set_return_number(byte return_number) {
        this.setReturn_number(return_number > 7 ? (byte)7 : (byte)return_number);
    }

    public void set_number_of_returns(byte number_of_returns) {
        this.setNumber_of_returns(number_of_returns > 7 ? (byte)7 : (byte)number_of_returns);
    }

    public void set_scan_direction_flag(byte scan_direction_flag) {
        this.setScan_direction_flag(scan_direction_flag);
    }

    public void set_edge_of_flight_line(byte edge_of_flight_line) {
        this.setEdge_of_flight_line(edge_of_flight_line);
    }

    public void set_classification(byte classification) {
        this.setClassification((byte)(classification & 0x1F));
    }

    public void set_synthetic_flag(byte synthetic_flag) {
        this.setSynthetic_flag(synthetic_flag);
    }

    public void set_keypoint_flag(byte keypoint_flag) {
        this.setKeypoint_flag(keypoint_flag);
    }

    public void set_withheld_flag(byte withheld_flag) {
        this.setWithheld_flag(withheld_flag);
    }

    public void set_scan_angle_rank(byte scan_angle_rank) {
        this.setScan_angle_rank(scan_angle_rank);
    }

    public void set_user_data(byte user_data) {
        this.setUser_data(user_data);
    }

    public void set_point_source_ID(char point_source_ID) {
        this.setPoint_source_ID(point_source_ID);
    }

    public void set_deleted_flag(byte deleted_flag) {
        this.setDeleted_flag(Byte.toUnsignedInt(deleted_flag));
    }

    public void set_gps_time(double gps_time) {
        this.setGps_time(gps_time);
    }

    public void set_RGB(char[] rgb) {
        this.setRgb(rgb);
    }

    public void set_RGBI(char[] rgb) {
        this.setRgb(rgb);
    }

    public void set_R(char R) {
        this.setRgb(0, R);
    }

    public void set_G(char G) {
        this.setRgb(1, G);
    }

    public void set_B(char B) {
        this.setRgb(2, B);
    }

    public void set_I(char I) {
        this.setRgb(3, I);
    }

    public double get_x() {
        return this.quantizer.get_x(this.getX());
    }

    public double get_y() {
        return this.quantizer.get_y(this.getY());
    }

    public double get_z() {
        return this.quantizer.get_z(this.getZ());
    }

    public void set_x(double x) {
        this.setX(this.quantizer.get_X(x));
    }

    public void set_y(double y) {
        this.setY(this.quantizer.get_Y(y));
    }

    public void set_z(double z) {
        this.setZ(this.quantizer.get_Z(z));
    }

    public byte get_extended_classification() {
        return this.getExtended_classification();
    }

    public byte get_extended_return_number() {
        return this.getExtended_return_number();
    }

    public byte get_extended_number_of_returns() {
        return this.getExtended_number_of_returns();
    }

    public short get_extended_scan_angle() {
        return this.getExtended_scan_angle();
    }

    public byte get_extended_overlap_flag() {
        return (byte)(this.getExtended_classification_flags() >>> 3);
    }

    public byte get_extended_scanner_channel() {
        return this.getExtended_scanner_channel();
    }

    public void set_extended_classification(byte u_extended_classification) {
        this.setExtended_classification(u_extended_classification);
    }

    public void set_extended_scan_angle(short u_extended_scan_angle) {
        this.setExtended_scan_angle(u_extended_scan_angle);
    }

    public void set_extended_overlap_flag(byte u_extended_overlap_flag) {
        this.setExtended_classification_flags((byte)(u_extended_overlap_flag << 3 | this.getExtended_classification_flags() & 7));
    }

    public void set_extended_scanner_channel(byte u_extended_scanner_channel) {
        this.setExtended_scanner_channel(u_extended_scanner_channel);
    }

    public float get_scan_angle() {
        if (this.getExtended_point_type() != 0) {
            return 0.006f * (float)this.getExtended_scan_angle();
        }
        return this.getScan_angle_rank();
    }

    public float get_abs_scan_angle() {
        if (this.getExtended_point_type() != 0) {
            return this.getExtended_scan_angle() < 0 ? -0.006f * (float)this.getExtended_scan_angle() : 0.006f * (float)this.getExtended_scan_angle();
        }
        return this.getScan_angle_rank() < 0 ? (float)(-this.getScan_angle_rank()) : (float)this.getScan_angle_rank();
    }

    public void compute_coordinates() {
        this.coordinates[0] = this.get_x();
        this.coordinates[1] = this.get_y();
        this.coordinates[2] = this.get_z();
    }

    public void compute_XYZ() {
        this.set_x(this.coordinates[0]);
        this.set_y(this.coordinates[1]);
        this.set_z(this.coordinates[2]);
    }

    public void compute_XYZ(LASquantizer quantizer) {
        this.setX(quantizer.get_X(this.coordinates[0]));
        this.setY(quantizer.get_Y(this.coordinates[1]));
        this.setZ(quantizer.get_Z(this.coordinates[2]));
    }

    public boolean has_attribute(int index) {
        if (this.attributer != null && index < this.attributer.number_attributes) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public boolean get_attribute(int index, byte[] data) {
        if (this.has_attribute(index)) {
            System.arraycopy(this.extra_bytes, this.attributer.attribute_starts.get(index), data, 0, this.attributer.attribute_sizes.get(index));
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public boolean set_attribute(int index, byte[] data) {
        if (this.has_attribute(index)) {
            System.arraycopy(data, 0, this.extra_bytes, this.attributer.attribute_starts.get(index), this.attributer.attribute_sizes.get(index));
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public String get_attribute_name(int index) {
        if (this.has_attribute(index)) {
            return MyDefs.stringFromByteArray(this.attributer.attributes.get((int)index).name);
        }
        return null;
    }

    public double get_attribute_as_float(int index) {
        if (this.has_attribute(index)) {
            int start = this.attributer.attribute_starts.get(index);
            byte[] data = new byte[Math.min(8, this.extra_bytes.length - start)];
            ByteBuffer.wrap(this.extra_bytes).order(ByteOrder.LITTLE_ENDIAN).get(data, start, data.length);
            return this.attributer.attributes.get(index).get_value_as_float(data);
        }
        return 0.0;
    }

    public byte get_attributeUByte(int start) {
        return this.extra_bytes[start];
    }

    public void set_attributeU(int start, byte data) {
        this.extra_bytes[start] = data;
    }

    public byte get_attributeByte(int start) {
        return this.extra_bytes[start];
    }

    public void set_attribute(int start, byte data) {
        this.extra_bytes[start] = data;
    }

    public char get_attributeChar(int start) {
        return ByteBuffer.wrap(this.extra_bytes).order(ByteOrder.LITTLE_ENDIAN).getChar(start);
    }

    public void set_attribute(int start, char data) {
        ByteBuffer.wrap(this.extra_bytes).order(ByteOrder.LITTLE_ENDIAN).putChar(start, data);
    }

    public short get_attributeShort(int start) {
        return ByteBuffer.wrap(this.extra_bytes).order(ByteOrder.LITTLE_ENDIAN).getShort(start);
    }

    public void set_attribute(int start, short data) {
        ByteBuffer.wrap(this.extra_bytes).order(ByteOrder.LITTLE_ENDIAN).putShort(start, data);
    }

    public int get_attributeUInt(int start) {
        return ByteBuffer.wrap(this.extra_bytes).order(ByteOrder.LITTLE_ENDIAN).getInt(start);
    }

    public void set_attributeU(int start, int data) {
        ByteBuffer.wrap(this.extra_bytes).order(ByteOrder.LITTLE_ENDIAN).putInt(start, data);
    }

    public int get_attributeInt(int start) {
        return ByteBuffer.wrap(this.extra_bytes).order(ByteOrder.LITTLE_ENDIAN).getInt(start);
    }

    public void set_attribute(int start, int data) {
        ByteBuffer.wrap(this.extra_bytes).order(ByteOrder.LITTLE_ENDIAN).putInt(start, data);
    }

    public long get_attributeULong(int start) {
        return ByteBuffer.wrap(this.extra_bytes).order(ByteOrder.LITTLE_ENDIAN).getLong(start);
    }

    public void set_attributeU(int start, long data) {
        ByteBuffer.wrap(this.extra_bytes).order(ByteOrder.LITTLE_ENDIAN).putLong(start, data);
    }

    public long get_attributeLong(int start) {
        return ByteBuffer.wrap(this.extra_bytes).order(ByteOrder.LITTLE_ENDIAN).getLong(start);
    }

    public void set_attribute(int start, long data) {
        ByteBuffer.wrap(this.extra_bytes).order(ByteOrder.LITTLE_ENDIAN).putLong(start, data);
    }

    public float get_attributeFloat(int start) {
        return ByteBuffer.wrap(this.extra_bytes).order(ByteOrder.LITTLE_ENDIAN).getFloat(start);
    }

    public void set_attribute(int start, float data) {
        ByteBuffer.wrap(this.extra_bytes).order(ByteOrder.LITTLE_ENDIAN).putFloat(start, data);
    }

    public double get_attributeDouble(int start) {
        return ByteBuffer.wrap(this.extra_bytes).order(ByteOrder.LITTLE_ENDIAN).getDouble(start);
    }

    public void set_attribute(int start, double data) {
        ByteBuffer.wrap(this.extra_bytes).order(ByteOrder.LITTLE_ENDIAN).putDouble(start, data);
    }

    public byte[] asTwentyBytes() {
        ByteBuffer buffer = ByteBuffer.allocate(20).order(ByteOrder.LITTLE_ENDIAN);
        buffer.putInt(this.getX());
        buffer.putInt(this.getY());
        buffer.putInt(this.getZ());
        buffer.putChar(this.getIntensity());
        buffer.put((byte)(this.getReturn_number() & this.getNumber_of_returns() << 3 & this.getScan_direction_flag() << 6 & this.getEdge_of_flight_line() << 7));
        buffer.put((byte)(this.getClassification() & this.getSynthetic_flag() << 5 & this.getKeypoint_flag() << 6 & this.getWithheld_flag() << 7));
        buffer.put(this.getScan_angle_rank());
        buffer.put(this.getUser_data());
        buffer.putChar(this.getPoint_source_ID());
        return buffer.array();
    }

    private static byte[] toByteArray(char[] data) {
        byte[] bytes = new byte[data.length * 2];
        ByteBuffer buffer = ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN);
        for (char c : data) {
            buffer.putChar(c);
        }
        return bytes;
    }

    private byte[] toByteArray(double data) {
        byte[] bytes = new byte[8];
        ByteBuffer buffer = ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN);
        buffer.putDouble(data);
        return bytes;
    }

    private byte[] toByteArray(int data) {
        byte[] bytes = new byte[4];
        ByteBuffer buffer = ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN);
        buffer.putInt(data);
        return bytes;
    }

    public int getX() {
        return this.point10.getInt(0);
    }

    public void setX(int x) {
        this.point10.putInt(0, x);
    }

    public int getY() {
        return this.point10.getInt(4);
    }

    public void setY(int y) {
        this.point10.putInt(4, y);
    }

    public int getZ() {
        return this.point10.getInt(8);
    }

    public void setZ(int z) {
        this.point10.putInt(8, z);
    }

    public char getIntensity() {
        return this.point10.getChar(12);
    }

    public void setIntensity(char intensity) {
        this.point10.putChar(12, intensity);
    }

    public byte getReturn_number() {
        byte b = this.point10.get(14);
        return (byte)(b & 7);
    }

    public void setReturn_number(byte return_number) {
        byte b = this.point10.get(14);
        b = (byte)(b & 0xFFFFFFF8);
        b = (byte)(b & (return_number & 7));
        this.point10.put(14, b);
    }

    public byte getNumber_of_returns() {
        byte b = this.point10.get(14);
        return (byte)(b >>> 3 & 7);
    }

    public void setNumber_of_returns(byte number_of_returns) {
        byte b = this.point10.get(14);
        b = (byte)(b & 0xFFFFFFC7);
        b = (byte)(b & (number_of_returns << 3 & 0x38));
        this.point10.put(14, b);
    }

    public byte getScan_direction_flag() {
        byte b = this.point10.get(14);
        return (byte)(b >>> 6 & 1);
    }

    public void setScan_direction_flag(byte scan_direction_flag) {
        byte b = this.point10.get(14);
        b = (byte)(b & 0xFFFFFFBF);
        b = (byte)(b & (scan_direction_flag << 6 & 0x40));
        this.point10.put(14, b);
    }

    public byte getEdge_of_flight_line() {
        byte b = this.point10.get(14);
        return (byte)(b >>> 7 & 1);
    }

    public void setEdge_of_flight_line(byte edge_of_flight_line) {
        byte b = this.point10.get(14);
        b = (byte)(b & 0xFFFFFF7F);
        b = (byte)(b & (edge_of_flight_line << 7 & 0x80));
        this.point10.put(14, b);
    }

    public byte getClassification() {
        byte b = this.point10.get(15);
        return (byte)(b & 0x1F);
    }

    public void setClassification(byte classification) {
        byte b = this.point10.get(15);
        b = (byte)(b & 0xFFFFFFE0);
        b = (byte)(b & (classification & 0x1F));
        this.point10.put(15, b);
    }

    public byte getSynthetic_flag() {
        byte b = this.point10.get(15);
        return (byte)(b >>> 5 & 1);
    }

    public void setSynthetic_flag(byte synthetic_flag) {
        byte b = this.point10.get(15);
        b = (byte)(b & 0xFFFFFFDF);
        b = (byte)(b & (synthetic_flag << 5 & 0x20));
        this.point10.put(15, b);
    }

    public byte getKeypoint_flag() {
        byte b = this.point10.get(15);
        return (byte)(b >>> 6 & 1);
    }

    public void setKeypoint_flag(byte keypoint_flag) {
        byte b = this.point10.get(15);
        b = (byte)(b & 0xFFFFFFBF);
        b = (byte)(b & (keypoint_flag << 6 & 0x40));
        this.point10.put(15, b);
    }

    public byte getWithheld_flag() {
        byte b = this.point10.get(15);
        return (byte)(b >>> 7 & 1);
    }

    public void setWithheld_flag(byte withheld_flag) {
        byte b = this.point10.get(15);
        b = (byte)(b & 0xFFFFFF7F);
        b = (byte)(b & (withheld_flag << 7 & 0x80));
        this.point10.put(15, b);
    }

    public byte getScan_angle_rank() {
        return this.point10.get(16);
    }

    public void setScan_angle_rank(byte scan_angle_rank) {
        this.point10.put(16, scan_angle_rank);
    }

    public byte getUser_data() {
        return this.point10.get(17);
    }

    public void setUser_data(byte user_data) {
        this.point10.put(17, user_data);
    }

    public char getPoint_source_ID() {
        return this.point10.getChar(18);
    }

    public void setPoint_source_ID(char point_source_ID) {
        this.point10.putChar(18, point_source_ID);
    }

    public short getExtended_scan_angle() {
        return this.extended_scan_angle;
    }

    public void setExtended_scan_angle(short extended_scan_angle) {
        this.extended_scan_angle = extended_scan_angle;
    }

    public byte getExtended_point_type() {
        return this.extended_point_type;
    }

    public void setExtended_point_type(byte extended_point_type) {
        this.extended_point_type = extended_point_type;
    }

    public byte getExtended_scanner_channel() {
        return this.extended_scanner_channel;
    }

    public void setExtended_scanner_channel(byte extended_scanner_channel) {
        this.extended_scanner_channel = extended_scanner_channel;
    }

    public byte getExtended_classification_flags() {
        return this.extended_classification_flags;
    }

    public void setExtended_classification_flags(byte extended_classification_flags) {
        this.extended_classification_flags = extended_classification_flags;
    }

    public byte getExtended_classification() {
        return this.extended_classification;
    }

    public void setExtended_classification(byte extended_classification) {
        this.extended_classification = extended_classification;
    }

    public byte getExtended_return_number() {
        return this.extended_return_number;
    }

    public void setExtended_return_number(byte extended_return_number) {
        this.extended_return_number = extended_return_number;
    }

    public byte getExtended_number_of_returns() {
        return this.extended_number_of_returns;
    }

    public void setExtended_number_of_returns(byte extended_number_of_returns) {
        this.extended_number_of_returns = extended_number_of_returns;
    }

    public int getDeleted_flag() {
        return this.deleted_flag;
    }

    public void setDeleted_flag(int deleted_flag) {
        this.deleted_flag = deleted_flag;
    }

    public double getGps_time() {
        return this.gps_time.getDouble(0);
    }

    public void setGps_time(double gps_time) {
        this.gps_time.putDouble(0, gps_time);
    }

    public char getRgb(int index) {
        return this.rgb.getChar(index * 2);
    }

    public char[] getRgb() {
        char[] rgb = new char[4];
        for (int i = 0; i < rgb.length; ++i) {
            rgb[i] = this.rgb.getChar(i * 2);
        }
        return rgb;
    }

    public void setRgb(int index, char value) {
        this.rgb.putChar(index * 2, value);
    }

    public void setRgb(char[] rgb) {
        for (int i = 0; i < rgb.length; ++i) {
            this.rgb.putChar(i * 2, rgb[i]);
        }
    }
}

