/*
 * Decompiled with CFR 0.152.
 */
package com.github.mreutegg.laszip4j.laszip;

import com.github.mreutegg.laszip4j.clib.Cstring;
import com.github.mreutegg.laszip4j.laszip.ArithmeticDecoder;
import com.github.mreutegg.laszip4j.laszip.ArithmeticModel;
import com.github.mreutegg.laszip4j.laszip.LASreadItemCompressed;
import com.github.mreutegg.laszip4j.laszip.MyDefs;

public class LASreadItemCompressed_BYTE_v2
extends LASreadItemCompressed {
    private ArithmeticDecoder dec;
    private int number;
    private byte[] last_item;
    private ArithmeticModel[] m_byte;

    public LASreadItemCompressed_BYTE_v2(ArithmeticDecoder dec, int number) {
        assert (dec != null);
        this.dec = dec;
        assert (number != 0);
        this.number = number;
        this.m_byte = new ArithmeticModel[number];
        for (int i = 0; i < number; ++i) {
            this.m_byte[i] = dec.createSymbolModel(256);
        }
        this.last_item = new byte[number];
    }

    @Override
    public boolean init(byte[] item) {
        for (int i = 0; i < this.number; ++i) {
            this.dec.initSymbolModel(this.m_byte[i]);
        }
        Cstring.memcpy(this.last_item, item, this.number);
        return Boolean.TRUE;
    }

    @Override
    public void read(byte[] item) {
        for (int i = 0; i < this.number; ++i) {
            int value = this.last_item[i] + this.dec.decodeSymbol(this.m_byte[i]);
            item[i] = MyDefs.U8_FOLD(value);
        }
        Cstring.memcpy(this.last_item, item, this.number);
    }
}

