/*
 * Decompiled with CFR 0.152.
 */
package com.github.mreutegg.laszip4j.laszip;

import com.github.mreutegg.laszip4j.clib.Cstring;
import com.github.mreutegg.laszip4j.laszip.ArithmeticDecoder;
import com.github.mreutegg.laszip4j.laszip.ArithmeticModel;
import com.github.mreutegg.laszip4j.laszip.IntegerCompressor;
import com.github.mreutegg.laszip4j.laszip.LASreadItemCompressed;
import java.nio.ByteBuffer;

public class LASreadItemCompressed_POINT10_v1
extends LASreadItemCompressed {
    private ArithmeticDecoder dec;
    private byte[] last_item = new byte[20];
    private int[] last_x_diff = new int[3];
    private int[] last_y_diff = new int[3];
    private int last_incr;
    private IntegerCompressor ic_dx;
    private IntegerCompressor ic_dy;
    private IntegerCompressor ic_z;
    private IntegerCompressor ic_intensity;
    private IntegerCompressor ic_scan_angle_rank;
    private IntegerCompressor ic_point_source_ID;
    private ArithmeticModel m_changed_values;
    private ArithmeticModel[] m_bit_byte = new ArithmeticModel[256];
    private ArithmeticModel[] m_classification = new ArithmeticModel[256];
    private ArithmeticModel[] m_user_data = new ArithmeticModel[256];

    public LASreadItemCompressed_POINT10_v1(ArithmeticDecoder dec) {
        assert (dec != null);
        this.dec = dec;
        this.ic_dx = new IntegerCompressor(dec, 32);
        this.ic_dy = new IntegerCompressor(dec, 32, 20);
        this.ic_z = new IntegerCompressor(dec, 32, 20);
        this.ic_intensity = new IntegerCompressor(dec, 16);
        this.ic_scan_angle_rank = new IntegerCompressor(dec, 8, 2);
        this.ic_point_source_ID = new IntegerCompressor(dec, 16);
        this.m_changed_values = dec.createSymbolModel(64);
        for (int i = 0; i < 256; ++i) {
            this.m_bit_byte[i] = null;
            this.m_classification[i] = null;
            this.m_user_data[i] = null;
        }
    }

    @Override
    public boolean init(byte[] item) {
        this.last_x_diff[2] = 0;
        this.last_x_diff[1] = 0;
        this.last_x_diff[0] = 0;
        this.last_y_diff[2] = 0;
        this.last_y_diff[1] = 0;
        this.last_y_diff[0] = 0;
        this.last_incr = 0;
        this.ic_dx.initDecompressor();
        this.ic_dy.initDecompressor();
        this.ic_z.initDecompressor();
        this.ic_intensity.initDecompressor();
        this.ic_scan_angle_rank.initDecompressor();
        this.ic_point_source_ID.initDecompressor();
        this.dec.initSymbolModel(this.m_changed_values);
        for (int i = 0; i < 256; ++i) {
            if (this.m_bit_byte[i] != null) {
                this.dec.initSymbolModel(this.m_bit_byte[i]);
            }
            if (this.m_classification[i] != null) {
                this.dec.initSymbolModel(this.m_classification[i]);
            }
            if (this.m_user_data[i] == null) continue;
            this.dec.initSymbolModel(this.m_user_data[i]);
        }
        Cstring.memcpy(this.last_item, item, 20);
        return Boolean.TRUE;
    }

    @Override
    public void read(byte[] item) {
        int median_x = this.last_x_diff[0] < this.last_x_diff[1] ? (this.last_x_diff[1] < this.last_x_diff[2] ? this.last_x_diff[1] : (this.last_x_diff[0] < this.last_x_diff[2] ? this.last_x_diff[2] : this.last_x_diff[0])) : (this.last_x_diff[0] < this.last_x_diff[2] ? this.last_x_diff[0] : (this.last_x_diff[1] < this.last_x_diff[2] ? this.last_x_diff[2] : this.last_x_diff[1]));
        int median_y = this.last_y_diff[0] < this.last_y_diff[1] ? (this.last_y_diff[1] < this.last_y_diff[2] ? this.last_y_diff[1] : (this.last_y_diff[0] < this.last_y_diff[2] ? this.last_y_diff[2] : this.last_y_diff[0])) : (this.last_y_diff[0] < this.last_y_diff[2] ? this.last_y_diff[0] : (this.last_y_diff[1] < this.last_y_diff[2] ? this.last_y_diff[2] : this.last_y_diff[1]));
        int x_diff = this.ic_dx.decompress(median_x);
        LASpoint10 lp = LASpoint10.wrap(this.last_item);
        lp.setX(lp.getX() + x_diff);
        int k_bits = this.ic_dx.getK();
        int y_diff = this.ic_dy.decompress(median_y, k_bits < 19 ? k_bits : 19);
        lp.setY(lp.getY() + y_diff);
        k_bits = (k_bits + this.ic_dy.getK()) / 2;
        lp.setZ(this.ic_z.decompress(lp.getZ(), k_bits < 19 ? k_bits : 19));
        int changed_values = this.dec.decodeSymbol(this.m_changed_values);
        if (changed_values != 0) {
            if ((changed_values & 0x20) != 0) {
                lp.setIntensity((char)this.ic_intensity.decompress(lp.getIntensity()));
            }
            if ((changed_values & 0x10) != 0) {
                if (this.m_bit_byte[this.last_item[14]] == null) {
                    this.m_bit_byte[this.last_item[14]] = this.dec.createSymbolModel(256);
                    this.dec.initSymbolModel(this.m_bit_byte[this.last_item[14]]);
                }
                this.last_item[14] = (byte)this.dec.decodeSymbol(this.m_bit_byte[this.last_item[14]]);
            }
            if ((changed_values & 8) != 0) {
                if (this.m_classification[this.last_item[15]] == null) {
                    this.m_classification[this.last_item[15]] = this.dec.createSymbolModel(256);
                    this.dec.initSymbolModel(this.m_classification[this.last_item[15]]);
                }
                this.last_item[15] = (byte)this.dec.decodeSymbol(this.m_classification[this.last_item[15]]);
            }
            if ((changed_values & 4) != 0) {
                this.last_item[16] = (byte)this.ic_scan_angle_rank.decompress(this.last_item[16], k_bits < 3 ? 1 : 0);
            }
            if ((changed_values & 2) != 0) {
                if (this.m_user_data[this.last_item[17]] == null) {
                    this.m_user_data[this.last_item[17]] = this.dec.createSymbolModel(256);
                    this.dec.initSymbolModel(this.m_user_data[this.last_item[17]]);
                }
                this.last_item[17] = (byte)this.dec.decodeSymbol(this.m_user_data[this.last_item[17]]);
            }
            if ((changed_values & 1) != 0) {
                lp.setPoint_source_ID((char)this.ic_point_source_ID.decompress(lp.getPoint_source_ID()));
            }
        }
        this.last_x_diff[this.last_incr] = x_diff;
        this.last_y_diff[this.last_incr] = y_diff;
        ++this.last_incr;
        if (this.last_incr > 2) {
            this.last_incr = 0;
        }
        Cstring.memcpy(item, this.last_item, 20);
    }

    static class LASpoint10 {
        private final ByteBuffer bb;

        private LASpoint10(ByteBuffer bb) {
            this.bb = bb;
        }

        public LASpoint10() {
            this(ByteBuffer.allocate(20));
        }

        static LASpoint10 wrap(byte[] data) {
            return new LASpoint10(ByteBuffer.wrap(data));
        }

        int getX() {
            return this.bb.getInt(0);
        }

        void setX(int x) {
            this.bb.putInt(0, x);
        }

        int getY() {
            return this.bb.getInt(4);
        }

        void setY(int y) {
            this.bb.putInt(4, y);
        }

        int getZ() {
            return this.bb.getInt(8);
        }

        void setZ(int z) {
            this.bb.putInt(8, z);
        }

        char getIntensity() {
            return this.bb.getChar(12);
        }

        void setIntensity(char i) {
            this.bb.putChar(12, i);
        }

        char getPoint_source_ID() {
            return this.bb.getChar(18);
        }

        void setPoint_source_ID(char id) {
            this.bb.putChar(18, id);
        }
    }
}

