/*
 * Decompiled with CFR 0.152.
 */
package com.github.mreutegg.laszip4j.laszip;

import com.github.mreutegg.laszip4j.laszip.ArithmeticDecoder;
import com.github.mreutegg.laszip4j.laszip.ArithmeticModel;
import com.github.mreutegg.laszip4j.laszip.LASreadItemCompressed;
import com.github.mreutegg.laszip4j.laszip.MyDefs;
import java.nio.ByteBuffer;

public class LASreadItemCompressed_RGB12_v2
extends LASreadItemCompressed {
    private ArithmeticDecoder dec;
    private char[] last_item = new char[3];
    private ArithmeticModel m_byte_used;
    private ArithmeticModel m_rgb_diff_0;
    private ArithmeticModel m_rgb_diff_1;
    private ArithmeticModel m_rgb_diff_2;
    private ArithmeticModel m_rgb_diff_3;
    private ArithmeticModel m_rgb_diff_4;
    private ArithmeticModel m_rgb_diff_5;

    public LASreadItemCompressed_RGB12_v2(ArithmeticDecoder dec) {
        assert (dec != null);
        this.dec = dec;
        this.m_byte_used = dec.createSymbolModel(128);
        this.m_rgb_diff_0 = dec.createSymbolModel(256);
        this.m_rgb_diff_1 = dec.createSymbolModel(256);
        this.m_rgb_diff_2 = dec.createSymbolModel(256);
        this.m_rgb_diff_3 = dec.createSymbolModel(256);
        this.m_rgb_diff_4 = dec.createSymbolModel(256);
        this.m_rgb_diff_5 = dec.createSymbolModel(256);
    }

    @Override
    public boolean init(byte[] item) {
        this.dec.initSymbolModel(this.m_byte_used);
        this.dec.initSymbolModel(this.m_rgb_diff_0);
        this.dec.initSymbolModel(this.m_rgb_diff_1);
        this.dec.initSymbolModel(this.m_rgb_diff_2);
        this.dec.initSymbolModel(this.m_rgb_diff_3);
        this.dec.initSymbolModel(this.m_rgb_diff_4);
        this.dec.initSymbolModel(this.m_rgb_diff_5);
        LASreadItemCompressed_RGB12_v2.memcpy(this.last_item, item, 6);
        return Boolean.TRUE;
    }

    @Override
    public void read(byte[] itemBytes) {
        byte corr;
        ByteBuffer item = ByteBuffer.wrap(itemBytes);
        int diff = 0;
        int sym = this.dec.decodeSymbol(this.m_byte_used);
        if ((sym & 1) != 0) {
            corr = (byte)this.dec.decodeSymbol(this.m_rgb_diff_0);
            item.putChar(0, (char)MyDefs.U8_FOLD(corr + (this.last_item[0] & 0xFF)));
        } else {
            item.putChar(0, (char)(this.last_item[0] & 0xFF));
        }
        if ((sym & 2) != 0) {
            corr = (byte)this.dec.decodeSymbol(this.m_rgb_diff_1);
            item.putChar(0, (char)(item.getChar(0) | (char)MyDefs.U8_FOLD(corr + (this.last_item[0] >>> 8)) << 8));
        } else {
            item.putChar(0, (char)(item.getChar(0) | this.last_item[0] & 0xFF00));
        }
        if ((sym & 0x40) != 0) {
            diff = (item.getChar(0) & 0xFF) - (this.last_item[0] & 0xFF);
            if ((sym & 4) != 0) {
                corr = (byte)this.dec.decodeSymbol(this.m_rgb_diff_2);
                item.putChar(2, (char)MyDefs.U8_FOLD(corr + MyDefs.U8_CLAMP(diff + (this.last_item[1] & 0xFF))));
            } else {
                item.putChar(2, (char)(this.last_item[1] & 0xFF));
            }
            if ((sym & 0x10) != 0) {
                corr = (byte)this.dec.decodeSymbol(this.m_rgb_diff_4);
                diff = (diff + ((item.getChar(2) & 0xFF) - (this.last_item[1] & 0xFF))) / 2;
                item.putChar(4, (char)MyDefs.U8_FOLD(corr + MyDefs.U8_CLAMP(diff + (this.last_item[2] & 0xFF))));
            } else {
                item.putChar(4, (char)(this.last_item[2] & 0xFF));
            }
            diff = (item.getChar(0) >>> 8) - (this.last_item[0] >>> 8);
            if ((sym & 8) != 0) {
                corr = (byte)this.dec.decodeSymbol(this.m_rgb_diff_3);
                item.putChar(2, (char)(item.getChar(2) | (char)MyDefs.U8_FOLD(corr + MyDefs.U8_CLAMP(diff + (this.last_item[1] >>> 8))) << 8));
            } else {
                item.putChar(2, (char)(item.getChar(2) | this.last_item[1] & 0xFF00));
            }
            if ((sym & 0x20) != 0) {
                corr = (byte)this.dec.decodeSymbol(this.m_rgb_diff_5);
                diff = (diff + ((item.getChar(2) >>> 8) - (this.last_item[1] >>> 8))) / 2;
                item.putChar(4, (char)(item.getChar(4) | (char)MyDefs.U8_FOLD(corr + MyDefs.U8_CLAMP(diff + (this.last_item[2] >>> 8))) << 8));
            } else {
                item.putChar(4, (char)(item.getChar(4) | this.last_item[2] & 0xFF00));
            }
        } else {
            item.putChar(2, item.getChar(0));
            item.putChar(4, item.getChar(0));
        }
        LASreadItemCompressed_RGB12_v2.memcpy(this.last_item, item.array(), 6);
    }

    private static void memcpy(char[] dest, byte[] src, int num) {
        ByteBuffer srcBuffer = ByteBuffer.wrap(src);
        for (int i = 0; i < num / 2; ++i) {
            dest[i] = srcBuffer.getChar(i * 2);
        }
    }
}

