/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.demo.development.cdt;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Date;
import java.util.Locale;
import java.util.SimpleTimeZone;
import java.util.function.Consumer;
import javax.imageio.ImageIO;
import org.tinfour.common.IConstraint;
import org.tinfour.common.IIncrementalTin;
import org.tinfour.common.IIntegrityCheck;
import org.tinfour.common.IQuadEdge;
import org.tinfour.common.LinearConstraint;
import org.tinfour.common.PolygonConstraint;
import org.tinfour.common.SimpleTriangle;
import org.tinfour.common.Vertex;
import org.tinfour.demo.utils.IDevelopmentTest;
import org.tinfour.demo.utils.TestOptions;
import org.tinfour.utils.TriangleCollector;
import org.tinfour.utils.rendering.RenderingSurfaceAid;

public class MixedModeConstraintTest
implements IDevelopmentTest {
    static int iVertex;
    static final float[] dash;

    public static void main(String[] args) throws IOException {
        MixedModeConstraintTest mmcTest = new MixedModeConstraintTest();
        mmcTest.runTest(System.out, args);
    }

    @Override
    public void runTest(PrintStream ps, String[] args) {
        Object c;
        TestOptions options = new TestOptions();
        boolean[] optionsMatched = options.argumentScan(args);
        options.checkForUnrecognizedArgument(args, optionsMatched);
        Class<?> tinClass = options.getTinClass();
        Locale locale = Locale.getDefault();
        Date date = new Date();
        SimpleDateFormat sdFormat = new SimpleDateFormat("dd MMM yyyy HH:mm", locale);
        sdFormat.setTimeZone(new SimpleTimeZone(0, "UTC"));
        ps.println("Multi-square Constraint Test");
        ps.format("Date of test:       %s UTC%n", sdFormat.format(date));
        ps.format("TIN class:          %s%n", tinClass.getName());
        ArrayList<Vertex> vList = new ArrayList<Vertex>();
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j <= 4; ++j) {
                vList.add(new Vertex(j, i, 0.0, iVertex++));
                if (i >= 4 || j >= 4) continue;
                vList.add(new Vertex((double)j + 0.5, (double)i + 0.5, 0.0, iVertex++));
            }
        }
        ArrayList<IConstraint> conList = new ArrayList<IConstraint>();
        conList.add(this.makePoly("L", 0, 0, 2, 4));
        conList.add(this.makePoly("R", 2, 0, 4, 4));
        conList.add(this.makeHorizontal("H1", -1, 5, 1));
        conList.add(this.makeHorizontal("H3", -1, 5, 3));
        conList.add(this.makeVertical("V1", 1, -1, 5));
        conList.add(this.makeVertical("V4", 3, -1, 5));
        IIncrementalTin tin = options.getNewInstanceOfTestTin();
        tin.add(vList, null);
        tin.addConstraints(conList, false);
        IIntegrityCheck checker = tin.getIntegrityCheck();
        if (!checker.inspect()) {
            ps.println("Integrity check failed " + checker.getMessage());
            return;
        }
        ps.println("Integrity check passed");
        Rectangle2D bounds = tin.getBounds();
        double x0 = bounds.getMinX();
        double y0 = bounds.getMinY();
        double x1 = bounds.getMaxX();
        double y1 = bounds.getMaxY();
        int width = 400;
        int height = 400;
        RenderingSurfaceAid rsa = new RenderingSurfaceAid(width, height, 10, x0, y0, x1, y1);
        rsa.fillBackground(Color.white);
        BufferedImage bImage = rsa.getBufferdImage();
        Graphics2D g2d = rsa.getGraphics2D();
        AffineTransform af = rsa.getCartesianToPixelTransform();
        g2d.setStroke(new BasicStroke(1.0f));
        TriangleRenderer tRend = new TriangleRenderer(g2d, af, tin);
        TriangleCollector.visitSimpleTriangles(tin, tRend);
        g2d.setColor(Color.lightGray);
        for (IQuadEdge edge : tin.edges()) {
            if (edge.isConstrained()) continue;
            c = new double[8];
            c[0] = edge.getA().getX();
            c[1] = edge.getA().getY();
            c[2] = edge.getB().getX();
            c[3] = edge.getB().getY();
            af.transform((double[])c, 0, (double[])c, 4, 2);
            Line2D.Double l2d = new Line2D.Double((double)c[4], (double)c[5], (double)c[6], (double)c[7]);
            g2d.draw(l2d);
        }
        BasicStroke solid = new BasicStroke(3.0f);
        BasicStroke dashx = new BasicStroke(1.0f, 0, 2, 10.0f, dash, 0.0f);
        g2d.setColor(Color.black);
        c = conList.iterator();
        while (c.hasNext()) {
            IConstraint c2 = (IConstraint)c.next();
            if (c2.definesConstrainedRegion()) {
                g2d.setStroke(solid);
            } else {
                g2d.setStroke(dashx);
            }
            Path2D path = c2.getPath2D(af);
            g2d.draw(path);
        }
        try {
            ImageIO.write((RenderedImage)bImage, "PNG", new File("test.png"));
        }
        catch (IOException ioex) {
            ioex.printStackTrace(ps);
        }
        int maxAllocIndex = tin.getMaximumEdgeAllocationIndex();
        BitSet perimeterFlags = new BitSet(maxAllocIndex);
        for (IQuadEdge p : tin.getPerimeter()) {
            perimeterFlags.set(p.getIndex());
        }
        for (IQuadEdge edge : tin.edges()) {
            this.test(edge, tin, perimeterFlags);
            this.test(edge.getDual(), tin, perimeterFlags);
        }
    }

    private void test(IQuadEdge edge, IIncrementalTin tin, BitSet perimeterFlags) {
        IConstraint c;
        String test;
        boolean outside;
        if (perimeterFlags.get(edge.getIndex())) {
            return;
        }
        Vertex A = edge.getA();
        Vertex B = edge.getB();
        double mX = (A.getX() + B.getX()) / 2.0;
        double mY = (A.getY() + B.getY()) / 2.0;
        int iX = (int)(mX + 1.0E-6);
        int iY = (int)(mY + 1.0E-6);
        boolean bl = outside = iX < 0 || iX > 4 || iY < 0 || iY > 4;
        if (this.isHorizontal(edge) && iY == 1 || iY == 3) {
            test = "H" + iY;
            assert (edge.isConstraintLineMember()) : this.fail(edge, "Not a linear constratint where expecting " + test);
            c = tin.getLinearConstraint(edge);
            if (c == null) assert (c != null) : this.fail(edge, "Null linear constraint where expecting " + test);
            assert (test.equals(c.getApplicationData())) : this.fail(edge, "Incorrect constraint association where expecting " + test);
        } else if (this.isVertical(edge) && iX == 1 || iX == 3) {
            test = "V" + iX;
            assert (edge.isConstraintLineMember()) : this.fail(edge, "Not a linear constratint where expecting " + test);
            c = tin.getLinearConstraint(edge);
            if (c == null) assert (c != null) : this.fail(edge, "Null linear constraint where expecting " + test);
            assert (test.equals(c.getApplicationData())) : this.fail(edge, "Incorrect constraint association where expecting " + test);
        }
        if (outside) {
            assert (!edge.isConstrainedRegionMember()) : this.fail(edge, "Outside edge is assigned to region");
            return;
        }
        if (this.isVertical(edge) && (iX == 0 || iX == 2 || iX == 4) || this.isHorizontal(edge) && (iY == 0 || iY == 2 || iY == 4)) {
            assert (edge.isConstrainedRegionBorder()) : this.fail(edge, "Polygon edge not assigned to region");
        } else assert (!edge.isConstrainedRegionBorder()) : this.fail(edge, "Non-polygon edge treated as border");
        IConstraint rCon = tin.getRegionConstraint(edge);
        assert (rCon != null) : this.fail(edge, "Region constraint not set for interior edge");
        if (iX < 2) {
            assert ("L".equals(rCon)) : this.fail(edge, "Invalid application data for left polygon edge");
        } else if (iX > 2) {
            assert ("R".equals(rCon)) : this.fail(edge, "Invalid application data for right polygon edge");
        } else if (iX == 2) {
            double dY = B.getY() - A.getY();
            if (dY > 0.0) {
                assert ("L".equals(rCon)) : this.fail(edge, "Invalid application data for left polygon edge");
            } else if (dY < 0.0) assert ("R".equals(rCon)) : this.fail(edge, "Invalid application data for right polygon edge");
        }
    }

    private String fail(IQuadEdge edge, String message) {
        return "Edge +(" + edge.getIndex() + "): " + message;
    }

    private String eString(IQuadEdge edge) {
        Vertex A = edge.getA();
        Vertex B = edge.getB();
        return edge.getIndex() + ": " + A + ", " + B + ">> " + edge.toString();
    }

    PolygonConstraint makePoly(String label, int xMin, int yMin, int xMax, int yMax) {
        int y;
        Vertex v;
        int x;
        PolygonConstraint p = new PolygonConstraint();
        p.setApplicationData(label);
        for (x = xMin; x <= xMax; ++x) {
            v = new Vertex(x, yMin, 0.0, iVertex++);
            p.add(v);
        }
        for (y = yMin; y <= yMax; ++y) {
            v = new Vertex(xMax, y, 0.0, iVertex++);
            p.add(v);
        }
        for (x = xMax; x >= xMin; --x) {
            v = new Vertex(x, yMax, 0.0, iVertex++);
            p.add(v);
        }
        for (y = yMax; y >= yMin; --y) {
            v = new Vertex(xMin, y, 0.0, iVertex++);
            p.add(v);
        }
        p.complete();
        return p;
    }

    IConstraint makeHorizontal(String label, int xMin, int xMax, int y) {
        LinearConstraint lc = new LinearConstraint();
        lc.setApplicationData(label);
        for (int x = xMin; x <= xMax; ++x) {
            Vertex v = new Vertex(x, y, 0.0, iVertex++);
            lc.add(v);
        }
        lc.complete();
        return lc;
    }

    IConstraint makeVertical(String label, int x, int yMin, int yMax) {
        LinearConstraint lc = new LinearConstraint();
        lc.setApplicationData(label);
        for (int y = yMin; y <= yMax; ++y) {
            Vertex v = new Vertex(x, y, 0.0, iVertex++);
            lc.add(v);
        }
        return lc;
    }

    boolean isVertical(IQuadEdge edge) {
        Vertex A = edge.getA();
        Vertex B = edge.getB();
        return A.getX() == B.getX();
    }

    boolean isHorizontal(IQuadEdge edge) {
        Vertex A = edge.getA();
        Vertex B = edge.getB();
        return A.getY() == B.getY();
    }

    static {
        dash = new float[]{10.0f};
    }

    static class TriangleRenderer
    implements Consumer<SimpleTriangle> {
        private final AffineTransform af;
        Graphics2D g2d;
        IIncrementalTin tin;

        TriangleRenderer(Graphics2D g2d, AffineTransform af, IIncrementalTin tin) {
            this.g2d = g2d;
            this.af = af;
            this.tin = tin;
        }

        @Override
        public void accept(SimpleTriangle t) {
            IQuadEdge a = t.getEdgeA();
            Color color = Color.white;
            IConstraint con = this.tin.getRegionConstraint(a);
            if (con != null) {
                Object obj = con.getApplicationData();
                if ("L".equals(obj)) {
                    color = Color.orange;
                } else if ("R".equals(obj)) {
                    color = Color.yellow;
                }
            }
            Path2D path2d = t.getPath2D(this.af);
            this.g2d.setColor(color);
            this.g2d.fill(path2d);
            this.g2d.draw(path2d);
        }
    }
}

