/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.demo.examples;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.SimpleTimeZone;
import org.tinfour.common.IIncrementalTin;
import org.tinfour.common.Vertex;
import org.tinfour.demo.utils.IDevelopmentTest;
import org.tinfour.demo.utils.TestOptions;
import org.tinfour.demo.utils.VertexLoader;
import org.tinfour.gwr.BandwidthSelectionMethod;
import org.tinfour.gwr.GwrTinInterpolator;
import org.tinfour.gwr.SurfaceModel;
import org.tinfour.utils.TinInstantiationUtility;
import org.tinfour.utils.Tincalc;

public class ExampleGWR
implements IDevelopmentTest {
    static String[] mandatoryOptions = new String[]{"-in"};

    public static void main(String[] args) {
        ExampleGWR example = new ExampleGWR();
        try {
            example.runTest(System.out, args);
        }
        catch (IOException | IllegalArgumentException ex) {
            ex.printStackTrace(System.err);
        }
    }

    @Override
    public void runTest(PrintStream ps, String[] args) throws IOException {
        double sSpace;
        Date date = new Date();
        SimpleDateFormat sdFormat = new SimpleDateFormat("dd MMM yyyy HH:mm", Locale.getDefault());
        sdFormat.setTimeZone(new SimpleTimeZone(0, "UTC"));
        ps.format("Example Use of Geographically Weighted Regression (GWR)%n", new Object[0]);
        ps.format("Date/time of test: %s (UTC)%n", sdFormat.format(date));
        TestOptions options = new TestOptions();
        boolean[] optionsMatched = options.argumentScan(args);
        options.checkForMandatoryOptions(args, mandatoryOptions);
        options.checkForUnrecognizedArgument(args, optionsMatched);
        File inputFile = options.getInputFile();
        ps.format("Input file: %s%n", inputFile.getAbsolutePath());
        VertexLoader loader = new VertexLoader();
        List<Vertex> vertexList = loader.readInputFile(options);
        int nVertices = vertexList.size();
        ps.format("Number of vertices: %8d%n", nVertices);
        double xmin = loader.getXMin();
        double xmax = loader.getXMax();
        double ymin = loader.getYMin();
        double ymax = loader.getYMax();
        double area = (xmax - xmin) * (ymax - ymin);
        double nominalPointSpacing = sSpace = Tincalc.sampleSpacing(area, nVertices);
        ps.println("Building TIN");
        TinInstantiationUtility tiu = new TinInstantiationUtility(0.5, nVertices);
        IIncrementalTin tin = tiu.constructInstance(nominalPointSpacing);
        tin.add(vertexList, null);
        ps.println("Performing Regression");
        double x = (xmin + xmax) / 2.0;
        double y = (ymin + ymax) / 2.0;
        GwrTinInterpolator gwrInt = new GwrTinInterpolator(tin);
        double z = gwrInt.interpolate(SurfaceModel.Cubic, BandwidthSelectionMethod.OptimalAICc, 1.0, x, y, null);
        double[] beta = gwrInt.getCoefficients();
        double[] predictionInterval = gwrInt.getPredictionInterval(0.05);
        double zX = beta[1];
        double zY = beta[2];
        double zXX = 2.0 * beta[3];
        double zYY = 2.0 * beta[4];
        double zXY = beta[4];
        double azimuth = Math.atan2(zY, zX);
        double compass = Math.toDegrees(Math.atan2(zX, zY));
        if (compass < 0.0) {
            compass += 360.0;
        }
        double grade = Math.sqrt(zX * zX + zY * zY);
        double slope = Math.toDegrees(Math.atan(grade));
        double kP = (zXX * zX * zX + 2.0 * zXY * zX * zY + zYY * zY * zY) / ((zX * zX + zY * zY) * Math.pow(zX * zX + zY * zY + 1.0, 1.5));
        ps.format("Interpolation x:                   %10.1f%n", x);
        ps.format("Interpolation y:                   %10.1f%n", y);
        ps.format("Estimated z:                          %12.5f%n", z);
        ps.format("Prediction interval (95%% confidence): %12.5f to %6.5f   (%f)%n", predictionInterval[0], predictionInterval[1], predictionInterval[1] - predictionInterval[0]);
        ps.format("Zx:                                   %12.5f%n", beta[1]);
        ps.format("Zy:                                   %12.5f%n", beta[2]);
        ps.format("Azimuth steepest ascent               %12.5f%n", azimuth);
        ps.format("Compass bearing steepest ascent          %05.1f\u00b0%n", compass);
        ps.format("Grade                                 %8.1f%%%n", grade * 100.0);
        ps.format("Slope:                                %8.1f\u00b0%n", slope);
        ps.format("Profile curvature:                    %12.5f%n", kP);
        ps.format("Eff deg of freedom:                   %12.5f%n", gwrInt.getEffectiveDegreesOfFreedom());
        ps.format("Variance of the Residuals:            %12.5f%n", gwrInt.getVariance());
        ps.format("Standard Deviation of the Residuals   %12.5f%n", gwrInt.getStandardDeviation());
        ps.format("Bandwidth                             %12.5f%n", gwrInt.getBandwidth());
    }
}

