/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.demo.viewer;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.colorchooser.ColorSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ColorButton
extends JButton {
    private static final long serialVersionUID = 1L;
    Color colorChoice = Color.white;
    JColorChooser chooser;
    JDialog dialog;
    private static final String defaultTitle = "Select a color";

    public ColorButton() {
        final ColorButton self = this;
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ColorButton.this.dialog != null) {
                    int baseX = ColorButton.this.getX();
                    int baseY = ColorButton.this.getY();
                    ColorButton.this.dialog.setLocation(baseX, baseY);
                    ColorButton.this.dialog.setVisible(true);
                    ColorButton.this.dialog.toFront();
                    return;
                }
                if (ColorButton.this.chooser == null) {
                    ColorButton.this.chooser = new JColorChooser(ColorButton.this.colorChoice);
                    final ColorSelectionModel model = ColorButton.this.chooser.getSelectionModel();
                    model.addChangeListener(new ChangeListener(){

                        @Override
                        public void stateChanged(ChangeEvent e) {
                            ColorButton.this.colorChoice = model.getSelectedColor();
                        }
                    });
                }
                ActionListener okListener = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ColorButton.this.colorChoice = ColorButton.this.chooser.getColor();
                    }
                };
                String title = ColorButton.defaultTitle;
                String n = ColorButton.this.getToolTipText();
                if (n != null && !n.isEmpty()) {
                    title = n;
                }
                ColorButton.this.dialog = JColorChooser.createDialog(self, title, false, ColorButton.this.chooser, okListener, null);
                ColorButton.this.dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosed(WindowEvent e) {
                        ColorButton.this.dialog = null;
                    }
                });
                ColorButton.this.dialog.setVisible(true);
                int baseX = ColorButton.this.getX();
                int baseY = ColorButton.this.getY();
                ColorButton.this.dialog.setLocation(baseX, baseY);
            }
        });
    }

    public void setColor(Color color) {
        this.colorChoice = color;
        if (this.chooser != null) {
            this.chooser.setColor(color);
        }
        this.repaint();
    }

    public Color getColor() {
        return this.colorChoice;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        int w = this.getWidth();
        int h = this.getHeight();
        Insets i = this.getInsets();
        int fx = i.left;
        int fy = i.top;
        int fw = w - fx - i.right;
        int fh = h - fy - i.bottom;
        g.setColor(this.colorChoice);
        g.fillRect(fx, fy, fw, fh);
        super.paintBorder(g);
    }
}

