/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.demo.viewer;

import java.awt.Color;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.text.ParseException;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.tinfour.common.Vertex;
import org.tinfour.demo.utils.TextCoordCartesian;
import org.tinfour.demo.utils.TextCoordGeo;
import org.tinfour.demo.viewer.DataViewingPanel;
import org.tinfour.demo.viewer.backplane.IModel;
import org.tinfour.demo.viewer.backplane.IModelChangeListener;
import org.tinfour.demo.viewer.backplane.MvComposite;
import org.tinfour.utils.LinearUnits;

class ZoomToFeaturePanel
extends JPanel
implements IModelChangeListener {
    private static final long serialVersionUID = 1L;
    private DataViewingPanel dvPanel;
    private Vertex currentFeature;
    private double currentWidth;
    private Point2D currentCoordinates;
    private final TextCoordGeo latLonParser = new TextCoordGeo();
    private final TextCoordCartesian cartParser = new TextCoordCartesian();
    private JPanel actionsPanel;
    private JButton applyButton;
    private JButton cancelButton;
    private JLabel coordinatesLabel;
    private JTextField coordinatesTextField;
    private JLabel featureLabel;
    private JTextField featureTextField;
    private JButton okayButton;
    private JPanel optionsPanel;
    private JButton resetButton;
    private JLabel unitsLabel;
    private JLabel widthLabel;
    private JTextField widthTextField;

    ZoomToFeaturePanel() {
        this.initComponents();
    }

    void setDataViewingPanel(DataViewingPanel dvPanel) {
        this.dvPanel = dvPanel;
        MvComposite mvComposite = dvPanel.getMvComposite();
        IModel model = mvComposite.getModel();
        AffineTransform p2m = dvPanel.getPanelToModelTransform();
        if (p2m == null) {
            return;
        }
        int xP = dvPanel.getWidth() / 2;
        int yP = dvPanel.getHeight() / 2;
        Point2D.Double pPoint = new Point2D.Double(xP, yP);
        Point2D.Double mPoint = new Point2D.Double();
        p2m.transform(pPoint, mPoint);
    }

    void registerDataViewingPanel(DataViewingPanel dvPanel) {
        this.dvPanel = dvPanel;
        dvPanel.addModelChangeListener(this);
        IModel model = dvPanel.getModel();
        if (model != null && model.isLoaded()) {
            this.transferValuesFromModel(model);
        }
        this.setControlsForInputState();
    }

    private IModel getModel() {
        MvComposite c = this.dvPanel.getMvComposite();
        if (c != null) {
            return c.getModel();
        }
        return null;
    }

    private void setDouble(JTextField field, String fmt, double v) {
        if (!Double.isNaN(v)) {
            if (Math.floor(v + 1.0E-6) == (double)((int)v)) {
                field.setText(Integer.toString((int)v));
            } else {
                field.setText(String.format(fmt, v));
            }
        }
    }

    private double extractField(JTextField field, double value) {
        double d = this.extractDouble(field);
        if (Double.isNaN(d)) {
            return value;
        }
        return d;
    }

    private double extractDouble(JTextField field) {
        try {
            String s = field.getText();
            if (s != null && !(s = s.trim()).isEmpty()) {
                return Double.parseDouble(s.trim());
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return Double.NaN;
    }

    private void hideDialog() {
        Container c = this;
        while (!((c = c.getParent()) instanceof JDialog)) {
        }
        JDialog jd = (JDialog)c;
        jd.setVisible(false);
    }

    private void initComponents() {
        this.optionsPanel = new JPanel();
        this.coordinatesLabel = new JLabel();
        this.featureLabel = new JLabel();
        this.widthLabel = new JLabel();
        this.coordinatesTextField = new JTextField();
        this.featureTextField = new JTextField();
        this.widthTextField = new JTextField();
        this.unitsLabel = new JLabel();
        this.actionsPanel = new JPanel();
        this.applyButton = new JButton();
        this.cancelButton = new JButton();
        this.okayButton = new JButton();
        this.resetButton = new JButton();
        this.optionsPanel.setBorder(BorderFactory.createEtchedBorder());
        this.coordinatesLabel.setText("Coordinates:");
        this.featureLabel.setText("Feature:");
        this.widthLabel.setText("Width:");
        this.coordinatesTextField.setColumns(24);
        this.coordinatesTextField.setToolTipText("Enter a pair of coordinates separated by a space");
        this.coordinatesTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                ZoomToFeaturePanel.this.coordinatesTextFieldKeyReleased(evt);
            }
        });
        this.featureTextField.setColumns(24);
        this.featureTextField.setText(" ");
        this.featureTextField.setToolTipText("Enter a feature ID to center display");
        this.featureTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                ZoomToFeaturePanel.this.featureTextFieldFocusLost(evt);
            }
        });
        this.featureTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                ZoomToFeaturePanel.this.featureTextFieldKeyReleased(evt);
            }
        });
        this.widthTextField.setColumns(24);
        this.widthTextField.setText(" ");
        this.widthTextField.setToolTipText("Enter width of display area");
        this.widthTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                ZoomToFeaturePanel.this.widthTextFieldKeyReleased(evt);
            }
        });
        this.unitsLabel.setText("Unspecified Units");
        GroupLayout optionsPanelLayout = new GroupLayout(this.optionsPanel);
        this.optionsPanel.setLayout(optionsPanelLayout);
        optionsPanelLayout.setHorizontalGroup(optionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(optionsPanelLayout.createSequentialGroup().addContainerGap().addGroup(optionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.coordinatesLabel).addComponent(this.featureLabel).addComponent(this.widthLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(optionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.coordinatesTextField).addComponent(this.featureTextField).addGroup(optionsPanelLayout.createSequentialGroup().addComponent(this.widthTextField, -2, 97, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.unitsLabel))).addContainerGap(84, Short.MAX_VALUE)));
        optionsPanelLayout.setVerticalGroup(optionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(optionsPanelLayout.createSequentialGroup().addContainerGap().addGroup(optionsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.featureLabel).addComponent(this.featureTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(optionsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.coordinatesLabel).addComponent(this.coordinatesTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(optionsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.widthLabel).addComponent(this.widthTextField, -2, -1, -2).addComponent(this.unitsLabel)).addContainerGap(26, Short.MAX_VALUE)));
        this.applyButton.setText("Apply");
        this.applyButton.setToolTipText("Apply settings");
        this.applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ZoomToFeaturePanel.this.applyButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.setToolTipText("Close dialog without applying settings");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ZoomToFeaturePanel.this.cancelButtonActionPerformed(evt);
            }
        });
        this.okayButton.setText("OK");
        this.okayButton.setToolTipText("Apply settings and close dialog");
        this.okayButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ZoomToFeaturePanel.this.okButtonActionPerformed(evt);
            }
        });
        this.resetButton.setText("Reset");
        this.resetButton.setToolTipText("Reset coordinates using current model and view");
        this.resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ZoomToFeaturePanel.this.resetButtonActionPerformed(evt);
            }
        });
        GroupLayout actionsPanelLayout = new GroupLayout(this.actionsPanel);
        this.actionsPanel.setLayout(actionsPanelLayout);
        actionsPanelLayout.setHorizontalGroup(actionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(actionsPanelLayout.createSequentialGroup().addComponent(this.resetButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.okayButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.applyButton).addContainerGap()));
        actionsPanelLayout.linkSize(0, this.applyButton, this.cancelButton, this.okayButton, this.resetButton);
        actionsPanelLayout.setVerticalGroup(actionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, actionsPanelLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addGroup(actionsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.okayButton).addComponent(this.cancelButton).addComponent(this.applyButton).addComponent(this.resetButton))));
        actionsPanelLayout.linkSize(1, this.applyButton, this.cancelButton, this.okayButton, this.resetButton);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.actionsPanel, -1, -1, Short.MAX_VALUE).addComponent(this.optionsPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.optionsPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 23, Short.MAX_VALUE).addComponent(this.actionsPanel, -2, -1, -2).addContainerGap()));
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.transferValuesToDataViewPanel();
        this.hideDialog();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.hideDialog();
    }

    private void applyButtonActionPerformed(ActionEvent evt) {
        this.transferValuesToDataViewPanel();
    }

    private void transferValuesToDataViewPanel() {
        IModel model = this.getModel();
        if (model != null && this.currentCoordinates != null && this.currentWidth > 0.0) {
            double x = this.currentCoordinates.getX();
            double y = this.currentCoordinates.getY();
            this.dvPanel.zoomToModelPosition(x, y, this.currentWidth);
        }
    }

    private void coordinatesTextFieldKeyReleased(KeyEvent evt) {
        IModel model = this.getModel();
        if (model == null) {
            return;
        }
        this.currentFeature = null;
        this.featureTextField.setText("");
        this.featureTextField.setForeground(Color.black);
        String s = this.coordinatesTextField.getText();
        if (s == null || s.isEmpty()) {
            this.coordinatesTextField.setForeground(Color.black);
        } else {
            try {
                double[] c = new double[2];
                if (model.isCoordinateSystemGeographic()) {
                    double[] geo = this.latLonParser.parse(s);
                    model.geo2xy(geo[0], geo[1], c);
                } else {
                    c = this.cartParser.parse(s);
                }
                this.currentCoordinates = new Point2D.Double(c[0], c[1]);
                this.coordinatesTextField.setForeground(Color.black);
            }
            catch (IllegalArgumentException | ParseException ex) {
                this.currentCoordinates = null;
                this.coordinatesTextField.setForeground(Color.red);
            }
        }
        this.setControlsForInputState();
    }

    private void featureTextFieldKeyReleased(KeyEvent evt) {
        IModel model = this.getModel();
        if (model == null) {
            return;
        }
        this.currentFeature = null;
        String s = this.featureTextField.getText();
        if (s == null || s.isEmpty()) {
            this.featureTextField.setForeground(Color.black);
        } else {
            Integer index = -1;
            try {
                index = Integer.parseInt(s.trim());
                this.currentFeature = model.getVertexForIndex(index);
                if (this.currentFeature == null) {
                    this.featureTextField.setForeground(Color.red);
                } else {
                    this.featureTextField.setForeground(Color.black);
                    this.transferCurrentFeatureToPositionField(model);
                }
            }
            catch (NumberFormatException nex) {
                this.featureTextField.setForeground(Color.red);
            }
        }
        this.setControlsForInputState();
    }

    private void featureTextFieldFocusLost(FocusEvent evt) {
        IModel model = this.getModel();
        if (model == null) {
            return;
        }
    }

    private void widthTextFieldKeyReleased(KeyEvent evt) {
        IModel model = this.getModel();
        String s = this.widthTextField.getText();
        this.currentWidth = 0.0;
        if (model != null && s != null && !s.isEmpty()) {
            try {
                double d = Double.parseDouble(s);
                if (d > 0.0) {
                    this.currentWidth = d;
                    this.widthTextField.setForeground(Color.black);
                }
            }
            catch (NumberFormatException nex) {
                this.widthTextField.setForeground(Color.red);
            }
            this.setControlsForInputState();
        }
    }

    private void resetButtonActionPerformed(ActionEvent evt) {
        IModel model = this.getModel();
        if (model != null) {
            this.transferValuesFromModel(model);
        }
    }

    private void transferCurrentFeatureToPositionField(IModel model) {
        String s;
        double vx = this.currentFeature.getX();
        double vy = this.currentFeature.getY();
        if (model.isCoordinateSystemGeographic()) {
            double[] geo = new double[2];
            model.xy2geo(vx, vy, geo);
            s = this.latLonParser.format(geo[0], geo[1]);
        } else {
            s = this.cartParser.format(vx, vy);
        }
        this.coordinatesTextField.setText(s);
        this.coordinatesTextField.setForeground(Color.black);
        this.currentCoordinates = new Point2D.Double(vx, vy);
        double modelWidth = model.getMaxX() - model.getMinX();
        double nps = model.getNominalPointSpacing();
        this.currentWidth = nps * 6.0;
        if (this.currentWidth > modelWidth) {
            this.currentWidth = modelWidth;
        }
        s = String.format("%f", this.currentWidth);
        this.widthTextField.setText(s);
    }

    @Override
    public void modelRemoved() {
        this.clearInputDataElements();
        this.featureTextField.setEnabled(false);
        this.coordinatesTextField.setEnabled(false);
        this.widthTextField.setEnabled(false);
        this.okayButton.setEnabled(false);
        this.applyButton.setEnabled(false);
        this.resetButton.setEnabled(false);
        this.repaint();
    }

    @Override
    public void modelAdded(IModel model) {
        this.transferValuesFromModel(model);
        this.setControlsForInputState();
        this.resetButton.setEnabled(true);
    }

    private void clearInputDataElements() {
        this.currentFeature = null;
        this.currentWidth = 0.0;
        this.currentCoordinates = null;
        this.featureTextField.setText("");
        this.featureTextField.setForeground(Color.black);
        this.coordinatesTextField.setText("");
        this.coordinatesTextField.setForeground(Color.black);
        this.widthTextField.setText("");
        this.widthTextField.setForeground(Color.black);
    }

    void transferValuesFromPanel() {
        IModel model = this.dvPanel.getModel();
        this.transferValuesFromModel(model);
    }

    void transferValuesFromModel(IModel model) {
        String s;
        if (model == null || !model.isLoaded()) {
            this.clearInputDataElements();
            return;
        }
        AffineTransform p2m = this.dvPanel.getPanelToModelTransform();
        if (p2m == null) {
            return;
        }
        this.currentFeature = null;
        this.featureTextField.setForeground(Color.black);
        this.featureTextField.setText("");
        this.featureTextField.setEnabled(true);
        int xP = this.dvPanel.getWidth() / 2;
        int yP = this.dvPanel.getHeight() / 2;
        Point2D.Double pPoint = new Point2D.Double(xP, yP);
        Point2D.Double mPoint = new Point2D.Double();
        p2m.transform(pPoint, mPoint);
        this.currentCoordinates = mPoint;
        if (model.isCoordinateSystemGeographic()) {
            double[] g = new double[2];
            model.xy2geo(((Point2D)mPoint).getX(), ((Point2D)mPoint).getY(), g);
            s = this.latLonParser.format(g[0], g[1]);
            this.coordinatesTextField.setToolTipText("Enter geographic coordinate pair separated by slash or space");
        } else {
            s = this.cartParser.format(((Point2D)mPoint).getX(), ((Point2D)mPoint).getY());
            this.coordinatesTextField.setToolTipText("Enter Cartesian coordinate pair separated by space");
        }
        this.coordinatesTextField.setText(s);
        this.coordinatesTextField.setEnabled(true);
        double scale = Math.sqrt(Math.abs(p2m.getDeterminant()));
        double pWidth = this.dvPanel.getWidth();
        this.currentWidth = pWidth * scale;
        s = String.format("%f", this.currentWidth);
        this.widthTextField.setText(s);
        this.widthTextField.setEnabled(true);
        LinearUnits linearUnits = model.getLinearUnits();
        if (linearUnits == LinearUnits.UNKNOWN) {
            this.unitsLabel.setText("Unspecified units");
        } else {
            this.unitsLabel.setText(linearUnits.getName());
        }
        this.setControlsForInputState();
    }

    private void setControlsForInputState() {
        if (this.currentCoordinates != null && this.currentWidth > 0.0) {
            this.okayButton.setEnabled(true);
            this.applyButton.setEnabled(true);
        } else {
            this.okayButton.setEnabled(false);
            this.applyButton.setEnabled(false);
        }
    }
}

