/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.demo.viewer.backplane;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.tinfour.demo.viewer.backplane.IModelViewTask;

final class BackplaneExecutor {
    private final int nThreadsInPool;
    private final ThreadPoolExecutor executor;
    private final List<IModelViewTask> taskList;

    BackplaneExecutor(int coreSize) {
        int nAvailableProcessors;
        this.nThreadsInPool = coreSize == 0 ? ((nAvailableProcessors = Runtime.getRuntime().availableProcessors()) > 6 ? 4 : (nAvailableProcessors > 2 ? nAvailableProcessors - 2 : 1)) : coreSize;
        BackplaneThreadFactory factory = new BackplaneThreadFactory("Backplane");
        this.executor = new MvThreadPoolExecutor(this.nThreadsInPool, this.nThreadsInPool, 1000L, TimeUnit.SECONDS, (BlockingQueue<Runnable>)new LinkedBlockingQueue<Runnable>(){
            private static final long serialVersionUID = 1L;
        }, factory);
        this.taskList = new ArrayList<IModelViewTask>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void queueTask(Runnable r) {
        if (r instanceof IModelViewTask) {
            List<IModelViewTask> list = this.taskList;
            synchronized (list) {
                this.taskList.add((IModelViewTask)r);
            }
        }
        this.executor.execute(r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancelAllTasks() {
        ArrayList<IModelViewTask> cancelledList = new ArrayList<IModelViewTask>();
        List<IModelViewTask> list = this.taskList;
        synchronized (list) {
            for (IModelViewTask t : this.taskList) {
                t.cancel();
                cancelledList.add(t);
            }
            this.taskList.clear();
        }
        for (IModelViewTask t : cancelledList) {
            this.executor.remove(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancelRenderingTasks() {
        ArrayList<IModelViewTask> cancelledList = new ArrayList<IModelViewTask>();
        List<IModelViewTask> list = this.taskList;
        synchronized (list) {
            for (IModelViewTask t : this.taskList) {
                if (!t.isRenderingTask()) continue;
                t.cancel();
                cancelledList.add(t);
            }
            this.taskList.clear();
        }
        for (IModelViewTask t : cancelledList) {
            this.executor.remove(t);
        }
    }

    int getCorePoolSize() {
        return this.executor.getCorePoolSize();
    }

    private class BackplaneThreadFactory
    implements ThreadFactory {
        final String name;
        final AtomicInteger serialID;

        public BackplaneThreadFactory(String name) {
            this.name = name;
            this.serialID = new AtomicInteger();
        }

        @Override
        public Thread newThread(Runnable r) {
            ThreadFactory tf = Executors.defaultThreadFactory();
            Thread t = tf.newThread(r);
            int index = this.serialID.getAndAdd(1);
            t.setName(this.name + "_" + index);
            return t;
        }
    }

    private class MvThreadPoolExecutor
    extends ThreadPoolExecutor {
        public MvThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory) {
            super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void afterExecute(Runnable r, Throwable t) {
            super.afterExecute(r, t);
            if (r instanceof IModelViewTask) {
                List list = BackplaneExecutor.this.taskList;
                synchronized (list) {
                    BackplaneExecutor.this.taskList.remove((IModelViewTask)r);
                }
            }
        }
    }
}

