/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.demo.viewer.backplane;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.tinfour.common.IMonitorWithCancellation;
import org.tinfour.common.Vertex;
import org.tinfour.demo.viewer.backplane.IModel;
import org.tinfour.demo.viewer.backplane.ModelAdapter;
import org.tinfour.utils.LinearUnits;
import org.tinfour.utils.loaders.VertexReaderText;

public class ModelFromText
extends ModelAdapter
implements IModel {
    final char delimiter;

    public ModelFromText(File file) {
        super(file);
        char test = '\u0000';
        try (VertexReaderText reader = new VertexReaderText(file);){
            test = reader.getDelimiter();
            this.geographicCoordinates = reader.isSourceInGeographicCoordinates();
            this.coordinateTransform = reader.getCoordinateTransform();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.delimiter = test;
    }

    @Override
    public void load(IMonitorWithCancellation monitor) throws IOException {
        if (this.areVerticesLoaded) {
            System.out.println("Internal error, multiple calls to load model");
            return;
        }
        VertexReaderText reader = new VertexReaderText(this.file);
        long time0 = System.currentTimeMillis();
        List<Vertex> list = reader.read(monitor);
        if (list.isEmpty()) {
            monitor.reportDone();
            throw new IOException("Unable to read points from file");
        }
        this.xMin = reader.getXMin();
        this.yMin = reader.getYMin();
        this.xMax = reader.getXMax();
        this.yMax = reader.getYMax();
        this.zMin = reader.getZMin();
        this.zMax = reader.getZMax();
        this.geographicCoordinates = reader.isSourceInGeographicCoordinates();
        if (this.geographicCoordinates) {
            // empty if block
        }
        long time1 = System.currentTimeMillis();
        this.timeToLoad = time1 - time0;
        System.out.println("Loaded " + list.size() + " vertices in " + this.timeToLoad + " ms");
        this.prepareModelForRendering(list, monitor);
    }

    @Override
    public String getDescription() {
        if (Character.isWhitespace(this.delimiter)) {
            return "Space delimented text file";
        }
        if (this.delimiter == ',') {
            return "Comma-separated values";
        }
        return "Text delimited by '" + this.delimiter + "'";
    }

    @Override
    public LinearUnits getLinearUnits() {
        return LinearUnits.UNKNOWN;
    }

    public String toString() {
        String conType = this.hasConstraints() ? " CDT" : "";
        String loaded = this.isLoaded() ? "Loaded" : "Unloaded";
        return String.format("Model From TXT %d %s%s", this.serialIndex, loaded, conType);
    }
}

