/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.gis.las;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.tinfour.gis.las.GeoTiffKey;

public class GeoTiffData {
    public static final int GeoDoubleParamsTag = 34736;
    private static final int GeoAsciiParamsTag = 34737;
    public static final int GtModelTypeGeoKey = 1024;
    public static final int GeoCitationGeoKey = 2049;
    public static final int PCSCitationGeoKey = 3073;
    public static final int ProjLinearUnitsGeoKey = 3076;
    public static final int VerticalUnitsGeoKey = 4099;
    public static final int LinearUnitCodeMeter = 9001;
    public static final int LinearUnitCodeFeet = 9002;
    public static final int LinearUnitCodeFeetUS = 9003;
    private final List<GeoTiffKey> keyList;
    private final HashMap<Integer, GeoTiffKey> keyMap;
    private final double[] doubleData;
    private final char[] asciiData;

    public GeoTiffData(List<GeoTiffKey> keyList, double[] fpData, char[] asciiData) {
        this.keyList = keyList;
        this.doubleData = fpData;
        this.asciiData = asciiData;
        this.keyMap = new HashMap();
        for (GeoTiffKey key : keyList) {
            this.keyMap.put(key.getKeyCode(), key);
        }
    }

    public boolean containsKey(int keyCode) {
        return this.keyMap.containsKey(keyCode);
    }

    public int getInteger(int keyCode) throws IOException {
        GeoTiffKey key = this.keyMap.get(keyCode);
        if (key == null || key.location != 0) {
            throw new IOException("Invalid TIFF key for integer: " + keyCode);
        }
        return key.valueOrOffset;
    }

    public double[] getDouble(int keyCode) throws IOException {
        GeoTiffKey key = this.keyMap.get(keyCode);
        if (key == null || key.location != 34736) {
            throw new IOException("Invalid TIFF key for double: " + keyCode);
        }
        if (this.doubleData == null || key.count + key.valueOrOffset > this.doubleData.length) {
            throw new IOException("Format violation: count exceeds available data for " + keyCode);
        }
        double[] d = new double[key.count];
        System.arraycopy(this.doubleData, key.valueOrOffset, d, 0, key.count);
        return d;
    }

    public String getString(int keyCode) throws IOException {
        char c;
        GeoTiffKey key = this.keyMap.get(keyCode);
        if (key == null || key.location != 34737) {
            throw new IOException("Invalid TIFF key for ASCII string: " + keyCode);
        }
        if (this.asciiData == null || key.count + key.valueOrOffset > this.asciiData.length) {
            throw new IOException("Format violation: count exceeds available data for " + keyCode);
        }
        StringBuilder sb = new StringBuilder(key.count);
        for (int i = 0; i < key.count && (c = this.asciiData[i]) != '\u0000'; ++i) {
            sb.append(c);
        }
        return sb.toString();
    }

    public List<GeoTiffKey> getKeyList() {
        ArrayList<GeoTiffKey> list = new ArrayList<GeoTiffKey>(this.keyList.size());
        list.addAll(this.keyList);
        return list;
    }
}

