/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.demo.development.cdt;

import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.SimpleTimeZone;
import org.tinfour.common.IConstraint;
import org.tinfour.common.IIncrementalTin;
import org.tinfour.common.IIntegrityCheck;
import org.tinfour.common.Thresholds;
import org.tinfour.common.Vertex;
import org.tinfour.demo.development.cdt.RandomConstraintTestOptions;

public class RandomConstraintTestSeries {
    private static final String[] usage = new String[]{"RandomConstraintTestSeries", "  Tests the constraint addition by inserting random constraints", "  into sets of randomly generated vertices.  Constraint types", "  include:", "     SingleSegment      one randomly generated segment", "     ColinearSegments   a chain of two randomly generated colinear segments", "     RandomSegmentPair  a chain of two randomly generated segments (default)", "     RandomCross        a pair of two perpendicular chains intersecting at a vertex", "", "Options: ", "  -constraintType [SingleSegment, ColinearSegments, RandomSegmentPair]", "  -nTests <int>       number of vertex sets to generate for testing", "  -restoreConformity  restore conformity when adding constraints", "                          (by default, conformity is not restored)", "  -tinClass <class path>  selects the IIncrementalTin instance for testing", "                          supply full class path, such as ", "                          tinfour.standard.IncrementalTin", "  -vertexSeed <long>      initial random seed for vertex generation", "  -constraintSeed <long>  inital random seed for constraint generation", "", "      nTests*10 constraints will be tested for each vertex set", "      in the test series.  Random seeds will be incremented with each test,", "  "};

    public static void main(String[] args) {
        if (args.length == 0) {
            for (String a : usage) {
                System.out.println(a);
            }
        }
        RandomConstraintTestSeries test = new RandomConstraintTestSeries();
        test.process(System.out, args);
    }

    private void process(PrintStream ps, String[] args) {
        RandomConstraintTestOptions options = new RandomConstraintTestOptions(args, null);
        SimpleDateFormat sdFormat = new SimpleDateFormat("dd MMM yyyy HH:mm", Locale.getDefault());
        sdFormat.setTimeZone(new SimpleTimeZone(0, "UTC"));
        Date date = new Date();
        ps.println("");
        ps.println("Random Constraint Test Series");
        ps.println("Date of Test:                " + sdFormat.format(date) + " UTC");
        options.printSummary(ps);
        int nTestsPerformed = 0;
        int nSyntheticPoints = 0;
        int testCount = options.getTestCount();
        boolean restoreConformity = options.isConformityRestoreSet();
        RandomConstraintTestOptions.ConstraintType constraintType = options.getConstraintType();
        IIncrementalTin tin = options.makeNewInstanceOfTestTin();
        Thresholds thresholds = tin.getThresholds();
        for (int i = 0; i < testCount; ++i) {
            if (i % 100 == 0) {
                ps.println("Testing vertex set " + i);
            }
            int vertexSeed = options.getVertexSeed(i);
            List<Vertex> vertexList = options.makeRandomVertices(i);
            for (int j = 0; j < testCount * 10; ++j) {
                tin.clear();
                tin.add(vertexList, null);
                int constraintSeed = options.getConstraintSeed(j);
                List<IConstraint> constraintList = options.makeConstraints(j);
                try {
                    tin.addConstraints(constraintList, restoreConformity);
                    ++nTestsPerformed;
                    nSyntheticPoints += tin.getSyntheticVertexCount();
                }
                catch (Exception ex) {
                    System.err.println("Unexpected exception in trial " + vertexSeed + ", " + constraintSeed);
                    ex.printStackTrace(System.err);
                    System.exit(-1);
                }
                IIntegrityCheck iCheck = tin.getIntegrityCheck();
                if (iCheck.inspect()) {
                    double hLimit;
                    if (!restoreConformity || iCheck.getConstrainedViolationCount() <= 0) continue;
                    int n = iCheck.getConstrainedViolationCount();
                    double hMax = iCheck.getConstrainedViolationMaximum();
                    if (!(hMax > (hLimit = thresholds.getDelaunayThreshold()))) continue;
                    System.out.println("TIN failed to restore conformity for vertex seed " + vertexSeed + ", constraint seed" + constraintSeed + " constrained violation count " + n);
                    System.exit(-1);
                    continue;
                }
                System.out.println("TIN failed inspection for vertex seed " + vertexSeed + ", constraint seed" + constraintSeed + " failed");
                iCheck.printSummary(System.out);
                System.exit(-1);
            }
        }
        if (restoreConformity) {
            int edgesPerConstraint = constraintType == RandomConstraintTestOptions.ConstraintType.SingleSegment ? 1 : 2;
            ps.println("Average number of synthetic vertices added per constraint edge " + (double)nSyntheticPoints / (double)(nTestsPerformed * edgesPerConstraint));
        }
    }
}

