/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.demo.examples;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.tinfour.common.IConstraint;
import org.tinfour.common.IIncrementalTin;
import org.tinfour.common.IQuadEdge;
import org.tinfour.common.PolygonConstraint;
import org.tinfour.common.Vertex;
import org.tinfour.utils.TriangleCollector;

class LogoPanel
extends JPanel {
    static final long serialVersionUID = 1L;
    private static final double oversize = 1.5;
    IIncrementalTin tin;

    public LogoPanel(IIncrementalTin tin) {
        super(new BorderLayout());
        this.tin = tin;
    }

    private void mapEdge(IQuadEdge e, AffineTransform af, Point2D p0, Point2D p1, Line2D l2d) {
        p0.setLocation(e.getA().x, e.getA().y);
        p1.setLocation(e.getB().x, e.getB().y);
        af.transform(p0, p0);
        af.transform(p1, p1);
        l2d.setLine(p0, p1);
    }

    private Path2D mapPolygon(IConstraint constraint, AffineTransform af) {
        Path2D.Double path = new Path2D.Double();
        Point2D.Double p = new Point2D.Double();
        List vList = constraint.getVertices();
        boolean moveFlag = true;
        for (Vertex v : vList) {
            ((Point2D)p).setLocation(v.getX(), v.getY());
            af.transform(p, p);
            if (moveFlag) {
                moveFlag = false;
                ((Path2D)path).moveTo(((Point2D)p).getX(), ((Point2D)p).getY());
                continue;
            }
            ((Path2D)path).lineTo(((Point2D)p).getX(), ((Point2D)p).getY());
        }
        path.closePath();
        return path;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        final Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        int w = this.getWidth();
        int h = this.getHeight();
        g.setColor(Color.white);
        g.fillRect(0, 0, w, h);
        Rectangle2D bounds = this.tin.getBounds();
        double aB = bounds.getWidth() / bounds.getHeight();
        double aP = (double)w / (double)(h /= 2);
        double scale = aP / aB > 1.0 ? (double)h / (bounds.getHeight() * 1.5) : (double)w / (bounds.getWidth() * 1.5);
        int xOffset = (int)((double)w / 2.0 - scale * bounds.getCenterX());
        int yOffset = (int)((double)h / 2.0 + scale * bounds.getCenterY());
        AffineTransform af = new AffineTransform(scale, 0.0, 0.0, -scale, (double)xOffset, (double)yOffset);
        final Point2D.Double p0 = new Point2D.Double();
        final Point2D.Double p1 = new Point2D.Double();
        final Point2D.Double p2 = new Point2D.Double();
        Line2D.Double l2d = new Line2D.Double();
        g2d.setStroke(new BasicStroke(1.0f, 0, 2));
        List edges = this.tin.getEdges();
        List constraints = this.tin.getConstraints();
        g2d.setColor(Color.lightGray);
        for (IQuadEdge e : edges) {
            if (e.getB() == null) continue;
            this.mapEdge(e, af, p0, p1, l2d);
            g2d.draw(l2d);
        }
        yOffset = (int)((double)yOffset + 1.15 * scale * bounds.getHeight());
        af = new AffineTransform(scale, 0.0, 0.0, -scale, (double)xOffset, (double)yOffset);
        g2d.setColor(Color.lightGray);
        for (IQuadEdge e : edges) {
            if (!e.isConstrainedRegionInterior()) continue;
            this.mapEdge(e, af, p0, p1, l2d);
            g2d.draw(l2d);
        }
        g2d.setColor(Color.black);
        for (IQuadEdge e : edges) {
            if (!e.isConstrainedRegionBorder()) continue;
            this.mapEdge(e, af, p0, p1, l2d);
            g2d.draw(l2d);
        }
        yOffset = (int)((double)yOffset + 1.15 * scale * bounds.getHeight());
        final AffineTransform at = af = new AffineTransform(scale, 0.0, 0.0, -scale, (double)xOffset, (double)yOffset);
        final Path2D.Double path = new Path2D.Double();
        for (IConstraint constraint : constraints) {
            PolygonConstraint poly = (PolygonConstraint)constraint;
            double area = poly.getArea();
            if (area <= 0.0) continue;
            Object obj = constraint.getApplicationData();
            g2d.setColor((Color)obj);
            TriangleCollector.visitTrianglesForConstrainedRegion((IConstraint)constraint, (Consumer)new Consumer<Vertex[]>(){

                @Override
                public void accept(Vertex[] triangle) {
                    p0.setLocation(triangle[0].x, triangle[0].y);
                    p1.setLocation(triangle[1].x, triangle[1].y);
                    p2.setLocation(triangle[2].x, triangle[2].y);
                    at.transform(p0, p0);
                    at.transform(p1, p1);
                    at.transform(p2, p2);
                    path.reset();
                    path.moveTo(p0.getX(), p0.getY());
                    path.lineTo(p1.getX(), p1.getY());
                    path.lineTo(p2.getX(), p2.getY());
                    path.closePath();
                    g2d.fill(path);
                    g2d.draw(path);
                }
            });
        }
        g2d.setColor(new Color(128, 128, 128, 128));
        for (IQuadEdge e : edges) {
            if (!e.isConstrainedRegionInterior()) continue;
            this.mapEdge(e, af, p0, p1, l2d);
            g2d.draw(l2d);
        }
        g2d.setColor(Color.black);
        g2d.setStroke(new BasicStroke(2.0f, 0, 2));
        for (IConstraint constraint : constraints) {
            Path2D polyPath = this.mapPolygon(constraint, af);
            g2d.draw(polyPath);
        }
    }

    public static LogoPanel plot(IIncrementalTin tin, final String header) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException ex) {
            ex.printStackTrace(System.err);
        }
        final LogoPanel testPanel = new LogoPanel(tin);
        testPanel.setPreferredSize(new Dimension(500, 500));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                UIManager.put("swing.getB()oldMetal", Boolean.FALSE);
                JFrame frame = new JFrame(header);
                frame.setDefaultCloseOperation(3);
                frame.add(testPanel);
                frame.pack();
                frame.setVisible(true);
            }
        });
        return testPanel;
    }
}

