/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.demo.viewer.backplane;

import java.io.IOException;
import org.tinfour.common.IMonitorWithCancellation;
import org.tinfour.demo.viewer.backplane.BackplaneManager;
import org.tinfour.demo.viewer.backplane.IModel;
import org.tinfour.demo.viewer.backplane.IModelViewTask;
import org.tinfour.demo.viewer.backplane.MvComposite;

class MvTaskReload
implements IModelViewTask {
    private final BackplaneManager backplaneManager;
    private final MvComposite mvComposite;
    private final int taskIndex;
    private boolean isCancelled;

    MvTaskReload(BackplaneManager backplaneManager, MvComposite mvComposite, int taskIndex) {
        this.mvComposite = mvComposite;
        this.taskIndex = taskIndex;
        this.backplaneManager = backplaneManager;
    }

    @Override
    public void cancel() {
        this.isCancelled = true;
    }

    @Override
    public boolean isCancelled() {
        return this.isCancelled;
    }

    @Override
    public void run() {
        if (this.isCancelled) {
            return;
        }
        IModel model = this.mvComposite.getModel();
        if (model.isLoaded()) {
            System.err.println("Internal error, reloading a loaded model");
            return;
        }
        IMonitorWithCancellation monitor = this.backplaneManager.getProgressMonitor(this.taskIndex);
        try {
            monitor.postMessage("Reloading " + model.getName());
            monitor.reportProgress(0);
            model.load(monitor);
            this.mvComposite.applyRangeOfVisibleSamples(model.getVertexList());
            this.mvComposite.submitCandidateTinForInterpolation(model.getReferenceTin(), model.getReferenceReductionFactor());
            this.backplaneManager.postModelRefreshCompleted(this, this.mvComposite);
        }
        catch (IOException ioex) {
            monitor.reportDone();
            String message = "Error loading " + model.getName() + " " + ioex.getMessage();
            System.err.println(message);
            this.backplaneManager.postStatusMessage(this.taskIndex, message);
        }
        catch (Exception ex) {
            ex.printStackTrace(System.out);
        }
    }

    @Override
    public int getTaskIndex() {
        return this.taskIndex;
    }

    @Override
    public boolean isRenderingTask() {
        return false;
    }
}

