/*
 * Decompiled with CFR 0.152.
 */
package com.github.mreutegg.laszip4j.laslib;

import com.github.mreutegg.laszip4j.clib.Cstdio;
import com.github.mreutegg.laszip4j.clib.Cstdlib;
import com.github.mreutegg.laszip4j.laslib.LAScriterion;
import com.github.mreutegg.laszip4j.laszip.LASpoint;

class LAScriterionKeepRandomFraction
extends LAScriterion {
    int seed = 0;
    float fraction;

    @Override
    public String name() {
        return "keep_random_fraction";
    }

    @Override
    public int get_command(StringBuilder string) {
        return Cstdio.sprintf(string, "-%s %g ", this.name(), Float.valueOf(this.fraction));
    }

    @Override
    public boolean filter(LASpoint point) {
        Cstdlib.srand(this.seed);
        this.seed = Cstdlib.rand();
        return (float)this.seed / 65535.0f > this.fraction;
    }

    @Override
    public void reset() {
        this.seed = 0;
    }

    LAScriterionKeepRandomFraction(float fraction) {
        this.fraction = fraction;
    }
}

