/*
 * Decompiled with CFR 0.152.
 */
package com.github.mreutegg.laszip4j.laslib;

import com.github.mreutegg.laszip4j.clib.Cstdio;
import com.github.mreutegg.laszip4j.laslib.LAScriterion;
import com.github.mreutegg.laszip4j.laszip.LASpoint;

class LAScriterionKeepScanAngle
extends LAScriterion {
    private int below_scan;
    private int above_scan;

    @Override
    public String name() {
        return "keep_scan_angle";
    }

    @Override
    public int get_command(StringBuilder string) {
        return Cstdio.sprintf(string, "-%s %d %d ", this.name(), this.below_scan, this.above_scan);
    }

    @Override
    public boolean filter(LASpoint point) {
        return point.getScan_angle_rank() < this.below_scan || this.above_scan < point.getScan_angle_rank();
    }

    LAScriterionKeepScanAngle(int below_scan, int above_scan) {
        if (above_scan < below_scan) {
            this.below_scan = above_scan;
            this.above_scan = below_scan;
        } else {
            this.below_scan = below_scan;
            this.above_scan = above_scan;
        }
    }
}

