/*
 * Decompiled with CFR 0.152.
 */
package com.github.mreutegg.laszip4j.laslib;

import com.github.mreutegg.laszip4j.clib.Cstdio;
import com.github.mreutegg.laszip4j.clib.Cstring;
import com.github.mreutegg.laszip4j.laslib.LASheader;
import com.github.mreutegg.laszip4j.laslib.LASvlr;
import com.github.mreutegg.laszip4j.laslib.LASwriter;
import com.github.mreutegg.laszip4j.laszip.LASattribute;
import com.github.mreutegg.laszip4j.laszip.LASpoint;
import com.github.mreutegg.laszip4j.laszip.MyDefs;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Formatter;

public class LASwriterTXT
extends LASwriter {
    private static final PrintStream stderr = System.err;
    private boolean close_file;
    private PrintStream file;
    private LASheader header;
    private String parse_string;
    private boolean opts;
    private boolean optx;
    private float scale_rgb;
    private char separator_sign;
    private char[] printstring = new char[512];
    private int[] attribute_starts = new int[10];
    private NumberFormat precision2 = DecimalFormat.getInstance();

    boolean refile(PrintStream file) {
        this.file = file;
        return Boolean.TRUE;
    }

    void set_pts(boolean pts) {
        this.opts = pts;
    }

    void set_ptx(boolean ptx) {
        this.optx = ptx;
    }

    void set_scale_rgb(float scale_rgb) {
        this.scale_rgb = scale_rgb;
    }

    boolean open(String file_name, LASheader header, String parse_string, String separator) {
        if (file_name == null) {
            Cstdio.fprintf(stderr, "ERROR: file name pointer is zero\n", new Object[0]);
            return Boolean.FALSE;
        }
        OutputStream out = Cstdio.fopen(file_name, "w");
        if (out == null) {
            Cstdio.fprintf(stderr, "ERROR: cannot open file '%s'\n", file_name);
            return Boolean.FALSE;
        }
        this.file = new PrintStream(out);
        this.close_file = Boolean.TRUE;
        return this.open(this.file, header, parse_string, separator);
    }

    boolean open(PrintStream file, LASheader header, String parse_string, String separator) {
        if (file == null) {
            Cstdio.fprintf(stderr, "ERROR: file pointer is zero\n", new Object[0]);
            return Boolean.FALSE;
        }
        this.file = file;
        this.header = header;
        this.parse_string = parse_string;
        if (separator != null) {
            if (Cstring.strcmp(separator, "comma") == 0) {
                this.separator_sign = (char)44;
            } else if (Cstring.strcmp(separator, "tab") == 0) {
                this.separator_sign = (char)9;
            } else if (Cstring.strcmp(separator, "dot") == 0 || Cstring.strcmp(separator, "period") == 0) {
                this.separator_sign = (char)46;
            } else if (Cstring.strcmp(separator, "colon") == 0) {
                this.separator_sign = (char)58;
            } else if (Cstring.strcmp(separator, "semicolon") == 0) {
                this.separator_sign = (char)59;
            } else if (Cstring.strcmp(separator, "hyphen") == 0 || Cstring.strcmp(separator, "minus") == 0) {
                this.separator_sign = (char)45;
            } else if (Cstring.strcmp(separator, "space") == 0) {
                this.separator_sign = (char)32;
            } else {
                Cstdio.fprintf(stderr, "ERROR: unknown seperator '%s'\n", separator);
                return Boolean.FALSE;
            }
        }
        if (this.opts) {
            LASvlr ptsVLR = null;
            LASvlr ptxVLR = null;
            ptsVLR = header.get_vlr("LAStools", 2000);
            if (ptsVLR != null || (ptxVLR = header.get_vlr("LAStools", 2001)) != null) {
                if (this.parse_string == null || Cstring.strcmp(this.parse_string, "original") == 0) {
                    if (ptsVLR != null && ptsVLR.record_length_after_header >= ' ') {
                        this.parse_string = LASwriterTXT.strdup(ptsVLR.data, 16);
                    } else if (ptxVLR != null && ptxVLR.record_length_after_header >= ' ') {
                        this.parse_string = LASwriterTXT.strdup(ptxVLR.data, 16);
                    } else if (ptsVLR != null) {
                        Cstdio.fprintf(stderr, "WARNING: found VLR for PTS with wrong payload size of %d.\n", Character.valueOf(ptsVLR.record_length_after_header));
                    } else if (ptxVLR != null) {
                        Cstdio.fprintf(stderr, "WARNING: found VLR for PTX with wrong payload size of %d.\n", Character.valueOf(ptxVLR.record_length_after_header));
                    }
                }
            } else {
                Cstdio.fprintf(stderr, "WARNING: found no VLR with PTS or PTX info.\n", new Object[0]);
            }
            if (header.version_minor >= 4) {
                Cstdio.fprintf(file, "%d       \n", header.extended_number_of_point_records);
            } else {
                Cstdio.fprintf(file, "%d       \n", header.number_of_point_records);
            }
            if (this.parse_string != null && Cstring.strcmp(this.parse_string, "xyz") != 0 && Cstring.strcmp(this.parse_string, "xyzi") != 0 && Cstring.strcmp(this.parse_string, "xyziRGB") != 0 && Cstring.strcmp(this.parse_string, "xyzRGB") != 0) {
                Cstdio.fprintf(stderr, "WARNING: the parse string for PTS should be 'xyz', 'xyzi', 'xyziRGB', or 'xyzRGB'\n", new Object[0]);
            }
            if (this.separator_sign != ' ') {
                Cstdio.fprintf(stderr, "WARNING: the separator for PTS should be 'space' not '%s'\n", separator);
            }
        } else if (this.optx) {
            LASvlr ptxVLR = header.get_vlr("LAStools", 2001);
            if (ptxVLR != null && ptxVLR.record_length_after_header == '\u0110') {
                ByteBuffer payload = ByteBuffer.wrap(ptxVLR.data).order(ByteOrder.LITTLE_ENDIAN);
                if (this.parse_string == null || Cstring.strcmp(this.parse_string, "original") == 0) {
                    this.parse_string = LASwriterTXT.strdup(payload.array(), 16);
                }
                Cstdio.fprintf(file, "%d     \n", payload.getLong(32));
                Cstdio.fprintf(file, "%d     \n", payload.getLong(40));
                Cstdio.fprintf(file, "%g %g %g\n", payload.getDouble(48), payload.getDouble(56), payload.getDouble(64));
                Cstdio.fprintf(file, "%g %g %g\n", payload.getDouble(72), payload.getDouble(80), payload.getDouble(88));
                Cstdio.fprintf(file, "%g %g %g\n", payload.getDouble(96), payload.getDouble(104), payload.getDouble(112));
                Cstdio.fprintf(file, "%g %g %g\n", payload.getDouble(120), payload.getDouble(128), payload.getDouble(136));
                Cstdio.fprintf(file, "%g %g %g %g\n", payload.getDouble(144), payload.getDouble(152), payload.getDouble(160), payload.getDouble(168));
                Cstdio.fprintf(file, "%g %g %g %g\n", payload.getDouble(176), payload.getDouble(184), payload.getDouble(192), payload.getDouble(200));
                Cstdio.fprintf(file, "%g %g %g %g\n", payload.getDouble(208), payload.getDouble(216), payload.getDouble(224), payload.getDouble(232));
                Cstdio.fprintf(file, "%g %g %g %g\n", payload.getDouble(240), payload.getDouble(248), payload.getDouble(256), payload.getDouble(264));
            } else {
                if (ptxVLR != null) {
                    Cstdio.fprintf(stderr, "WARNING: found VLR for PTX with wrong payload size of %d.\n", Character.valueOf(ptxVLR.record_length_after_header));
                } else {
                    Cstdio.fprintf(stderr, "WARNING: found no VLR with PTX info.\n", new Object[0]);
                }
                Cstdio.fprintf(stderr, "         outputting PTS instead ...\n", new Object[0]);
                if (header.version_minor >= 4) {
                    Cstdio.fprintf(file, "%d       \n", header.extended_number_of_point_records);
                } else {
                    Cstdio.fprintf(file, "%d       \n", header.number_of_point_records);
                }
            }
            if (this.parse_string != null && Cstring.strcmp(this.parse_string, "xyz") != 0 && Cstring.strcmp(this.parse_string, "xyzi") != 0 && Cstring.strcmp(this.parse_string, "xyziRGB") != 0 && Cstring.strcmp(this.parse_string, "xyzRGB") != 0) {
                Cstdio.fprintf(stderr, "WARNING: the parse string for PTX should be 'xyz', 'xyzi', 'xyziRGB', or 'xyzRGB'\n", new Object[0]);
            }
            if (this.separator_sign != ' ') {
                Cstdio.fprintf(stderr, "WARNING: the separator for PTX should be 'space' not '%s'\n", separator);
            }
        }
        if (this.parse_string == null || this.parse_string.isEmpty()) {
            this.parse_string = header.point_data_format == 1 || header.point_data_format == 4 ? LASwriterTXT.strdup("xyzt") : (header.point_data_format == 2 ? LASwriterTXT.strdup("xyzRGB") : (header.point_data_format == 3 || header.point_data_format == 5 ? LASwriterTXT.strdup("xyztRGB") : LASwriterTXT.strdup("xyz")));
        }
        return this.check_parse_string(this.parse_string);
    }

    static void lidardouble2string(char[] string, double value) {
        int len = Cstdio.sprintf(string, "%.15f", value) - 1;
        while (string[len] == '0') {
            --len;
        }
        if (string[len] != '.') {
            ++len;
        }
        string[len] = '\u0000';
    }

    void lidardouble2string(Appendable appendable, double value, double precision) {
        Formatter f = new Formatter(appendable);
        if (precision == 0.1) {
            f.format("%.1f", value);
        } else if (precision == 0.01) {
            try {
                appendable.append(this.precision2.format(value));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        } else if (precision == 0.001) {
            f.format("%.3f", value);
        } else if (precision == 1.0E-4) {
            f.format("%.4f", value);
        } else if (precision == 1.0E-5) {
            f.format("%.5f", value);
        } else if (precision == 1.0E-6) {
            f.format("%.6f", value);
        } else if (precision == 1.0E-7) {
            f.format("%.7f", value);
        } else if (precision == 1.0E-8) {
            f.format("%.8f", value);
        } else if (precision == 1.0E-9) {
            f.format("%.9f", value);
        } else {
            f.format("%.15f", value);
        }
    }

    static void lidardouble2string(char[] string, double value, double precision) {
        if (precision == 0.1) {
            Cstdio.sprintf(string, "%.1f", value);
        } else if (precision == 0.01) {
            Cstdio.sprintf(string, "%.2f", value);
        } else if (precision == 0.001) {
            Cstdio.sprintf(string, "%.3f", value);
        } else if (precision == 1.0E-4) {
            Cstdio.sprintf(string, "%.4f", value);
        } else if (precision == 1.0E-5) {
            Cstdio.sprintf(string, "%.5f", value);
        } else if (precision == 1.0E-6) {
            Cstdio.sprintf(string, "%.6f", value);
        } else if (precision == 1.0E-7) {
            Cstdio.sprintf(string, "%.7f", value);
        } else if (precision == 1.0E-8) {
            Cstdio.sprintf(string, "%.8f", value);
        } else if (precision == 1.0E-9) {
            Cstdio.sprintf(string, "%.9f", value);
        } else {
            LASwriterTXT.lidardouble2string(string, value);
        }
    }

    private boolean unparse_attribute(LASpoint point, int index) {
        if (index >= this.header.number_attributes) {
            return Boolean.FALSE;
        }
        if (((LASattribute)this.header.attributes.get((int)index)).data_type == 1) {
            byte value = point.get_attributeUByte(this.attribute_starts[index]);
            if (((LASattribute)this.header.attributes.get(index)).has_scale() || ((LASattribute)this.header.attributes.get(index)).has_offset()) {
                double temp_d = ((LASattribute)this.header.attributes.get((int)index)).scale[0] * (double)value + ((LASattribute)this.header.attributes.get((int)index)).offset[0];
                Cstdio.fprintf(this.file, "%g", temp_d);
            } else {
                Cstdio.fprintf(this.file, "%d", value);
            }
        } else if (((LASattribute)this.header.attributes.get((int)index)).data_type == 2) {
            byte value = point.get_attributeByte(this.attribute_starts[index]);
            if (((LASattribute)this.header.attributes.get(index)).has_scale() || ((LASattribute)this.header.attributes.get(index)).has_offset()) {
                double temp_d = ((LASattribute)this.header.attributes.get((int)index)).scale[0] * (double)value + ((LASattribute)this.header.attributes.get((int)index)).offset[0];
                Cstdio.fprintf(this.file, "%g", temp_d);
            } else {
                Cstdio.fprintf(this.file, "%d", value);
            }
        } else if (((LASattribute)this.header.attributes.get((int)index)).data_type == 3) {
            char value = point.get_attributeChar(this.attribute_starts[index]);
            if (((LASattribute)this.header.attributes.get(index)).has_scale() || ((LASattribute)this.header.attributes.get(index)).has_offset()) {
                double temp_d = ((LASattribute)this.header.attributes.get((int)index)).scale[0] * (double)value + ((LASattribute)this.header.attributes.get((int)index)).offset[0];
                Cstdio.fprintf(this.file, "%g", temp_d);
            } else {
                Cstdio.fprintf(this.file, "%d", value);
            }
        } else if (((LASattribute)this.header.attributes.get((int)index)).data_type == 4) {
            short value = point.get_attributeShort(this.attribute_starts[index]);
            if (((LASattribute)this.header.attributes.get(index)).has_scale() || ((LASattribute)this.header.attributes.get(index)).has_offset()) {
                double temp_d = ((LASattribute)this.header.attributes.get((int)index)).scale[0] * (double)value + ((LASattribute)this.header.attributes.get((int)index)).offset[0];
                Cstdio.fprintf(this.file, "%g", temp_d);
            } else {
                Cstdio.fprintf(this.file, "%d", value);
            }
        } else if (((LASattribute)this.header.attributes.get((int)index)).data_type == 5) {
            int value = point.get_attributeUInt(this.attribute_starts[index]);
            if (((LASattribute)this.header.attributes.get(index)).has_scale() || ((LASattribute)this.header.attributes.get(index)).has_offset()) {
                double temp_d = ((LASattribute)this.header.attributes.get((int)index)).scale[0] * (double)value + ((LASattribute)this.header.attributes.get((int)index)).offset[0];
                Cstdio.fprintf(this.file, "%g", temp_d);
            } else {
                Cstdio.fprintf(this.file, "%d", value);
            }
        } else if (((LASattribute)this.header.attributes.get((int)index)).data_type == 6) {
            int value = point.get_attributeInt(this.attribute_starts[index]);
            if (((LASattribute)this.header.attributes.get(index)).has_scale() || ((LASattribute)this.header.attributes.get(index)).has_offset()) {
                double temp_d = ((LASattribute)this.header.attributes.get((int)index)).scale[0] * (double)value + ((LASattribute)this.header.attributes.get((int)index)).offset[0];
                Cstdio.fprintf(this.file, "%g", temp_d);
            } else {
                Cstdio.fprintf(this.file, "%d", value);
            }
        } else if (((LASattribute)this.header.attributes.get((int)index)).data_type == 9) {
            float value = point.get_attributeFloat(this.attribute_starts[index]);
            if (((LASattribute)this.header.attributes.get(index)).has_scale() || ((LASattribute)this.header.attributes.get(index)).has_offset()) {
                double temp_d = ((LASattribute)this.header.attributes.get((int)index)).scale[0] * (double)value + ((LASattribute)this.header.attributes.get((int)index)).offset[0];
                Cstdio.fprintf(this.file, "%g", temp_d);
            } else {
                Cstdio.fprintf(this.file, "%g", Float.valueOf(value));
            }
        } else if (((LASattribute)this.header.attributes.get((int)index)).data_type == 10) {
            double value = point.get_attributeDouble(this.attribute_starts[index]);
            if (((LASattribute)this.header.attributes.get(index)).has_scale() || ((LASattribute)this.header.attributes.get(index)).has_offset()) {
                double temp_d = ((LASattribute)this.header.attributes.get((int)index)).scale[0] * value + ((LASattribute)this.header.attributes.get((int)index)).offset[0];
                Cstdio.fprintf(this.file, "%g", temp_d);
            } else {
                Cstdio.fprintf(this.file, "%g", value);
            }
        } else {
            Cstdio.fprintf(stderr, "WARNING: attribute %d not (yet) implemented.\n", index);
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public boolean write_point(LASpoint point) {
        ++this.p_count;
        int i = 0;
        while (true) {
            switch (this.parse_string.charAt(i)) {
                case 'x': {
                    this.lidardouble2string(this.file, this.header.get_x(point.get_X()), this.header.x_scale_factor);
                    break;
                }
                case 'y': {
                    this.lidardouble2string(this.file, this.header.get_y(point.get_Y()), this.header.y_scale_factor);
                    break;
                }
                case 'z': {
                    this.lidardouble2string(this.file, this.header.get_z(point.get_Z()), this.header.z_scale_factor);
                    break;
                }
                case 't': {
                    Cstdio.fprintf(this.file, "%.6f", point.get_gps_time());
                    break;
                }
                case 'i': {
                    if (this.opts) {
                        Cstdio.fprintf(this.file, "%d", -2048 + point.get_intensity());
                        break;
                    }
                    if (this.optx) {
                        int len = Cstdio.sprintf(this.printstring, "%.3f", Float.valueOf(2.4420026E-4f * (float)point.get_intensity())) - 1;
                        while (this.printstring[len] == '0') {
                            --len;
                        }
                        if (this.printstring[len] != '.') {
                            ++len;
                        }
                        this.printstring[len] = '\u0000';
                        Cstdio.fprintf(this.file, "%s", Cstring.trim(this.printstring));
                        break;
                    }
                    Cstdio.fprintf(this.file, "%d", point.get_intensity());
                    break;
                }
                case 'a': {
                    Cstdio.fprintf(this.file, "%d", point.get_scan_angle_rank());
                    break;
                }
                case 'r': {
                    Cstdio.fprintf(this.file, "%d", point.get_return_number());
                    break;
                }
                case 'c': {
                    this.file.print(Byte.toUnsignedInt(point.get_classification()));
                    break;
                }
                case 'u': {
                    Cstdio.fprintf(this.file, "%d", point.get_user_data());
                    break;
                }
                case 'n': {
                    Cstdio.fprintf(this.file, "%d", point.get_number_of_returns());
                    break;
                }
                case 'p': {
                    Cstdio.fprintf(this.file, "%d", point.get_point_source_ID());
                    break;
                }
                case 'e': {
                    Cstdio.fprintf(this.file, "%d", point.get_edge_of_flight_line());
                    break;
                }
                case 'd': {
                    Cstdio.fprintf(this.file, "%d", point.get_scan_direction_flag());
                    break;
                }
                case 'R': {
                    if (this.scale_rgb != 1.0f) {
                        Cstdio.fprintf(this.file, "%.2f", Float.valueOf(this.scale_rgb * (float)point.get_rgb()[0]));
                        break;
                    }
                    Cstdio.fprintf(this.file, "%d", point.get_rgb()[0]);
                    break;
                }
                case 'G': {
                    if (this.scale_rgb != 1.0f) {
                        Cstdio.fprintf(this.file, "%.2f", Float.valueOf(this.scale_rgb * (float)point.get_rgb()[1]));
                        break;
                    }
                    Cstdio.fprintf(this.file, "%d", point.get_rgb()[1]);
                    break;
                }
                case 'B': {
                    if (this.scale_rgb != 1.0f) {
                        Cstdio.fprintf(this.file, "%.2f", Float.valueOf(this.scale_rgb * (float)point.get_rgb()[2]));
                        break;
                    }
                    Cstdio.fprintf(this.file, "%d", point.get_rgb()[2]);
                    break;
                }
                case 'm': {
                    Cstdio.fprintf(this.file, "%d", this.p_count - 1L);
                    break;
                }
                case 'M': {
                    Cstdio.fprintf(this.file, "%d", this.p_count);
                    break;
                }
                case 'w': {
                    Cstdio.fprintf(this.file, "%d", point.wavepacket.getIndex());
                    break;
                }
                case 'W': {
                    Cstdio.fprintf(this.file, "%d%c%d%c%d%c%g%c%.15g%c%.15g%c%.15g", point.wavepacket.getIndex(), Character.valueOf(this.separator_sign), (int)point.wavepacket.getOffset(), Character.valueOf(this.separator_sign), point.wavepacket.getSize(), Character.valueOf(this.separator_sign), Float.valueOf(point.wavepacket.getLocation()), Character.valueOf(this.separator_sign), Float.valueOf(point.wavepacket.getXt()), Character.valueOf(this.separator_sign), Float.valueOf(point.wavepacket.getYt()), Character.valueOf(this.separator_sign), Float.valueOf(point.wavepacket.getZt()));
                    break;
                }
                case 'X': {
                    Cstdio.fprintf(this.file, "%d", point.get_X());
                    break;
                }
                case 'Y': {
                    Cstdio.fprintf(this.file, "%d", point.get_Y());
                    break;
                }
                case 'Z': {
                    Cstdio.fprintf(this.file, "%d", point.get_Z());
                    break;
                }
                default: {
                    this.unparse_attribute(point, this.parse_string.charAt(i) - 48);
                }
            }
            if (++i >= this.parse_string.length()) break;
            this.file.print(this.separator_sign);
        }
        this.file.print("\n");
        return Boolean.TRUE;
    }

    @Override
    public boolean chunk() {
        return false;
    }

    @Override
    public boolean update_header(LASheader header, boolean use_inventory, boolean update_extra_bytes) {
        return Boolean.TRUE;
    }

    @Override
    public long close(boolean update_header) {
        int bytes = (int)Cstdio.ftell(this.file);
        if (this.file != null) {
            if (this.close_file) {
                Cstdio.fclose(this.file);
                this.close_file = Boolean.FALSE;
            }
            this.file = null;
        }
        if (this.parse_string != null) {
            this.parse_string = null;
        }
        this.npoints = this.p_count;
        this.p_count = 0L;
        return bytes;
    }

    LASwriterTXT() {
        this.precision2.setMinimumFractionDigits(2);
        this.precision2.setMaximumFractionDigits(2);
        this.precision2.setGroupingUsed(false);
        this.close_file = Boolean.FALSE;
        this.file = null;
        this.parse_string = null;
        this.separator_sign = (char)32;
        this.opts = Boolean.FALSE;
        this.optx = Boolean.FALSE;
        this.scale_rgb = 1.0f;
    }

    private boolean check_parse_string(String parse_string) {
        for (int p = 0; p < parse_string.length(); ++p) {
            if (parse_string.charAt(p) == 'x' || parse_string.charAt(p) == 'y' || parse_string.charAt(p) == 'z' || parse_string.charAt(p) == 't' || parse_string.charAt(p) == 'R' || parse_string.charAt(p) == 'G' || parse_string.charAt(p) == 'B' || parse_string.charAt(p) == 's' || parse_string.charAt(p) == 'i' || parse_string.charAt(p) == 'a' || parse_string.charAt(p) == 'n' || parse_string.charAt(p) == 'r' || parse_string.charAt(p) == 'c' || parse_string.charAt(p) == 'u' || parse_string.charAt(p) == 'p' || parse_string.charAt(p) == 'e' || parse_string.charAt(p) == 'd' || parse_string.charAt(p) == 'm' || parse_string.charAt(p) == 'M' || parse_string.charAt(p) == 'w' || parse_string.charAt(p) == 'W' || parse_string.charAt(p) == 'X' || parse_string.charAt(p) == 'Y' || parse_string.charAt(p) == 'Z') continue;
            if (parse_string.charAt(p) >= '0' && parse_string.charAt(p) <= '9') {
                int index = parse_string.charAt(p) - 48;
                if (index >= this.header.number_attributes) {
                    Cstdio.fprintf(stderr, "ERROR: extra bytes attribute '%d' does not exist.\n", index);
                    return Boolean.FALSE;
                }
                this.attribute_starts[index] = this.header.get_attribute_start(index);
                continue;
            }
            Cstdio.fprintf(stderr, "ERROR: unknown symbol '%c' in parse string. valid are\n", Character.valueOf(parse_string.charAt(p)));
            Cstdio.fprintf(stderr, "       'x' : the x coordinate\n", new Object[0]);
            Cstdio.fprintf(stderr, "       'y' : the y coordinate\n", new Object[0]);
            Cstdio.fprintf(stderr, "       'z' : the z coordinate\n", new Object[0]);
            Cstdio.fprintf(stderr, "       't' : the gps time\n", new Object[0]);
            Cstdio.fprintf(stderr, "       'R' : the red channel of the RGB field\n", new Object[0]);
            Cstdio.fprintf(stderr, "       'G' : the green channel of the RGB field\n", new Object[0]);
            Cstdio.fprintf(stderr, "       'B' : the blue channel of the RGB field\n", new Object[0]);
            Cstdio.fprintf(stderr, "       's' : a string or a number that we don't care about\n", new Object[0]);
            Cstdio.fprintf(stderr, "       'i' : the intensity\n", new Object[0]);
            Cstdio.fprintf(stderr, "       'a' : the scan angle\n", new Object[0]);
            Cstdio.fprintf(stderr, "       'n' : the number of returns of that given pulse\n", new Object[0]);
            Cstdio.fprintf(stderr, "       'r' : the number of the return\n", new Object[0]);
            Cstdio.fprintf(stderr, "       'c' : the classification\n", new Object[0]);
            Cstdio.fprintf(stderr, "       'u' : the user data\n", new Object[0]);
            Cstdio.fprintf(stderr, "       'p' : the point source ID\n", new Object[0]);
            Cstdio.fprintf(stderr, "       'e' : the edge of flight line flag\n", new Object[0]);
            Cstdio.fprintf(stderr, "       'd' : the direction of scan flag\n", new Object[0]);
            Cstdio.fprintf(stderr, "       'M' : the index of the point\n", new Object[0]);
            Cstdio.fprintf(stderr, "       'w' : the wavepacket descriptor index\n", new Object[0]);
            Cstdio.fprintf(stderr, "       'W' : all wavepacket attributes\n", new Object[0]);
            Cstdio.fprintf(stderr, "       'X' : the unscaled and unoffset integer x coordinate\n", new Object[0]);
            Cstdio.fprintf(stderr, "       'Y' : the unscaled and unoffset integer y coordinate\n", new Object[0]);
            Cstdio.fprintf(stderr, "       'Z' : the unscaled and unoffset integer z coordinate\n", new Object[0]);
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private static String strdup(byte[] data, int offset) {
        byte[] bytes = new byte[data.length - offset];
        System.arraycopy(data, offset, bytes, 0, bytes.length);
        return MyDefs.stringFromByteArray(bytes);
    }

    private static String strdup(String s) {
        return s;
    }
}

