/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.contour;

import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import org.tinfour.contour.Contour;
import org.tinfour.contour.ContourRegionMember;

public class ContourRegion {
    final ContourRegionType contourRegionType;
    final List<ContourRegionMember> memberList = new ArrayList<ContourRegionMember>();
    final int regionIndex;
    final double area;
    final double absArea;
    final double xTest;
    final double yTest;
    final List<ContourRegion> children = new ArrayList<ContourRegion>();
    ContourRegion parent;

    ContourRegion(List<ContourRegionMember> memberList, int regionIndex) {
        if (memberList.isEmpty()) {
            throw new IllegalArgumentException("An empty specification for a region geometry is not supported");
        }
        this.regionIndex = regionIndex;
        this.memberList.addAll(memberList);
        double a = 0.0;
        ContourRegionType rType = ContourRegionType.Interior;
        for (ContourRegionMember member : memberList) {
            if (member.contour.getContourType() == Contour.ContourType.Perimeter) {
                rType = ContourRegionType.Perimeter;
            }
            double s = this.calculateAreaContribution(member.contour);
            if (member.forward) {
                a += s;
                continue;
            }
            a -= s;
        }
        this.contourRegionType = rType;
        this.area = a / 2.0;
        this.absArea = Math.abs(this.area);
        Contour contour = memberList.get((int)0).contour;
        this.xTest = (contour.xy[0] + contour.xy[2]) / 2.0;
        this.yTest = (contour.xy[1] + contour.xy[3]) / 2.0;
    }

    ContourRegion(Contour contour) {
        this.contourRegionType = contour.getContourType() == Contour.ContourType.Interior ? ContourRegionType.Interior : ContourRegionType.Perimeter;
        assert (contour.closedLoop) : "Single contour constructor requires closed loop";
        this.memberList.add(new ContourRegionMember(contour, true));
        this.area = this.calculateAreaContribution(contour) / 2.0;
        this.absArea = Math.abs(this.area);
        this.regionIndex = this.area < 0.0 ? contour.rightIndex : contour.leftIndex;
        this.xTest = (contour.xy[0] + contour.xy[2]) / 2.0;
        this.yTest = (contour.xy[1] + contour.xy[3]) / 2.0;
    }

    private double calculateAreaContribution(Contour contour) {
        double x0 = contour.xy[0];
        double y0 = contour.xy[1];
        int n = contour.n / 2;
        double a = 0.0;
        for (int i = 1; i < n; ++i) {
            double x1 = contour.xy[i * 2];
            double y1 = contour.xy[i * 2 + 1];
            a += x0 * y1 - x1 * y0;
            x0 = x1;
            y0 = y1;
        }
        return a;
    }

    public double[] getXY() {
        Contour contour = this.memberList.get((int)0).contour;
        if (this.memberList.size() == 1 && this.memberList.get((int)0).contour.isClosed()) {
            return contour.getCoordinates();
        }
        int n = 0;
        for (ContourRegionMember member : this.memberList) {
            n += member.contour.size() - 1;
        }
        double[] xy = new double[++n * 2];
        int k = 0;
        for (ContourRegionMember member : this.memberList) {
            int i;
            contour = member.contour;
            n = contour.size();
            if (member.forward) {
                for (i = 0; i < n - 1; ++i) {
                    xy[k++] = contour.xy[i * 2];
                    xy[k++] = contour.xy[i * 2 + 1];
                }
                continue;
            }
            for (i = n - 1; i > 0; --i) {
                xy[k++] = contour.xy[i * 2];
                xy[k++] = contour.xy[i * 2 + 1];
            }
        }
        xy[k++] = xy[0];
        xy[k] = xy[1];
        return xy;
    }

    void addChild(ContourRegion region) {
        this.children.add(region);
        region.parent = this;
    }

    void setParent(ContourRegion parent) {
        this.parent = parent;
    }

    public boolean isPointInsideRegion(double x, double y) {
        double[] xy = this.getXY();
        return this.isPointInsideRegion(xy, x, y);
    }

    public boolean isPointInsideRegion(double[] xy, double x, double y) {
        int rCross = 0;
        int lCross = 0;
        int n = xy.length / 2;
        double x0 = xy[0];
        double y0 = xy[1];
        for (int i = 1; i < n; ++i) {
            double xTest;
            double x1 = xy[i * 2];
            double y1 = xy[i * 2 + 1];
            double yDelta = y0 - y1;
            if (y1 > y != y0 > y && (xTest = (x1 * y0 - x0 * y1 + y * (x0 - x1)) / yDelta) > x) {
                ++rCross;
            }
            if (y1 < y != y0 < y && (xTest = (x1 * y0 - x0 * y1 + y * (x0 - x1)) / yDelta) < x) {
                ++lCross;
            }
            x0 = x1;
            y0 = y1;
        }
        if ((rCross ^ lCross) & true) {
            return false;
        }
        return rCross & true;
    }

    public double getAbsoluteArea() {
        return this.absArea;
    }

    public double getAdjustedArea() {
        double sumArea = this.absArea;
        for (ContourRegion enclosedRegion : this.children) {
            sumArea -= enclosedRegion.getAbsoluteArea();
        }
        return sumArea;
    }

    public double getSignedArea() {
        return this.area;
    }

    public int getRegionIndex() {
        return this.regionIndex;
    }

    public Path2D getPath2D(AffineTransform transform) {
        AffineTransform af = transform;
        if (af == null) {
            af = new AffineTransform();
        }
        double[] xy = this.getXY();
        Path2D.Double path = new Path2D.Double();
        this.appendPathForward(af, path, xy);
        return path;
    }

    public Path2D getPathWithNesting(AffineTransform transform) {
        AffineTransform af = transform;
        if (af == null) {
            af = new AffineTransform();
        }
        double[] xy = this.getXY();
        Path2D.Double path = new Path2D.Double();
        path.setWindingRule(0);
        this.appendPathForward(transform, path, xy);
        for (ContourRegion child : this.children) {
            xy = child.getXY();
            this.appendPathForward(af, path, xy);
        }
        return path;
    }

    private void appendPathForward(AffineTransform transform, Path2D path, double[] xy) {
        int n = xy.length / 2;
        if (n < 2) {
            return;
        }
        double[] c = new double[n * 2];
        transform.transform(xy, 0, c, 0, n);
        path.moveTo(c[0], c[1]);
        for (int i = 1; i < n; ++i) {
            path.lineTo(c[i * 2], c[i * 2 + 1]);
        }
        path.closePath();
    }

    public Point2D getTestPoint() {
        return new Point2D.Double(this.xTest, this.yTest);
    }

    public List<ContourRegion> getEnclosedRegions() {
        ArrayList<ContourRegion> nList = new ArrayList<ContourRegion>();
        nList.addAll(this.children);
        return nList;
    }

    public String toString() {
        String areaString = this.absArea > 0.1 ? String.format("%12.3f", this.area) : String.format("%f", this.area);
        return String.format("%4d %s  %s %3d", this.regionIndex, areaString, this.parent == null ? "root " : "child", this.children.size());
    }

    public static enum ContourRegionType {
        Interior,
        Perimeter;

    }
}

