/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.demo.utils;

import java.text.ParseException;
import java.util.Formatter;

public class TextCoordGeo {
    boolean latFound;
    boolean lonFound;
    double[] v = new double[3];
    double[] coord = new double[2];
    CoordType[] coordType = new CoordType[2];
    int nV;
    int nCoord;
    double latitude;
    double longitude;

    private boolean isQuad(char c) {
        if (Character.isUpperCase(c)) {
            return c == 'N' || c == 'S' || c == 'E' || c == 'W';
        }
        return c == 'n' || c == 's' || c == 'e' || c == 'w';
    }

    private boolean isLat(char c) {
        return c == 'N' || c == 'S' || c == 'n' || c == 's';
    }

    private double quadSign(char c) {
        if (c == 'N' || c == 'n' || c == 'E' || c == 'e') {
            return 1.0;
        }
        return -1.0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public double[] parse(String text) throws ParseException {
        int i0;
        this.nV = 0;
        this.nCoord = 0;
        boolean joinedNumbers = false;
        this.latitude = Double.NaN;
        this.longitude = Double.NaN;
        this.latFound = false;
        this.lonFound = false;
        if (text == null || text.isEmpty()) {
            throw new ParseException("Null input", 0);
        }
        char c = '\u0000';
        for (i0 = 0; i0 < text.length() && Character.isWhitespace(c = text.charAt(i0)); ++i0) {
        }
        if (i0 == text.length()) {
            throw new ParseException("Null input", 0);
        }
        StringBuilder numStr = new StringBuilder();
        if (c == '-' || c == '+' || c == '.') {
            numStr.append(c);
        } else {
            if (!Character.isDigit(c)) throw new ParseException("Invalid text ", i0);
            numStr.append(c);
        }
        int i = i0 + 1;
        while (i < text.length()) {
            c = text.charAt(i);
            if (Character.isWhitespace(c)) {
                if (numStr.length() > 0) {
                    this.processNumberString(i, numStr);
                    if (joinedNumbers) {
                        this.processDMS(i);
                        joinedNumbers = false;
                    }
                }
                ++i;
                continue;
            }
            if (Character.isDigit(c) || c == '.') {
                numStr.append(c);
                ++i;
                continue;
            }
            if (!(c != 'E' && c != 'e' || i >= text.length() - 1 || text.charAt(i + 1) != '+' && text.charAt(i + 1) != '-')) {
                if (numStr.length() == 0) {
                    throw new ParseException("Improper text where exponential notation expected", i);
                }
                numStr.append(c);
                numStr.append(text.charAt(i + 1));
                i += 2;
                continue;
            }
            if (this.isQuad(c)) {
                boolean latFlag = false;
                if (this.isLat(c)) {
                    if (this.latFound) {
                        throw new ParseException("Multiple latitude specifications", i);
                    }
                    latFlag = true;
                } else if (this.lonFound) {
                    throw new ParseException("Multiple longitude specifications", i);
                }
                if (numStr.length() > 0) {
                    this.processNumberString(i, numStr);
                }
                if (this.nV == 0 && (this.nCoord <= 0 || this.coordType[this.nCoord - 1] != CoordType.Unspecified)) {
                    throw new ParseException("Incomplete coordinate specification", i);
                }
                if (this.nV > 0) {
                    this.processDMS(i);
                }
                if (this.coord[this.nCoord - 1] < 0.0) {
                    throw new ParseException("Text must not include both quadrant and negative value", i);
                }
                int n = this.nCoord - 1;
                this.coord[n] = this.coord[n] * this.quadSign(c);
                this.coordType[this.nCoord - 1] = latFlag ? CoordType.Latitude : CoordType.Longitude;
                if (latFlag) {
                    this.latFound = true;
                } else {
                    this.lonFound = true;
                }
            } else if (c == '-') {
                if (i == text.length() - 1) {
                    throw new ParseException("Minus sign out of place", i);
                }
                if (this.nV == 1 && !joinedNumbers) {
                    this.processDMS(i);
                }
                if (numStr.length() == 0) {
                    if (!Character.isDigit(text.charAt(i + 1))) throw new ParseException("Minus sign out of place", i);
                    numStr.append(c);
                } else {
                    if (!Character.isDigit(text.charAt(i - 1)) || !Character.isDigit(text.charAt(i + 1))) throw new ParseException("Minus sign out of place", i);
                    this.processNumberString(i, numStr);
                    joinedNumbers = true;
                }
            } else if (c == '\u00b0' || c == '\'' || c == '\"') {
                if (numStr.length() > 0) {
                    this.processNumberString(i, numStr);
                }
                if (c == '\u00b0') {
                    if (this.nV != 1) {
                        throw new ParseException("Degrees symbol out of place", i);
                    }
                } else if (c == '\'') {
                    if (this.nV != 2) {
                        throw new ParseException("Minutes symbol out of place", i);
                    }
                } else {
                    if (this.nV != 3) throw new ParseException("Seconds symbol out of place", i);
                    this.processDMS(i);
                }
            } else if (c == '/') {
                if (this.nCoord == 2) {
                    throw new ParseException("Too many coordinate specifications", i);
                }
                if (numStr.length() > 0) {
                    this.processNumberString(i, numStr);
                }
                if (this.nV > 0) {
                    this.processDMS(i);
                }
            }
            ++i;
        }
        if (numStr.length() > 0) {
            this.processNumberString(i, numStr);
            this.processDMS(i);
        }
        if (this.nCoord < 2 && this.nCoord == 2) {
            throw new ParseException("Too few coordinate specifications", i);
        }
        if (this.coordType[0] == CoordType.Unspecified || this.coordType[1] == CoordType.Unspecified) {
            this.coordType[0] = CoordType.Latitude;
            this.coordType[1] = CoordType.Longitude;
        } else if (this.coordType[0] == CoordType.Unspecified) {
            if (this.coordType[1] == CoordType.Latitude) {
                this.coordType[0] = CoordType.Longitude;
            } else if (this.coordType[1] == CoordType.Longitude) {
                this.coordType[0] = CoordType.Latitude;
            }
        } else if (this.coordType[1] == CoordType.Unspecified) {
            if (this.coordType[0] == CoordType.Latitude) {
                this.coordType[1] = CoordType.Longitude;
            } else if (this.coordType[0] == CoordType.Longitude) {
                this.coordType[1] = CoordType.Latitude;
            }
        }
        if (this.coordType[0] == CoordType.Latitude) {
            this.latitude = this.coord[0];
            this.longitude = this.coord[1];
        } else {
            this.latitude = this.coord[1];
            this.longitude = this.coord[0];
        }
        if (Math.abs(this.latitude) > 90.0) {
            throw new ParseException("Latitude value out of range: " + this.latitude, i);
        }
        if (Math.abs(this.longitude) > 180.0) {
            if (Math.abs(this.longitude) > 360.0) {
                throw new ParseException("Longitude value out of range: " + this.longitude, i);
            }
            this.longitude = this.longitude < 0.0 ? (this.longitude += 360.0) : 360.0 + this.longitude;
        }
        double[] geo = new double[]{this.latitude, this.longitude};
        return geo;
    }

    private void processNumberString(int iPos, StringBuilder numStr) throws ParseException {
        if (this.nV == 3) {
            throw new ParseException("More than 3 numeric specifications", iPos);
        }
        try {
            double d = Double.parseDouble(numStr.toString());
            if (this.nV > 0) {
                if (d < 0.0) {
                    throw new ParseException("Minutes and seconds specifications cannot be negative", iPos);
                }
                if (this.v[this.nV - 1] != Math.floor(this.v[this.nV - 1])) {
                    throw new ParseException("Non-integral value not allowed " + this.v[this.nV - 1], iPos);
                }
            }
            this.v[this.nV++] = d;
            numStr.setLength(0);
        }
        catch (NumberFormatException nex) {
            String complaint = "Invalid text where numeric expected " + numStr.toString();
            throw new ParseException(complaint, iPos);
        }
    }

    private void processDMS(int iPos) throws ParseException {
        if (this.nCoord == 2) {
            throw new ParseException("Extra text after 2nd coordinate", iPos);
        }
        this.coordType[this.nCoord] = CoordType.Unspecified;
        if (this.nV == 1) {
            this.coord[this.nCoord++] = this.v[0];
        } else if (this.nV == 2) {
            if (this.v[1] >= 60.0) {
                throw new ParseException("Minutes must be less than 60", iPos);
            }
            this.coord[this.nCoord++] = this.v[0] + this.v[1] / 60.0;
        } else {
            if (this.v[1] >= 60.0 || this.v[2] >= 60.0) {
                throw new ParseException("Minutes and seconds must be less than 60", iPos);
            }
            this.coord[this.nCoord++] = this.v[0] + (this.v[1] + this.v[2] / 60.0) / 60.0;
        }
        this.nV = 0;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public String format(double lat, double lon) {
        double cLon = lon;
        if (cLon < -180.0) {
            cLon += 360.0;
        } else if (lon >= 180.0) {
            cLon -= 360.0;
        } else if (lon == 360.0) {
            cLon = 0.0;
        }
        char quadLat = lat >= 0.0 ? (char)'N' : 'S';
        char quadLon = cLon >= 0.0 ? (char)'E' : 'W';
        StringBuilder sb = new StringBuilder(32);
        Formatter fmt = new Formatter(sb);
        this.formatDMS(fmt, lat, quadLat);
        sb.append(" / ");
        this.formatDMS(fmt, lon, quadLon);
        return sb.toString();
    }

    void formatDMS(Formatter fmt, double value, char quad) {
        int s;
        int c = (int)Math.floor(Math.abs(value) * 3600.0 * 100.0 + 0.5);
        int d = c / 360000;
        int m = (c -= d * 360000) / 6000;
        c -= m * 6000;
        if ((c -= (s = c / 100) * 100) == 0) {
            fmt.format("%d-%02d-%02d%c", d, m, s, Character.valueOf(quad));
        } else {
            fmt.format("%d-%02d-%02d.%02d%c", d, m, s, c, Character.valueOf(quad));
        }
    }

    private static enum CoordType {
        Unspecified,
        Latitude,
        Longitude;

    }
}

