/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.demo.viewer.backplane;

import java.io.IOException;
import org.tinfour.common.IMonitorWithCancellation;
import org.tinfour.demo.viewer.backplane.BackplaneManager;
import org.tinfour.demo.viewer.backplane.IModel;
import org.tinfour.demo.viewer.backplane.IModelViewTask;

class MvTaskLoad
implements IModelViewTask {
    private final BackplaneManager backplaneManager;
    private final IModel model;
    private final int taskIndex;
    private boolean isCancelled;

    MvTaskLoad(BackplaneManager backplaneManager, IModel model, int taskIndex) {
        this.model = model;
        this.taskIndex = taskIndex;
        this.backplaneManager = backplaneManager;
    }

    @Override
    public void cancel() {
        this.isCancelled = true;
    }

    @Override
    public boolean isCancelled() {
        return this.isCancelled;
    }

    @Override
    public void run() {
        if (this.isCancelled) {
            return;
        }
        try {
            IMonitorWithCancellation monitor = this.backplaneManager.getProgressMonitor(this.taskIndex);
            this.model.load(monitor);
            monitor.reportDone();
            this.backplaneManager.postModelLoadCompleted(this, this.model, this.taskIndex);
        }
        catch (IOException ioex) {
            String message = "Error loading " + this.model.getName() + " " + ioex.getMessage();
            System.err.println(message);
            this.backplaneManager.postStatusMessage(this.taskIndex, message);
        }
        catch (Exception ex) {
            ex.printStackTrace(System.out);
        }
    }

    @Override
    public int getTaskIndex() {
        return this.taskIndex;
    }

    IModel getModel() {
        return this.model;
    }

    @Override
    public boolean isRenderingTask() {
        return false;
    }
}

