/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.edge;

import org.tinfour.common.Vertex;
import org.tinfour.edge.QuadEdge;

class QuadEdgePartner
extends QuadEdge {
    QuadEdgePartner(QuadEdge partner) {
        super(partner);
        this.index = 0;
    }

    @Override
    public int getIndex() {
        return this.dual.index + 1;
    }

    @Override
    protected void setIndex(int index) {
        this.dual.index = index;
    }

    @Override
    public QuadEdge getBaseReference() {
        return this.dual;
    }

    @Override
    public void setVertices(Vertex a, Vertex b) {
        this.v = a;
        this.dual.v = b;
    }

    @Override
    public int getSide() {
        return 1;
    }

    @Override
    public void clear() {
        this.v = null;
        this.f = null;
        this.r = null;
        this.dual.v = null;
        this.dual.f = null;
        this.dual.r = null;
        this.index = 0;
    }

    @Override
    public int getConstraintIndex() {
        return this.index & 0xFFFFFF;
    }

    @Override
    public void setConstraintIndex(int constraintIndex) {
        if (constraintIndex < 0 || constraintIndex > 0xFFFFFC) {
            throw new IllegalArgumentException("Constraint index " + constraintIndex + " is out of range [0.." + 0xFFFFFC + "]");
        }
        this.index = this.index & 0xFF000000 | constraintIndex;
    }

    @Override
    public void setConstrained(int constraintIndex) {
        if (constraintIndex < 0 || constraintIndex > 0xFFFFFC) {
            throw new IllegalArgumentException("Constraint index " + constraintIndex + " is out of range [0.." + 0xFFFFFC + "]");
        }
        this.index = Integer.MIN_VALUE | (this.index & 0xFF000000 | constraintIndex);
    }

    @Override
    public boolean isConstrained() {
        return this.index < 0;
    }

    @Override
    public boolean isConstrainedRegionBorder() {
        return (this.index & 0x40000000) != 0;
    }

    @Override
    public boolean isConstrainedRegionInterior() {
        return (this.index & 0x20000000) != 0;
    }

    @Override
    public boolean isConstrainedRegionMember() {
        return (this.index & 0x60000000) != 0;
    }

    @Override
    public void setConstrainedRegionBorderFlag() {
        this.index |= 0x40000000;
    }

    @Override
    public boolean isConstraintLineMember() {
        return (this.index & 0x10000000) != 0;
    }

    @Override
    public void setConstraintLineMemberFlag() {
        this.index |= 0x90000000;
    }

    @Override
    public void setConstrainedRegionInteriorFlag() {
        this.index |= 0x20000000;
    }

    @Override
    public void setSynthetic(boolean status) {
        this.index = status ? (this.index |= 0x8000000) : (this.index &= 0xF7FFFFFF);
    }

    @Override
    public boolean isSynthetic() {
        return (this.index & 0x8000000) != 0;
    }
}

