/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.gis.utils;

import com.github.mreutegg.laszip4j.LASPoint;
import com.github.mreutegg.laszip4j.LASReader;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.tinfour.common.IMonitorWithCancellation;
import org.tinfour.common.Vertex;
import org.tinfour.gis.las.ILasRecordFilter;
import org.tinfour.gis.las.LasPoint;
import org.tinfour.gis.las.LasScaleAndOffset;
import org.tinfour.gis.utils.VertexWithClassification;
import org.tinfour.utils.loaders.CoordinatePair;
import org.tinfour.utils.loaders.ICoordinateTransform;

class VertexReaderLaz {
    LasScaleAndOffset lasScaleAndOffset;
    ICoordinateTransform coordinateTransform;
    long maximumNumberOfVertices;

    VertexReaderLaz(LasScaleAndOffset lasScaleAndOffset, ICoordinateTransform coordinateTransform, long maximumNumberOfVertices) {
        this.lasScaleAndOffset = lasScaleAndOffset;
        this.coordinateTransform = coordinateTransform;
        this.maximumNumberOfVertices = maximumNumberOfVertices;
    }

    List<Vertex> loadVertices(File file, long nVertices, ILasRecordFilter filter, IMonitorWithCancellation monitor) throws IOException {
        ArrayList<Vertex> list = new ArrayList<Vertex>();
        int iProgressThreshold = Integer.MAX_VALUE;
        int pProgressThreshold = 0;
        if (monitor != null) {
            int iPercent = monitor.getReportingIntervalInPercent();
            int iTemp = (int)((double)nVertices * ((double)iPercent / 100.0) + 0.5);
            if (iTemp > 1) {
                iProgressThreshold = iTemp;
            }
            monitor.reportProgress(0);
        }
        LASReader reader = new LASReader(file);
        LasScaleAndOffset so = this.lasScaleAndOffset;
        LasPoint t4Point = new LasPoint();
        int iRecord = 0;
        CoordinatePair scratch = new CoordinatePair();
        for (LASPoint p : reader.getPoints()) {
            if (pProgressThreshold == iProgressThreshold) {
                pProgressThreshold = 0;
                monitor.reportProgress((int)(0.1 + 100.0 * (double)(iRecord + 1) / (double)nVertices));
                if (monitor.isCanceled()) {
                    break;
                }
            } else {
                ++pProgressThreshold;
            }
            if ((long)list.size() >= this.maximumNumberOfVertices) break;
            ++iRecord;
            if (p.isWithheld()) continue;
            t4Point.x = (double)p.getX() * so.xScaleFactor + so.xOffset;
            t4Point.y = (double)p.getY() * so.yScaleFactor + so.yOffset;
            t4Point.z = (double)p.getZ() * so.zScaleFactor + so.zOffset;
            t4Point.classification = p.getClassification();
            t4Point.returnNumber = p.getReturnNumber();
            t4Point.numberOfReturns = p.getNumberOfReturns();
            if (!filter.accept(t4Point)) continue;
            double x = t4Point.x;
            double y = t4Point.y;
            double z = t4Point.z;
            if (this.coordinateTransform != null) {
                boolean status = this.coordinateTransform.forward(x, y, scratch);
                if (status) {
                    x = scratch.x;
                    y = scratch.y;
                } else {
                    throw new IOException("Unable to transform coordinates (" + x + "," + y + ") in record " + iRecord);
                }
            }
            VertexWithClassification v = new VertexWithClassification(x, y, z, iRecord, t4Point.classification);
            list.add(v);
        }
        return list;
    }
}

