/*
 * Decompiled with CFR 0.152.
 */
package com.github.mreutegg.laszip4j.laslib;

import com.github.mreutegg.laszip4j.clib.Cstdio;
import com.github.mreutegg.laszip4j.laslib.LAScriterion;
import com.github.mreutegg.laszip4j.laszip.LASpoint;
import com.github.mreutegg.laszip4j.laszip.MyDefs;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;

class LAScriterionThinWithTime
extends LAScriterion {
    double time_spacing;
    SortedMap<Long, List<Double>> times = new TreeMap<Long, List<Double>>();

    @Override
    public String name() {
        return "thin_with_time";
    }

    @Override
    public int get_command(StringBuilder string) {
        return Cstdio.sprintf(string, "-%s %g ", this.name(), this.time_spacing > 0.0 ? this.time_spacing : -this.time_spacing);
    }

    @Override
    public boolean filter(LASpoint point) {
        long pos_t = MyDefs.I64_FLOOR(point.get_gps_time() / this.time_spacing);
        ArrayList<Double> map_element = (ArrayList<Double>)this.times.get(pos_t);
        if (map_element == null) {
            map_element = new ArrayList<Double>();
            map_element.add(point.get_gps_time());
            this.times.put(pos_t, map_element);
            return Boolean.FALSE;
        }
        if (((Double)map_element.get(0)).doubleValue() == point.get_gps_time()) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public void reset() {
        this.times.clear();
    }

    LAScriterionThinWithTime(double time_spacing) {
        this.time_spacing = time_spacing;
    }
}

