/*
 * Decompiled with CFR 0.152.
 */
package com.github.mreutegg.laszip4j.laszip;

import com.github.mreutegg.laszip4j.laszip.ArithmeticBitModel;
import com.github.mreutegg.laszip4j.laszip.ArithmeticModel;
import com.github.mreutegg.laszip4j.laszip.ByteStreamOut;

public class ArithmeticEncoder {
    private static final byte ZERO = 0;
    private ByteStreamOut outstream;
    private byte[] outbuffer = new byte[1024];
    private int endbuffer = this.outbuffer.length;
    private int outbyte;
    private int endbyte;
    private int u_base;
    private int u_value;
    private int u_length;

    public boolean init(ByteStreamOut outstream) {
        if (outstream == null) {
            return false;
        }
        this.outstream = outstream;
        this.u_base = 0;
        this.u_length = -1;
        this.outbyte = 0;
        this.endbyte = this.endbuffer;
        return true;
    }

    public void done() {
        int u_init_base = this.u_base;
        boolean another_byte = true;
        if (Integer.compareUnsigned(this.u_length, 0x2000000) > 0) {
            this.u_base += 0x1000000;
            this.u_length = 0x800000;
        } else {
            this.u_base += 0x800000;
            this.u_length = 32768;
            another_byte = false;
        }
        if (Integer.compareUnsigned(u_init_base, this.u_base) > 0) {
            this.propagate_carry();
        }
        this.renorm_enc_interval();
        int buffer_size = this.outbyte;
        if (buffer_size > 0) {
            this.outstream.putBytes(this.outbuffer, buffer_size);
        }
        this.outstream.putByte((byte)0);
        this.outstream.putByte((byte)0);
        if (another_byte) {
            this.outstream.putByte((byte)0);
        }
        this.outstream = null;
    }

    public ArithmeticBitModel createBitModel() {
        return new ArithmeticBitModel();
    }

    void initBitModel(ArithmeticBitModel m) {
        m.init();
    }

    ArithmeticModel createSymbolModel(int u_symbols) {
        return new ArithmeticModel(u_symbols, true);
    }

    void initSymbolModel(ArithmeticModel m) {
        this.initSymbolModel(m, null);
    }

    void initSymbolModel(ArithmeticModel m, int[] u_table) {
        m.init(u_table);
    }

    void encodeBit(ArithmeticBitModel m, int sym) {
        assert (m != null && sym <= 1);
        int u_x = m.u_bit_0_prob * (this.u_length >>> 13);
        if (sym == 0) {
            this.u_length = u_x;
            ++m.u_bit_0_count;
        } else {
            int u_init_base = this.u_base;
            this.u_base += u_x;
            this.u_length -= u_x;
            if (Integer.compareUnsigned(u_init_base, this.u_base) > 0) {
                this.propagate_carry();
            }
        }
        if (Integer.compareUnsigned(this.u_length, 0x1000000) < 0) {
            this.renorm_enc_interval();
        }
        if (--m.u_bits_until_update == 0) {
            m.update();
        }
    }

    void encodeSymbol(ArithmeticModel m, int u_sym) {
        assert (m != null && Integer.compareUnsigned(u_sym, m.u_last_symbol) <= 0);
        int u_init_base = this.u_base;
        if (u_sym == m.u_last_symbol) {
            int u_x = m.u_distribution[u_sym] * (this.u_length >>> 15);
            this.u_base += u_x;
            this.u_length -= u_x;
        } else {
            int u_x = m.u_distribution[u_sym] * (this.u_length >>>= 15);
            this.u_base += u_x;
            this.u_length = m.u_distribution[u_sym + 1] * this.u_length - u_x;
        }
        if (Integer.compareUnsigned(u_init_base, this.u_base) > 0) {
            this.propagate_carry();
        }
        if (Integer.compareUnsigned(this.u_length, 0x1000000) < 0) {
            this.renorm_enc_interval();
        }
        int n = u_sym;
        m.u_symbol_count[n] = m.u_symbol_count[n] + 1;
        if (--m.u_symbols_until_update == 0) {
            m.update();
        }
    }

    void writeBit(int sym) {
        assert (sym < 2);
        int u_init_base = this.u_base;
        this.u_base += sym * (this.u_length >>>= 1);
        if (Integer.compareUnsigned(u_init_base, this.u_base) > 0) {
            this.propagate_carry();
        }
        if (Integer.compareUnsigned(this.u_length, 0x1000000) < 0) {
            this.renorm_enc_interval();
        }
    }

    void writeBits(int bits, int u_sym) {
        assert (bits != 0 && bits <= 32 && u_sym < 1 << bits);
        if (bits > 19) {
            this.writeShort((short)(u_sym & 0xFFFF));
            u_sym >>>= 16;
            bits -= 16;
        }
        int u_init_base = this.u_base;
        this.u_base += u_sym * (this.u_length >>>= bits);
        if (Integer.compareUnsigned(u_init_base, this.u_base) > 0) {
            this.propagate_carry();
        }
        if (Integer.compareUnsigned(this.u_length, 0x1000000) < 0) {
            this.renorm_enc_interval();
        }
    }

    void writeByte(byte sym) {
        int u_init_base = this.u_base;
        this.u_base += sym * (this.u_length >>>= 8);
        if (Integer.compareUnsigned(u_init_base, this.u_base) > 0) {
            this.propagate_carry();
        }
        if (Integer.compareUnsigned(this.u_length, 0x1000000) < 0) {
            this.renorm_enc_interval();
        }
    }

    void writeShort(short u_sym) {
        int u_init_base = this.u_base;
        this.u_base += u_sym * (this.u_length >>>= 16);
        if (Integer.compareUnsigned(u_init_base, this.u_base) > 0) {
            this.propagate_carry();
        }
        if (Integer.compareUnsigned(this.u_length, 0x1000000) < 0) {
            this.renorm_enc_interval();
        }
    }

    void writeInt(int u_sym) {
        this.writeShort((short)(u_sym & 0xFFFF));
        this.writeShort((short)(u_sym >>> 16));
    }

    void writeFloat(float sym) {
        this.writeInt(Float.floatToIntBits(sym));
    }

    void writeInt64(long u_sym) {
        this.writeInt((int)(u_sym & 0xFFFFFFFFFFFFFFFFL));
        this.writeInt((int)(u_sym >>> 32));
    }

    void writeDouble(double sym) {
        this.writeInt64(Double.doubleToLongBits(sym));
    }

    private void propagate_carry() {
        int p = this.outbyte == 0 ? this.endbuffer - 1 : this.outbyte - 1;
        while (this.outbuffer[p] == 255) {
            this.outbuffer[p] = 0;
            p = p == 0 ? this.endbuffer - 1 : --p;
            assert (0 <= p);
            assert (p < this.endbuffer);
            assert (this.outbyte < this.endbuffer);
        }
        int n = p;
        this.outbuffer[n] = (byte)(this.outbuffer[n] + 1);
    }

    private void renorm_enc_interval() {
        do {
            assert (0 <= this.outbyte);
            assert (this.outbyte < this.endbuffer);
            assert (this.outbyte < this.endbyte);
            this.outbuffer[this.outbyte++] = (byte)(this.u_base >>> 24);
            if (this.outbyte == this.endbyte) {
                this.manage_outbuffer();
            }
            this.u_base <<= 8;
        } while (Integer.compareUnsigned(this.u_length <<= 8, 0x1000000) < 0);
    }

    private void manage_outbuffer() {
        if (this.outbyte == this.endbuffer) {
            this.outbyte = 0;
        }
        this.outstream.putBytes(this.outbuffer, 1024);
        this.endbyte = this.outbyte + 1024;
        assert (this.endbyte > this.outbyte);
        assert (this.outbyte < this.endbuffer);
    }
}

