/*
 * Decompiled with CFR 0.152.
 */
package com.github.mreutegg.laszip4j.laszip;

import com.github.mreutegg.laszip4j.laszip.ByteStreamOutDataOutput;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ByteStreamOutOstream
extends ByteStreamOutDataOutput {
    private final CountingOutputStream cOut;

    protected ByteStreamOutOstream(OutputStream out) {
        super(null);
        this.cOut = new CountingOutputStream(out);
        this.dataOut = new DataOutputStream(this.cOut);
    }

    @Override
    public boolean isSeekable() {
        return false;
    }

    @Override
    public long tell() {
        return this.cOut.getCount();
    }

    @Override
    public boolean seek(long position) {
        return false;
    }

    @Override
    public boolean seekEnd() {
        return false;
    }

    @Override
    public void close() throws IOException {
        this.cOut.close();
    }

    private static class CountingOutputStream
    extends FilterOutputStream {
        private long count = 0L;

        CountingOutputStream(OutputStream out) {
            super(out);
        }

        long getCount() {
            return this.count;
        }

        @Override
        public void write(int b) throws IOException {
            super.write(b);
            ++this.count;
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            super.write(b, off, len);
            this.count += (long)len;
        }
    }
}

