/*
 * Decompiled with CFR 0.152.
 */
package com.github.mreutegg.laszip4j.laszip;

public class LASitem {
    public Type type;
    public char size;
    public char version;

    boolean is_type(Type t) {
        if (t != this.type) {
            return false;
        }
        switch (t) {
            case POINT10: {
                if (this.size == '\u0014') break;
                return false;
            }
            case POINT14: {
                if (this.size == '\u001e') break;
                return false;
            }
            case GPSTIME11: {
                if (this.size == '\b') break;
                return false;
            }
            case RGB12: {
                if (this.size == '\u0006') break;
                return false;
            }
            case WAVEPACKET13: {
                if (this.size == '\u001d') break;
                return false;
            }
            case BYTE: {
                if (this.size >= '\u0001') break;
                return false;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    String get_name() {
        switch (this.type) {
            case POINT10: {
                return "POINT10";
            }
            case POINT14: {
                return "POINT14";
            }
            case GPSTIME11: {
                return "GPSTIME11";
            }
            case RGB12: {
                return "RGB12";
            }
            case WAVEPACKET13: {
                return "WAVEPACKET13";
            }
            case BYTE: {
                return "BYTE";
            }
        }
        return null;
    }

    public static enum Type {
        BYTE,
        SHORT,
        INT,
        LONG,
        FLOAT,
        DOUBLE,
        POINT10,
        GPSTIME11,
        RGB12,
        WAVEPACKET13,
        POINT14,
        RGBNIR14;

        private static final Type[] TYPES;

        public static Type fromOrdinal(int i) {
            return TYPES[i];
        }

        static {
            TYPES = Type.values();
        }
    }
}

