/*
 * Decompiled with CFR 0.152.
 */
package com.github.mreutegg.laszip4j.laszip;

import com.github.mreutegg.laszip4j.clib.Cstring;
import com.github.mreutegg.laszip4j.laszip.ArithmeticDecoder;
import com.github.mreutegg.laszip4j.laszip.ArithmeticModel;
import com.github.mreutegg.laszip4j.laszip.IntegerCompressor;
import com.github.mreutegg.laszip4j.laszip.LASreadItemCompressed;
import java.nio.ByteBuffer;

public class LASreadItemCompressed_RGB12_v1
extends LASreadItemCompressed {
    private ArithmeticDecoder dec;
    private ByteBuffer last_item;
    private ArithmeticModel m_byte_used;
    private IntegerCompressor ic_rgb;

    public LASreadItemCompressed_RGB12_v1(ArithmeticDecoder dec) {
        assert (dec != null);
        this.dec = dec;
        this.m_byte_used = dec.createSymbolModel(64);
        this.ic_rgb = new IntegerCompressor(dec, 8, 6);
        this.last_item = ByteBuffer.allocate(6);
    }

    @Override
    public boolean init(byte[] item) {
        this.dec.initSymbolModel(this.m_byte_used);
        this.ic_rgb.initDecompressor();
        Cstring.memcpy(this.last_item.array(), item, 6);
        return Boolean.TRUE;
    }

    @Override
    public void read(byte[] itemBytes) {
        ByteBuffer item = ByteBuffer.wrap(itemBytes);
        int sym = this.dec.decodeSymbol(this.m_byte_used);
        if ((sym & 1) != 0) {
            item.putChar(0, (char)this.ic_rgb.decompress(this.last_item.getChar(0) & 0xFF, 0));
        } else {
            item.putChar(0, (char)(this.last_item.getChar(0) & 0xFF));
        }
        if ((sym & 2) != 0) {
            item.putChar(0, (char)(item.getChar(0) | (char)this.ic_rgb.decompress(this.last_item.getChar(0) >> 8, 1) << 8));
        } else {
            item.putChar(0, (char)(item.getChar(0) | this.last_item.getChar(0) & 0xFF00));
        }
        if ((sym & 4) != 0) {
            item.putChar(2, (char)this.ic_rgb.decompress(this.last_item.getChar(2) & 0xFF, 2));
        } else {
            item.putChar(2, (char)(this.last_item.getChar(2) & 0xFF));
        }
        if ((sym & 8) != 0) {
            item.putChar(2, (char)(item.getChar(2) | (char)this.ic_rgb.decompress(this.last_item.getChar(2) >> 8, 3) << 8));
        } else {
            item.putChar(2, (char)(item.getChar(2) | this.last_item.getChar(2) & 0xFF00));
        }
        if ((sym & 0x10) != 0) {
            item.putChar(4, (char)this.ic_rgb.decompress(this.last_item.getChar(4) & 0xFF, 4));
        } else {
            item.putChar(4, (char)(this.last_item.getChar(4) & 0xFF));
        }
        if ((sym & 0x20) != 0) {
            item.putChar(4, (char)(item.getChar(4) | (char)this.ic_rgb.decompress(this.last_item.getChar(4) >> 8, 5) << 8));
        } else {
            item.putChar(4, (char)(item.getChar(4) | this.last_item.getChar(4) & 0xFF00));
        }
        Cstring.memcpy(this.last_item.array(), item.array(), 6);
    }
}

