/*
 * Decompiled with CFR 0.152.
 */
package com.github.mreutegg.laszip4j.laszip;

import com.github.mreutegg.laszip4j.laszip.U32I32F32;
import java.nio.ByteBuffer;

public class LASwavepacket13 {
    private U32I32F32 return_point = new U32I32F32();
    private U32I32F32 x = new U32I32F32();
    private U32I32F32 y = new U32I32F32();
    private U32I32F32 z = new U32I32F32();
    private final ByteBuffer data = ByteBuffer.allocate(28);

    public LASwavepacket13() {
        this.return_point = U32I32F32.wrap(this.slice(12, 4));
        this.x = U32I32F32.wrap(this.slice(16, 4));
        this.y = U32I32F32.wrap(this.slice(16, 4));
        this.z = U32I32F32.wrap(this.slice(16, 4));
    }

    public ByteBuffer getData() {
        return this.data;
    }

    private ByteBuffer slice(int offset, int size) {
        return ((ByteBuffer)this.data.duplicate().position(offset).limit(offset + size)).slice();
    }

    static LASwavepacket13 unpack(byte[] itemArray) {
        LASwavepacket13 r = new LASwavepacket13();
        ByteBuffer item = ByteBuffer.wrap(itemArray);
        r.setOffset(LASwavepacket13.makeU64(item));
        r.setPacket_size(LASwavepacket13.makeU32(item));
        r.getReturn_point().setU32(LASwavepacket13.makeU32(item));
        r.getX().setU32(LASwavepacket13.makeU32(item));
        r.getY().setU32(LASwavepacket13.makeU32(item));
        r.getZ().setU32(LASwavepacket13.makeU32(item));
        return r;
    }

    void pack(ByteBuffer item) {
        LASwavepacket13.packU32((int)(this.getOffset() & 0xFFFFFFFFFFFFFFFFL), item);
        LASwavepacket13.packU32((int)(this.getOffset() >>> 32), item);
        LASwavepacket13.packU32(this.getPacket_size(), item);
        LASwavepacket13.packU32(this.getReturn_point().getU32(), item);
        LASwavepacket13.packU32(this.getX().getU32(), item);
        LASwavepacket13.packU32(this.getY().getU32(), item);
        LASwavepacket13.packU32(this.getZ().getU32(), item);
    }

    private static long makeU64(ByteBuffer item) {
        long dw0 = LASwavepacket13.makeU32(item);
        long dw1 = LASwavepacket13.makeU32(item);
        return dw0 | dw1 << 32;
    }

    private static int makeU32(ByteBuffer item) {
        byte b0 = item.get();
        byte b1 = item.get();
        byte b2 = item.get();
        byte b3 = item.get();
        return b0 | b1 << 8 | b2 << 16 | b3 << 24;
    }

    private static void packU32(int v, ByteBuffer item) {
        item.put((byte)(v & 0xFF));
        item.put((byte)(v >>> 8 & 0xFF));
        item.put((byte)(v >>> 16 & 0xFF));
        item.put((byte)(v >>> 24 & 0xFF));
    }

    public long getOffset() {
        return this.data.getLong(0);
    }

    public void setOffset(long offset) {
        this.data.putLong(0, offset);
    }

    public int getPacket_size() {
        return this.data.getInt(8);
    }

    public void setPacket_size(int packet_size) {
        this.data.putInt(8, packet_size);
    }

    public U32I32F32 getReturn_point() {
        return this.return_point;
    }

    public U32I32F32 getX() {
        return this.x;
    }

    public U32I32F32 getY() {
        return this.y;
    }

    public U32I32F32 getZ() {
        return this.z;
    }
}

