/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.common;

import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import org.tinfour.common.IConstraint;
import org.tinfour.common.IIncrementalTin;
import org.tinfour.common.IQuadEdge;
import org.tinfour.common.Vertex;
import org.tinfour.vividsolutions.jts.math.DD;

public class SimpleTriangle {
    private final IIncrementalTin tin;
    private final IQuadEdge edgeA;
    private final IQuadEdge edgeB;
    private final IQuadEdge edgeC;

    public SimpleTriangle(IIncrementalTin tin, IQuadEdge a, IQuadEdge b, IQuadEdge c) {
        this.tin = tin;
        this.edgeA = a;
        this.edgeB = b;
        this.edgeC = c;
    }

    public IQuadEdge getEdgeA() {
        return this.edgeA;
    }

    public IQuadEdge getEdgeB() {
        return this.edgeB;
    }

    public IQuadEdge getEdgeC() {
        return this.edgeC;
    }

    public Vertex getVertexA() {
        return this.edgeC.getA();
    }

    public Vertex getVertexB() {
        return this.edgeA.getA();
    }

    public Vertex getVertexC() {
        return this.edgeB.getA();
    }

    public double getArea() {
        Vertex a = this.edgeA.getA();
        Vertex b = this.edgeB.getA();
        Vertex c = this.edgeC.getA();
        double ax = a.getX();
        double ay = a.getY();
        double bx = b.getX();
        double by = b.getY();
        double cx = c.getX();
        double cy = c.getY();
        DD q11 = new DD(cx).selfSubtract(ax);
        DD q12 = new DD(ay).selfSubtract(by);
        DD q21 = new DD(cy).selfSubtract(ay);
        DD q22 = new DD(bx).selfSubtract(ax);
        q11.selfMultiply(q12);
        q21.selfMultiply(q22);
        q11.selfAdd(q21);
        return q11.doubleValue() / 2.0;
    }

    public IConstraint getContainingRegion() {
        return this.tin.getRegionConstraint(this.edgeA);
    }

    public Path2D getPath2D(AffineTransform transform) {
        AffineTransform af = transform;
        if (transform == null) {
            af = new AffineTransform();
        }
        double[] c = new double[12];
        Vertex A = this.edgeA.getA();
        Vertex B = this.edgeB.getA();
        Vertex C = this.edgeC.getA();
        c[0] = A.getX();
        c[1] = A.getY();
        c[2] = B.getX();
        c[3] = B.getY();
        c[4] = C.getX();
        c[5] = C.getY();
        af.transform(c, 0, c, 6, 3);
        Path2D.Double path = new Path2D.Double();
        ((Path2D)path).moveTo(c[6], c[7]);
        ((Path2D)path).lineTo(c[8], c[9]);
        ((Path2D)path).lineTo(c[10], c[11]);
        path.closePath();
        return path;
    }
}

