/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.demo.examples;

import java.awt.Color;
import java.awt.Font;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.util.ArrayList;
import java.util.List;
import org.tinfour.common.IConstraint;
import org.tinfour.common.IIncrementalTin;
import org.tinfour.common.PolygonConstraint;
import org.tinfour.common.Vertex;
import org.tinfour.demo.examples.LogoPanel;
import org.tinfour.demo.utils.TestOptions;

public final class LogoCDT {
    private LogoCDT() {
    }

    public static void main(String[] args) {
        TestOptions options = new TestOptions();
        boolean[] optionsMatched = options.argumentScan(args);
        String text = "CDT";
        String test = options.scanStringOption(args, "-text", optionsMatched);
        if (test != null) {
            text = test;
        }
        Class<?> tinClass = options.getTinClass();
        String title = "Constrained Delaunay Triangulation -- " + tinClass.getSimpleName();
        List<IConstraint> outlineList = LogoCDT.getOutlineConstraints(text);
        IIncrementalTin tin = options.getNewInstanceOfTestTin();
        tin.addConstraints(outlineList, true);
        LogoPanel.plot(tin, title);
    }

    private static List<IConstraint> getOutlineConstraints(String text) {
        ArrayList<IConstraint> pList = new ArrayList<IConstraint>();
        FontRenderContext frc = new FontRenderContext(null, true, true);
        Font font = new Font("Arial Black", 0, 72);
        double deltaHue = text.length() > 1 ? 0.75 / (double)(text.length() - 1) : 0.0;
        TextLayout layout = new TextLayout(".", font, frc);
        double spaceAdvance = layout.getVisibleAdvance();
        int xOffset = 0;
        for (int iText = 0; iText < text.length(); ++iText) {
            int iclx = Color.HSBtoRGB((float)((double)iText * deltaHue), 1.0f, 1.0f);
            Color clx = new Color(iclx | 0xFF000000, true);
            AffineTransform flipY = new AffineTransform(1.0f, 0.0f, 0.0f, -1.0f, xOffset, 0.0f);
            String subtext = text.substring(iText, iText + 1);
            if (Character.isWhitespace(text.charAt(iText))) {
                xOffset = (int)((double)xOffset + spaceAdvance);
                continue;
            }
            layout = new TextLayout(subtext, font, frc);
            xOffset = (int)((float)xOffset + layout.getVisibleAdvance());
            Shape shape = layout.getOutline(new AffineTransform());
            PathIterator path = shape.getPathIterator(flipY, 0.25);
            double[] d = new double[6];
            int k = 0;
            ArrayList<Vertex> vList = new ArrayList<Vertex>();
            while (!path.isDone()) {
                ++k;
                int flag = path.currentSegment(d);
                switch (flag) {
                    case 0: {
                        vList.clear();
                        vList.add(new Vertex(d[0], d[1], 0.0, k));
                        break;
                    }
                    case 1: {
                        vList.add(new Vertex(d[0], d[1], 0.0, k));
                        break;
                    }
                    case 4: {
                        PolygonConstraint poly = new PolygonConstraint();
                        poly.setApplicationData(clx);
                        int n = vList.size();
                        for (int i = n - 1; i >= 0; --i) {
                            Vertex v = (Vertex)vList.get(i);
                            poly.add(v);
                        }
                        poly.complete();
                        pList.add(poly);
                        break;
                    }
                }
                path.next();
            }
        }
        return pList;
    }
}

