/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.demo.performance;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.SimpleTimeZone;
import org.tinfour.common.IIncrementalTin;
import org.tinfour.common.Vertex;
import org.tinfour.demo.utils.IDevelopmentTest;
import org.tinfour.demo.utils.TestOptions;
import org.tinfour.demo.utils.VertexLoader;

public class TwinBuildTest
implements IDevelopmentTest {
    static final String defaultClassA = "org.tinfour.standard.IncrementalTin";
    static final String defaultClassB = "org.tinfour.semivirtual.SemiVirtualIncrementalTin";
    static String[] mandatoryOptions = new String[]{"-in"};

    public static void main(String[] args) {
        TwinBuildTest test = new TwinBuildTest();
        try {
            test.runTest(System.out, args);
        }
        catch (IOException | IllegalArgumentException ex) {
            ex.printStackTrace(System.err);
        }
    }

    @Override
    public void runTest(PrintStream ps, String[] args) throws IOException {
        Class<?> classB;
        Class<?> classA;
        String nameClassB;
        TestOptions options = new TestOptions();
        boolean[] optionsMatched = options.argumentScan(args);
        options.checkForMandatoryOptions(args, mandatoryOptions);
        String nameClassA = options.scanStringOption(args, "-classA", optionsMatched);
        if (nameClassA == null) {
            nameClassA = defaultClassA;
        }
        if ((nameClassB = options.scanStringOption(args, "-classB", optionsMatched)) == null) {
            nameClassB = defaultClassB;
        }
        options.checkForUnrecognizedArgument(args, optionsMatched);
        File target = options.getInputFile();
        boolean usePreAlloc = options.isPreAllocateEnabled(false);
        int nTests = options.getTestCount(8);
        try {
            ClassLoader classLoader = this.getClass().getClassLoader();
            classA = classLoader.loadClass(nameClassA);
            classB = classLoader.loadClass(nameClassB);
        }
        catch (ClassNotFoundException cnfe) {
            throw new IllegalArgumentException("Error loading classes " + cnfe.getMessage(), cnfe);
        }
        ps.println("TwinBuildTest");
        Date date = new Date();
        Locale locale = Locale.getDefault();
        SimpleDateFormat sdFormat = new SimpleDateFormat("dd MMM yyyy HH:mm", locale);
        sdFormat.setTimeZone(new SimpleTimeZone(0, "UTC"));
        ps.println("Date:    " + sdFormat.format(date));
        ps.println("Class A: " + classA.getCanonicalName());
        ps.println("Class B: " + classB.getCanonicalName());
        ps.println("Preallocation enabled: " + usePreAlloc);
        ps.println("Sample Data: " + target.getCanonicalPath());
        long sumTotalA = 0L;
        long sumTotalB = 0L;
        long maxA = 0L;
        long maxB = 0L;
        int nTotal = 0;
        VertexLoader loader = new VertexLoader();
        List<Vertex> vertexListA = loader.readInputFile(options);
        int nVertices = vertexListA.size();
        List<Vertex> vertexListB = vertexListA;
        ps.println("\nTime for pre-sort " + loader.getTimeForPreSort());
        ps.println("Number of vertices  " + vertexListA.size());
        ps.println("\n" + sdFormat.format(date) + " UTC");
        ps.println("run,          build1,   avg_build1,          build2,    avg_build2");
        int iAvg = 3;
        for (int iTest = 0; iTest < nTests; ++iTest) {
            IIncrementalTin tinB;
            IIncrementalTin tinA;
            try {
                tinA = (IIncrementalTin)classA.newInstance();
            }
            catch (IllegalAccessException | InstantiationException ex) {
                throw new IllegalArgumentException("Error instantiating classes " + ex.getMessage(), ex);
            }
            if (usePreAlloc) {
                tinA.preAllocateEdges(nVertices);
            }
            long time0 = System.nanoTime();
            tinA.add(vertexListA, null);
            long time1 = System.nanoTime();
            long deltaBuildA = time1 - time0;
            tinA.dispose();
            tinA = null;
            this.getUsedMemory();
            try {
                tinB = (IIncrementalTin)classB.newInstance();
            }
            catch (IllegalAccessException | InstantiationException ex) {
                throw new IllegalArgumentException("Error instantiating classes " + ex.getMessage(), ex);
            }
            if (usePreAlloc) {
                tinB.preAllocateEdges(nVertices);
            }
            time0 = System.nanoTime();
            tinB.add(vertexListB, null);
            time1 = System.nanoTime();
            long deltaBuildB = time1 - time0;
            tinB.dispose();
            tinB = null;
            this.getUsedMemory();
            double avgTotalA = 0.0;
            double avgTotalB = 0.0;
            if (iTest >= iAvg) {
                nTotal = iTest - iAvg + 1;
                avgTotalA = (double)(sumTotalA += deltaBuildA) / (double)nTotal;
                avgTotalB = (double)(sumTotalB += deltaBuildB) / (double)nTotal;
                if (deltaBuildA > maxA) {
                    maxA = deltaBuildA;
                }
                if (deltaBuildB > maxB) {
                    maxB = deltaBuildB;
                }
            }
            ps.format("%3d,    %12.3f, %12.3f,     %12.3f, %12.3f%n", iTest, (double)deltaBuildA / 1000000.0, avgTotalA / 1000000.0, (double)deltaBuildB / 1000000.0, avgTotalB / 1000000.0);
        }
        if (nTotal > 1) {
            double avgTotalA = (double)(sumTotalA -= maxA) / (double)(nTotal - 1);
            double avgTotalB = (double)(sumTotalB -= maxB) / (double)(nTotal - 1);
            ps.format("avg with max removed  %12.3f,                   %12.3f%n", avgTotalA / 1000000.0, avgTotalB / 1000000.0);
            ps.println("");
            ps.println("comparitive time method a/b: " + avgTotalA / avgTotalB);
            ps.println("comparitive time method b/a: " + avgTotalB / avgTotalA);
        }
        ps.println("Test complete");
    }

    private long getUsedMemory() {
        Runtime runtime = Runtime.getRuntime();
        runtime.gc();
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return runtime.totalMemory() - runtime.freeMemory();
    }
}

