/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.demo.viewer.backplane;

import java.util.concurrent.atomic.AtomicInteger;
import org.tinfour.common.IMonitorWithCancellation;
import org.tinfour.demo.viewer.backplane.BackplaneManager;
import org.tinfour.demo.viewer.backplane.IModelViewTask;
import org.tinfour.demo.viewer.backplane.MvComposite;
import org.tinfour.demo.viewer.backplane.RenderProduct;
import org.tinfour.demo.viewer.backplane.RenderProductType;

class MvTaskBuildRasterBlock
implements IModelViewTask {
    private final BackplaneManager backplaneManager;
    private final IMonitorWithCancellation monitor;
    private final int nBlocks;
    private final MvComposite composite;
    private final boolean hillshade;
    private final int taskIndex;
    private boolean isCancelled;
    private final int row0;
    private final int nRow;
    private final AtomicInteger blockCounter;

    MvTaskBuildRasterBlock(BackplaneManager backplaneManager, MvComposite composite, AtomicInteger blockCounter, int nBlocks, int row0, int nRow, int taskIndex, IMonitorWithCancellation monitor) {
        this.blockCounter = blockCounter;
        this.backplaneManager = backplaneManager;
        this.composite = composite;
        this.taskIndex = taskIndex;
        this.monitor = monitor;
        this.nBlocks = nBlocks;
        this.row0 = row0;
        this.nRow = nRow;
        this.hillshade = composite.getView().isHillshadeSelected();
    }

    @Override
    public void cancel() {
        this.isCancelled = true;
    }

    @Override
    public boolean isCancelled() {
        return this.isCancelled;
    }

    @Override
    public void run() {
        if (this.isCancelled) {
            return;
        }
        this.composite.buildGrid(this.row0, this.nRow, this.hillshade, this);
        if (this.isCancelled) {
            return;
        }
        int test = this.blockCounter.decrementAndGet();
        int percentDone = (int)(100.0 * (double)(this.nBlocks - test) / (double)this.nBlocks + 0.5);
        this.monitor.reportProgress(percentDone);
        if (test == 0) {
            this.composite.stopGridBuildTimer();
            this.backplaneManager.statusPanel.postMessage(this.taskIndex, "Rendering raster image");
            this.composite.transferGridToRasterImage();
            RenderProduct product = new RenderProduct(RenderProductType.Raster, this.composite, this.composite.rasterImage);
            this.monitor.reportDone();
            this.backplaneManager.postImageUpdate(this, product);
        }
    }

    @Override
    public int getTaskIndex() {
        return this.taskIndex;
    }

    @Override
    public boolean isRenderingTask() {
        return true;
    }
}

