/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.demo.viewer.backplane;

import org.tinfour.demo.viewer.backplane.BackplaneManager;
import org.tinfour.demo.viewer.backplane.IModelViewTask;
import org.tinfour.demo.viewer.backplane.MvComposite;
import org.tinfour.demo.viewer.backplane.MvTaskBuildTinAndRender;

class MvTaskQueueRender
implements IModelViewTask {
    private final BackplaneManager backplaneManager;
    private final MvComposite composite;
    private final int taskIndex;
    private boolean isCancelled;

    MvTaskQueueRender(BackplaneManager backplaneManager, MvComposite composite, int taskIndex) {
        this.composite = composite;
        this.taskIndex = taskIndex;
        this.backplaneManager = backplaneManager;
    }

    @Override
    public void cancel() {
        this.isCancelled = true;
    }

    @Override
    public boolean isCancelled() {
        return this.isCancelled;
    }

    @Override
    public void run() {
        if (this.isCancelled) {
            return;
        }
        MvTaskBuildTinAndRender renderTask = new MvTaskBuildTinAndRender(this.backplaneManager, this.composite, this.taskIndex);
        this.backplaneManager.renderPool.queueTask(renderTask);
    }

    @Override
    public int getTaskIndex() {
        return this.taskIndex;
    }

    @Override
    public boolean isRenderingTask() {
        return true;
    }
}

