/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.gis.utils;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.tinfour.common.IMonitorWithCancellation;
import org.tinfour.common.Vertex;
import org.tinfour.gis.las.GeoTiffData;
import org.tinfour.gis.las.ILasRecordFilter;
import org.tinfour.gis.las.LasFileReader;
import org.tinfour.gis.las.LasPoint;
import org.tinfour.gis.utils.VertexReaderLaz;
import org.tinfour.gis.utils.VertexWithClassification;
import org.tinfour.utils.LinearUnits;
import org.tinfour.utils.loaders.CoordinatePair;
import org.tinfour.utils.loaders.ICoordinateTransform;
import org.tinfour.utils.loaders.IVertexReader;
import org.tinfour.utils.loaders.SimpleGeographicTransform;

public class VertexReaderLas
implements IVertexReader,
Closeable {
    double xMin;
    double xMax;
    double yMin;
    double yMax;
    double zMin;
    double zMax;
    boolean isSourceInGeographicCoordinates;
    LinearUnits linearUnits = LinearUnits.UNKNOWN;
    ICoordinateTransform coordinateTransform;
    long maximumNumberOfVertices = Integer.MAX_VALUE;
    long numberOfVerticesInSource;
    final LasFileReader reader;
    ILasRecordFilter filter;

    private VertexReaderLas() {
        this.reader = null;
    }

    public VertexReaderLas(File file) throws IOException {
        int linUnits;
        long nVertices;
        this.reader = new LasFileReader(file);
        this.numberOfVerticesInSource = nVertices = this.reader.getNumberOfPointRecords();
        this.isSourceInGeographicCoordinates = this.reader.usesGeographicCoordinates();
        GeoTiffData gtd = this.reader.getGeoTiffData();
        if (gtd != null && gtd.containsKey(3076) && ((linUnits = gtd.getInteger(3076)) == 9002 || linUnits == 9003)) {
            this.linearUnits = LinearUnits.FEET;
        }
        if (this.isSourceInGeographicCoordinates) {
            double cenLat = (this.reader.getMinY() + this.reader.getMaxY()) / 2.0;
            double cenLon = (this.reader.getMinX() + this.reader.getMaxX()) / 2.0;
            this.coordinateTransform = new SimpleGeographicTransform(cenLat, cenLon, this.linearUnits);
        }
        this.filter = new AcceptAll();
    }

    public void setFilter(ILasRecordFilter filter) {
        this.filter = filter;
    }

    public void setMaximumNumberOfVertices(long maximumNumberOfVertices) {
        if (maximumNumberOfVertices < 0L) {
            throw new IllegalArgumentException("Maximum number of vertices must not be less than zero");
        }
        this.maximumNumberOfVertices = maximumNumberOfVertices;
    }

    @Override
    public List<Vertex> read(IMonitorWithCancellation monitor) throws IOException {
        long nVertices = this.numberOfVerticesInSource;
        if (this.isLazFile(this.reader.getFile())) {
            VertexReaderLaz lazReader = new VertexReaderLaz(this.reader.getScaleAndOffset(), this.coordinateTransform, this.maximumNumberOfVertices);
            List<Vertex> list = lazReader.loadVertices(this.reader.getFile(), nVertices, this.filter, monitor);
            this.postProcessList(list);
            return list;
        }
        ArrayList<Vertex> list = new ArrayList<Vertex>();
        int iProgressThreshold = Integer.MAX_VALUE;
        int pProgressThreshold = 0;
        if (monitor != null) {
            int iPercent = monitor.getReportingIntervalInPercent();
            int iTemp = (int)((double)nVertices * ((double)iPercent / 100.0) + 0.5);
            if (iTemp > 1) {
                iProgressThreshold = iTemp;
            }
            monitor.reportProgress(0);
        }
        CoordinatePair scratch = new CoordinatePair();
        LasPoint p = new LasPoint();
        for (long iRecord = 0L; iRecord < nVertices; ++iRecord) {
            if (pProgressThreshold == iProgressThreshold) {
                pProgressThreshold = 0;
                monitor.reportProgress((int)(0.1 + 100.0 * (double)(iRecord + 1L) / (double)nVertices));
                if (monitor.isCanceled()) {
                    break;
                }
            } else {
                ++pProgressThreshold;
            }
            if ((long)list.size() >= this.maximumNumberOfVertices) break;
            this.reader.readRecord(iRecord, p);
            if (p.withheld || this.filter != null && !this.filter.accept(p)) continue;
            double x = p.x;
            double y = p.y;
            double z = p.z;
            if (this.coordinateTransform != null) {
                boolean status = this.coordinateTransform.forward(x, y, scratch);
                if (!status) {
                    throw new IOException("Unable to transform coordinates (" + x + "," + y + ") in record " + iRecord);
                }
                x = scratch.x;
                y = scratch.y;
            }
            VertexWithClassification v = new VertexWithClassification(x, y, z, (int)iRecord, p.classification);
            list.add(v);
        }
        this.postProcessList(list);
        return list;
    }

    private void postProcessList(List<Vertex> list) {
        if (list.isEmpty()) {
            return;
        }
        Vertex a = list.get(0);
        this.xMin = a.getX();
        this.xMax = a.getX();
        this.yMin = a.getY();
        this.yMax = a.getY();
        this.zMin = a.getZ();
        this.zMax = a.getZ();
        for (Vertex v : list) {
            double x = v.getX();
            double y = v.getY();
            double z = v.getZ();
            if (x < this.xMin) {
                this.xMin = x;
            } else if (x > this.xMax) {
                this.xMax = x;
            }
            if (y < this.yMin) {
                this.yMin = y;
            } else if (y > this.yMax) {
                this.yMax = y;
            }
            if (z < this.zMin) {
                this.zMin = z;
                continue;
            }
            if (!(z > this.zMax)) continue;
            this.zMax = z;
        }
    }

    @Override
    public double getXMin() {
        return this.xMin;
    }

    @Override
    public double getXMax() {
        return this.xMax;
    }

    @Override
    public double getYMin() {
        return this.yMin;
    }

    @Override
    public double getYMax() {
        return this.yMax;
    }

    @Override
    public double getZMin() {
        return this.zMin;
    }

    @Override
    public double getZMax() {
        return this.zMax;
    }

    @Override
    public boolean isSourceInGeographicCoordinates() {
        return this.isSourceInGeographicCoordinates;
    }

    public LinearUnits getLinearUnits() {
        return this.linearUnits;
    }

    public void setLinearUnits(LinearUnits linearUnits) {
        this.linearUnits = linearUnits == null ? LinearUnits.UNKNOWN : linearUnits;
    }

    @Override
    public ICoordinateTransform getCoordinateTransform() {
        return this.coordinateTransform;
    }

    @Override
    public void setCoordinateTransform(ICoordinateTransform transform) {
        this.coordinateTransform = transform;
    }

    @Override
    public void close() throws IOException {
    }

    private boolean isLazFile(File file) {
        String name = file.getName();
        int n = name.length();
        return n > 4 && ".LAZ".equalsIgnoreCase(name.substring(n - 4, n));
    }

    public long getNumberOfVerticesInSource() {
        return this.numberOfVerticesInSource;
    }

    private static class AcceptAll
    implements ILasRecordFilter {
        private AcceptAll() {
        }

        @Override
        public boolean accept(LasPoint record) {
            return true;
        }
    }
}

