/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import org.tinfour.common.IIncrementalTin;
import org.tinfour.common.IQuadEdge;
import org.tinfour.common.Vertex;
import org.tinfour.utils.BarycentricCoordinates;

public class SmoothingFilterInitializer {
    private static final int PAGE_SIZE = 32768;
    int nVertex;
    int[] masterIndex;
    int[][] iPages;
    int iPagesCount;
    int iPageIndex;
    int iLostElements;
    float[][] wPages;
    int wPagesCount;
    int wPageIndex;
    int wLostElements;
    double[] result;
    private final double timeToConstructFilter;

    /*
     * WARNING - void declaration
     */
    public SmoothingFilterInitializer(IIncrementalTin tin, int nPasses) {
        void var9_15;
        void var9_13;
        void var9_11;
        long time0 = System.nanoTime();
        List<Vertex> vList = tin.getVertices();
        this.nVertex = vList.size();
        this.masterIndex = new int[this.nVertex];
        Arrays.fill(this.masterIndex, -1);
        double[] zArray = new double[this.nVertex];
        int k = 0;
        for (Vertex vertex : vList) {
            zArray[k] = vertex.getZ();
            vertex.setIndex(k++);
        }
        this.iPages = new int[128][];
        this.iPages[0] = new int[32768];
        this.iPagesCount = 1;
        this.wPages = new float[128][];
        this.wPages[0] = new float[32768];
        this.wPagesCount = 1;
        BitSet visited = new BitSet(this.nVertex + 1);
        for (IQuadEdge e : tin.edges()) {
            this.initForEdge(visited, e);
            this.initForEdge(visited, e.getDual());
        }
        boolean bl = false;
        while (var9_11 < nPasses) {
            zArray = this.processZ(zArray);
            ++var9_11;
        }
        this.result = zArray;
        boolean bl2 = false;
        while (var9_13 < this.iPages.length) {
            this.iPages[var9_13] = null;
            ++var9_13;
        }
        this.iPages = null;
        boolean bl3 = false;
        while (var9_15 < this.wPages.length) {
            this.wPages[var9_15] = null;
            ++var9_15;
        }
        this.wPages = null;
        long l = System.nanoTime();
        this.timeToConstructFilter = (double)(l - time0) / 1000000.0;
    }

    public double getTimeToConstructFilter() {
        return this.timeToConstructFilter;
    }

    public List<Vertex> getConnectedPolygon(IQuadEdge e) {
        ArrayList<Vertex> vList = new ArrayList<Vertex>();
        for (IQuadEdge s : e.pinwheel()) {
            vList.add(s.getB());
        }
        return vList;
    }

    private void initForEdge(BitSet visited, IQuadEdge edge) {
        Vertex A = edge.getA();
        if (A == null) {
            return;
        }
        int vertexIndex = A.getIndex();
        if (visited.get(vertexIndex)) {
            return;
        }
        visited.set(vertexIndex);
        if (A.isConstraintMember()) {
            return;
        }
        double x = A.getX();
        double y = A.getY();
        BarycentricCoordinates bcoord = new BarycentricCoordinates();
        List<Vertex> pList = this.getConnectedPolygon(edge);
        double[] w = bcoord.getBarycentricCoordinates(pList, x, y);
        if (w == null) {
            return;
        }
        assert (w.length == pList.size()) : "Incorrect barycentric weights result";
        int iPage = this.iPagesCount - 1;
        int[] iArray = this.iPages[iPage];
        int nTest = this.iPageIndex + w.length + 2;
        if (nTest >= 32768) {
            this.iLostElements += 32768 - this.iPageIndex;
            if (iPage == this.iPagesCount - 1) {
                this.iPages = (int[][])Arrays.copyOf(this.iPages, this.iPages.length + 128);
            }
            this.iPageIndex = 0;
            ++this.iPagesCount;
            iArray = new int[32768];
            this.iPages[++iPage] = iArray;
        }
        int wPage = this.wPagesCount - 1;
        float[] wArray = this.wPages[wPage];
        nTest = this.wPageIndex + w.length;
        if (nTest >= 32768) {
            this.wLostElements += 32768 - this.wPageIndex;
            if (wPage == this.wPagesCount - 1) {
                this.wPages = (float[][])Arrays.copyOf(this.wPages, this.wPages.length + 128);
            }
            this.wPageIndex = 0;
            ++this.wPagesCount;
            wArray = new float[32768];
            this.wPages[++wPage] = wArray;
        }
        this.masterIndex[vertexIndex] = iPage * 32768 + this.iPageIndex;
        iArray[this.iPageIndex++] = w.length;
        iArray[this.iPageIndex++] = wPage * 32768 + this.wPageIndex;
        for (int i = 0; i < w.length; ++i) {
            iArray[this.iPageIndex++] = pList.get(i).getIndex();
            wArray[this.wPageIndex++] = (float)w[i];
        }
    }

    private double[] processZ(double[] zArray) {
        double[] z = new double[zArray.length];
        for (int index = 0; index < this.nVertex; ++index) {
            int iOffset = this.masterIndex[index];
            if (iOffset == -1) {
                z[index] = zArray[index];
                continue;
            }
            int iPage = iOffset / 32768;
            iOffset -= iPage * 32768;
            int[] iArray = this.iPages[iPage];
            int wCount = iArray[iOffset++];
            int wOffset = iArray[iOffset++];
            int wPage = wOffset / 32768;
            wOffset -= wPage * 32768;
            float[] wArray = this.wPages[wPage];
            double zSum = 0.0;
            double wSum = 0.0;
            for (int i = 0; i < wCount; ++i) {
                int vIndex = iArray[iOffset++];
                double w = wArray[wOffset++];
                zSum += zArray[vIndex] * w;
                wSum += w;
            }
            z[index] = zSum / wSum;
        }
        return z;
    }
}

