/*
 * Decompiled with CFR 0.152.
 */
package com.github.mreutegg.laszip4j;

import com.github.mreutegg.laszip4j.laslib.LASheader;
import com.github.mreutegg.laszip4j.laszip.MyDefs;

public final class LASHeader {
    private final LASheader header;

    LASHeader(LASheader header) {
        this.header = header;
    }

    public String getFileSignature() {
        return MyDefs.stringFromByteArray(this.header.file_signature);
    }

    public char getFileSourceID() {
        return this.header.file_source_ID;
    }

    public char getGlobalEncoding() {
        return this.header.global_encoding;
    }

    public int getProjectID_GUIDData1() {
        return this.header.project_ID_GUID_data_1;
    }

    public char getProjectID_GUIDData2() {
        return this.header.project_ID_GUID_data_2;
    }

    public char getProjectID_GUIDData3() {
        return this.header.project_ID_GUID_data_3;
    }

    public byte[] getProjectID_GUIDData4() {
        byte[] data = new byte[this.header.project_ID_GUID_data_4.length];
        System.arraycopy(this.header.project_ID_GUID_data_4, 0, data, 0, data.length);
        return data;
    }

    public byte getVersionMajor() {
        return this.header.version_major;
    }

    public byte getVersionMinor() {
        return this.header.version_minor;
    }

    public String getSystemIdentifier() {
        return MyDefs.stringFromByteArray(this.header.system_identifier);
    }

    public String getGeneratingSoftware() {
        return MyDefs.stringFromByteArray(this.header.generating_software);
    }

    public char getFileCreationDayOfYear() {
        return this.header.file_creation_day;
    }

    public char getFileCreationYear() {
        return this.header.file_creation_year;
    }

    public char getHeaderSize() {
        return this.header.header_size;
    }

    public int getOffsetToPointData() {
        return this.header.offset_to_point_data;
    }

    public int getNumberOfVariableLengthRecords() {
        return this.header.number_of_variable_length_records;
    }

    public byte getPointDataRecordFormat() {
        return this.header.point_data_format;
    }

    public char getPointDataRecordLength() {
        return this.header.point_data_record_length;
    }

    public int getLegacyNumberOfPointRecords() {
        return this.header.number_of_point_records;
    }

    public int[] getLegacyNumberOfPointsByReturn() {
        int[] data = new int[this.header.number_of_points_by_return.length];
        System.arraycopy(this.header.number_of_points_by_return, 0, data, 0, data.length);
        return data;
    }

    public double getXScaleFactor() {
        return this.header.x_scale_factor;
    }

    public double getYScaleFactor() {
        return this.header.y_scale_factor;
    }

    public double getZScaleFactor() {
        return this.header.z_scale_factor;
    }

    public double getXOffset() {
        return this.header.x_offset;
    }

    public double getYOffset() {
        return this.header.y_offset;
    }

    public double getZOffset() {
        return this.header.z_offset;
    }

    public double getMaxX() {
        return this.header.max_x;
    }

    public double getMinX() {
        return this.header.min_x;
    }

    public double getMaxY() {
        return this.header.max_y;
    }

    public double getMinY() {
        return this.header.min_y;
    }

    public double getMaxZ() {
        return this.header.max_z;
    }

    public double getMinZ() {
        return this.header.min_z;
    }

    public long getStartOfWaveformDataPacketRecord() {
        return this.header.start_of_waveform_data_packet_record;
    }

    public long getStartOfFirstExtendedVariableLengthRecord() {
        return this.header.start_of_first_extended_variable_length_record;
    }

    public int getNumberOfExtendedVariableLengthRecords() {
        return this.header.number_of_extended_variable_length_records;
    }

    public long getNumberOfPointRecords() {
        return this.header.extended_number_of_point_records;
    }

    public long[] getNumberOfPointsByReturn() {
        long[] data = new long[this.header.extended_number_of_points_by_return.length];
        System.arraycopy(this.header.extended_number_of_points_by_return, 0, data, 0, data.length);
        return data;
    }
}

