/*
 * Decompiled with CFR 0.152.
 */
package com.github.mreutegg.laszip4j;

import com.github.mreutegg.laszip4j.laszip.LASpoint;

public final class LASPoint {
    private final LASpoint p;

    LASPoint(LASpoint p) {
        this.p = p;
    }

    public int getX() {
        return this.p.getX();
    }

    public int getY() {
        return this.p.getY();
    }

    public int getZ() {
        return this.p.getZ();
    }

    public char getIntensity() {
        return this.p.getIntensity();
    }

    public byte getReturnNumber() {
        return this.p.getReturn_number();
    }

    public byte getNumberOfReturns() {
        return this.p.getNumber_of_returns();
    }

    public byte getScanDirectionFlag() {
        return this.p.getScan_direction_flag();
    }

    public byte getEdgeOfFlightLine() {
        return this.p.getEdge_of_flight_line();
    }

    public byte getClassification() {
        return this.p.getClassification();
    }

    public boolean isSynthetic() {
        return this.p.getSynthetic_flag() == 1;
    }

    public boolean isKeyPoint() {
        return this.p.getSynthetic_flag() == 1;
    }

    public boolean isWithheld() {
        return this.p.getWithheld_flag() == 1;
    }

    public byte getScanAngleRank() {
        return this.p.getScan_angle_rank();
    }

    public byte getUserData() {
        return this.p.getUser_data();
    }

    public char getPointSourceID() {
        return this.p.getPoint_source_ID();
    }

    public double getGPSTime() {
        return this.p.getGps_time();
    }

    public char getRed() {
        return this.p.get_R();
    }

    public char getGreen() {
        return this.p.get_G();
    }

    public char getBlue() {
        return this.p.get_B();
    }

    public char getNIR() {
        return this.p.get_I();
    }

    public boolean hasWavePacket() {
        return this.p.have_wavepacket;
    }

    public byte getWavePacketDescriptorIndex() {
        this.ensureWavePacket();
        return this.p.wavepacket.getIndex();
    }

    public long getByteOffsetToWaveformData() {
        this.ensureWavePacket();
        return this.p.wavepacket.getOffset();
    }

    public int getWaveformPacketSizeInBytes() {
        this.ensureWavePacket();
        return this.p.wavepacket.getSize();
    }

    public float getReturnPointWaveformLocation() {
        return this.p.wavepacket.getLocation();
    }

    public float getXt() {
        return this.p.wavepacket.getXt();
    }

    public float getYt() {
        return this.p.wavepacket.getYt();
    }

    public float getZt() {
        return this.p.wavepacket.getZt();
    }

    private void ensureWavePacket() {
        if (!this.hasWavePacket()) {
            throw new UnsupportedOperationException();
        }
    }
}

