/*
 * Decompiled with CFR 0.152.
 */
package com.github.mreutegg.laszip4j.laslib;

import com.github.mreutegg.laszip4j.clib.Cstdio;
import com.github.mreutegg.laszip4j.laslib.LAScriterion;
import com.github.mreutegg.laszip4j.laszip.LASpoint;

class LAScriterionDropGpsTimeBetween
extends LAScriterion {
    double below_gpstime;
    double above_gpstime;

    @Override
    public String name() {
        return "drop_gps_time_between";
    }

    @Override
    public int get_command(StringBuilder string) {
        return Cstdio.sprintf(string, "-%s %.6f %.6f ", this.name(), this.below_gpstime, this.above_gpstime);
    }

    @Override
    public boolean filter(LASpoint point) {
        return point.have_gps_time && this.below_gpstime <= point.getGps_time() && point.getGps_time() <= this.above_gpstime;
    }

    LAScriterionDropGpsTimeBetween(double below_gpstime, double above_gpstime) {
        this.below_gpstime = below_gpstime;
        this.above_gpstime = above_gpstime;
    }
}

