/*
 * Decompiled with CFR 0.152.
 */
package com.github.mreutegg.laszip4j.laslib;

import com.github.mreutegg.laszip4j.clib.Cstdio;
import com.github.mreutegg.laszip4j.laslib.LAScriterion;
import com.github.mreutegg.laszip4j.laszip.LASpoint;

class LAScriterionDropScanAngleBetween
extends LAScriterion {
    int below_scan;
    int above_scan;

    @Override
    public String name() {
        return "drop_scan_angle_between";
    }

    @Override
    public int get_command(StringBuilder string) {
        return Cstdio.sprintf(string, "-%s %d %d ", this.name(), this.below_scan, this.above_scan);
    }

    @Override
    public boolean filter(LASpoint point) {
        return this.below_scan <= point.getScan_angle_rank() && point.getScan_angle_rank() <= this.above_scan;
    }

    LAScriterionDropScanAngleBetween(int below_scan, int above_scan) {
        if (above_scan < below_scan) {
            this.below_scan = above_scan;
            this.above_scan = below_scan;
        } else {
            this.below_scan = below_scan;
            this.above_scan = above_scan;
        }
    }
}

