/*
 * Decompiled with CFR 0.152.
 */
package com.github.mreutegg.laszip4j.laslib;

import com.github.mreutegg.laszip4j.clib.Cstdio;
import com.github.mreutegg.laszip4j.laslib.LAScriterion;
import com.github.mreutegg.laszip4j.laszip.LASpoint;

class LAScriterionDropz
extends LAScriterion {
    public double below_z;
    public double above_z;

    @Override
    public String name() {
        return "drop_z";
    }

    @Override
    public int get_command(StringBuilder string) {
        return Cstdio.sprintf(string, "-%s %g %g ", this.name(), this.below_z, this.above_z);
    }

    @Override
    public boolean filter(LASpoint point) {
        double z = point.get_z();
        return this.below_z <= z && z < this.above_z;
    }

    public LAScriterionDropz(double below_z, double above_z) {
        this.below_z = below_z;
        this.above_z = above_z;
    }
}

