/*
 * Decompiled with CFR 0.152.
 */
package com.github.mreutegg.laszip4j.laszip;

import com.github.mreutegg.laszip4j.laszip.ByteStreamIn;
import java.io.DataInput;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public abstract class ByteStreamInDataInput
extends ByteStreamIn {
    private final ByteBuffer buffer;
    protected DataInput dataIn;

    public ByteStreamInDataInput(DataInput in) {
        this.dataIn = in;
        this.buffer = ByteBuffer.allocate(8);
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
    }

    @Override
    public byte getByte() {
        try {
            return this.dataIn.readByte();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void getBytes(byte[] bytes, int u_num_bytes) {
        try {
            this.dataIn.readFully(bytes, 0, u_num_bytes);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public char get16bitsLE() {
        try {
            this.dataIn.readFully(this.buffer.array(), 0, 2);
            return this.bufferLE().getChar();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public int get32bitsLE() {
        try {
            this.dataIn.readFully(this.buffer.array(), 0, 4);
            return this.bufferLE().getInt();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public long get64bitsLE() {
        try {
            this.dataIn.readFully(this.buffer.array(), 0, 8);
            return this.bufferLE().getLong();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public char get16bitsBE() {
        try {
            return this.dataIn.readChar();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public int get32bitsBE() {
        try {
            return this.dataIn.readInt();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public long get64bitsBE() {
        try {
            return this.dataIn.readLong();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private ByteBuffer bufferLE() {
        this.buffer.rewind();
        return this.buffer;
    }
}

