/*
 * Decompiled with CFR 0.152.
 */
package com.github.mreutegg.laszip4j.laszip;

import com.github.mreutegg.laszip4j.laszip.ByteStreamOut;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

abstract class ByteStreamOutDataOutput
extends ByteStreamOut {
    private final ByteBuffer buffer;
    protected DataOutput dataOut;

    ByteStreamOutDataOutput(DataOutput out) {
        this.dataOut = out;
        this.buffer = ByteBuffer.allocate(8);
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
    }

    @Override
    public boolean putByte(byte b) {
        try {
            this.dataOut.writeByte(b);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public boolean putBytes(byte[] bytes, int u_num_bytes) {
        try {
            this.dataOut.write(bytes, 0, u_num_bytes);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public boolean put16bitsLE(char bytes) {
        this.bufferLE().putChar(bytes);
        return this.putBytes(this.buffer.array(), 2);
    }

    @Override
    boolean put32bitsLE(int bytes) {
        this.bufferLE().putInt(bytes);
        return this.putBytes(this.buffer.array(), 4);
    }

    @Override
    public boolean put64bitsLE(long bytes) {
        this.bufferLE().putLong(bytes);
        return this.putBytes(this.buffer.array(), 8);
    }

    @Override
    boolean put16bitsBE(char bytes) {
        try {
            this.dataOut.writeShort(bytes);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    boolean put32bitsBE(int bytes) {
        try {
            this.dataOut.writeInt(bytes);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    boolean put64bitsBE(long bytes) {
        try {
            this.dataOut.writeLong(bytes);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    private ByteBuffer bufferLE() {
        this.buffer.rewind();
        return this.buffer;
    }
}

