/*
 * Decompiled with CFR 0.152.
 */
package com.github.mreutegg.laszip4j.laszip;

import com.github.mreutegg.laszip4j.laszip.ArithmeticBitModel;
import com.github.mreutegg.laszip4j.laszip.ArithmeticDecoder;
import com.github.mreutegg.laszip4j.laszip.ArithmeticEncoder;
import com.github.mreutegg.laszip4j.laszip.ArithmeticModel;

public class IntegerCompressor {
    private int u_k;
    private int u_contexts;
    private int u_bits_high;
    private int u_bits;
    private int u_range;
    private int u_corr_bits;
    private int u_corr_range;
    private int corr_min;
    private int corr_max;
    private ArithmeticEncoder enc;
    private ArithmeticDecoder dec;
    private ArithmeticModel[] mBits;
    private ArithmeticBitModel mCorrector0;
    private ArithmeticModel[] mCorrector;
    private int[][] corr_histogram;

    public IntegerCompressor(ArithmeticEncoder enc, int u_bits) {
        this(enc, u_bits, 1, 8, 0);
    }

    IntegerCompressor(ArithmeticEncoder enc, int u_bits, int u_contexts, int u_bits_high, int u_range) {
        assert (enc != null);
        this.enc = enc;
        this.dec = null;
        this.u_bits = u_bits;
        this.u_contexts = u_contexts;
        this.u_bits_high = u_bits_high;
        this.u_range = u_range;
        if (u_range != 0) {
            this.u_corr_bits = 0;
            this.u_corr_range = u_range;
            while (u_range != 0) {
                u_range >>>= 1;
                ++this.u_corr_bits;
            }
            if (this.u_corr_range == 1 << this.u_corr_bits - 1) {
                --this.u_corr_bits;
            }
            this.corr_min = -Integer.divideUnsigned(this.u_corr_range, 2);
            this.corr_max = this.corr_min + this.u_corr_range - 1;
        } else if (u_bits != 0 && Integer.compareUnsigned(u_bits, 32) < 0) {
            this.u_corr_bits = u_bits;
            this.u_corr_range = 1 << u_bits;
            this.corr_min = -Integer.divideUnsigned(this.u_corr_range, 2);
            this.corr_max = this.corr_min + this.u_corr_range - 1;
        } else {
            this.u_corr_bits = 32;
            this.u_corr_range = 0;
            this.corr_min = Integer.MIN_VALUE;
            this.corr_max = Integer.MAX_VALUE;
        }
        this.u_k = 0;
        this.mBits = null;
        this.mCorrector = null;
    }

    public IntegerCompressor(ArithmeticDecoder dec, int u_bits) {
        this(dec, u_bits, 1);
    }

    IntegerCompressor(ArithmeticDecoder dec, int u_bits, int u_contexts, int u_bits_high, int u_range) {
        assert (dec != null);
        this.enc = null;
        this.dec = dec;
        this.u_bits = u_bits;
        this.u_contexts = u_contexts;
        this.u_bits_high = u_bits_high;
        this.u_range = u_range;
        if (u_range != 0) {
            this.u_corr_bits = 0;
            this.u_corr_range = u_range;
            while (u_range != 0) {
                u_range >>>= 1;
                ++this.u_corr_bits;
            }
            if (this.u_corr_range == 1 << this.u_corr_bits - 1) {
                --this.u_corr_bits;
            }
            this.corr_min = -Integer.divideUnsigned(this.u_corr_range, 2);
            this.corr_max = this.corr_min + this.u_corr_range - 1;
        } else if (u_bits != 0 && Integer.compareUnsigned(u_bits, 32) < 0) {
            this.u_corr_bits = u_bits;
            this.u_corr_range = 1 << u_bits;
            this.corr_min = -Integer.divideUnsigned(this.u_corr_range, 2);
            this.corr_max = this.corr_min + this.u_corr_range - 1;
        } else {
            this.u_corr_bits = 32;
            this.u_corr_range = 0;
            this.corr_min = Integer.MIN_VALUE;
            this.corr_max = Integer.MAX_VALUE;
        }
        this.u_k = 0;
        this.mBits = null;
        this.mCorrector = null;
    }

    public IntegerCompressor(ArithmeticDecoder dec, int u_bits, int u_contexts) {
        this(dec, u_bits, u_contexts, 8, 0);
    }

    public int getK() {
        return this.u_k;
    }

    public void initCompressor() {
        int u_i;
        assert (this.enc != null);
        if (this.mBits == null) {
            this.mBits = new ArithmeticModel[this.u_contexts];
            for (u_i = 0; u_i < this.u_contexts; ++u_i) {
                this.mBits[u_i] = this.enc.createSymbolModel(this.u_corr_bits + 1);
            }
            this.mCorrector = new ArithmeticModel[this.u_corr_bits + 1];
            this.mCorrector0 = this.enc.createBitModel();
            for (u_i = 1; u_i <= this.u_corr_bits; ++u_i) {
                this.mCorrector[u_i] = u_i <= this.u_bits_high ? this.enc.createSymbolModel(1 << u_i) : this.enc.createSymbolModel(1 << this.u_bits_high);
            }
        }
        for (u_i = 0; u_i < this.u_contexts; ++u_i) {
            this.enc.initSymbolModel(this.mBits[u_i]);
        }
        this.enc.initBitModel(this.mCorrector0);
        for (u_i = 1; u_i <= this.u_corr_bits; ++u_i) {
            this.enc.initSymbolModel(this.mCorrector[u_i]);
        }
    }

    public void compress(int pred, int real) {
        this.compress(pred, real, 0);
    }

    void compress(int pred, int real, int u_context) {
        assert (this.enc != null);
        int corr = real - pred;
        if (corr < this.corr_min) {
            corr += this.u_corr_range;
        } else if (corr > this.corr_max) {
            corr -= this.u_corr_range;
        }
        this.writeCorrector(corr, this.mBits[u_context]);
    }

    public void initDecompressor() {
        int u_i;
        assert (this.dec != null);
        if (this.mBits == null) {
            this.mBits = new ArithmeticModel[this.u_contexts];
            for (u_i = 0; u_i < this.u_contexts; ++u_i) {
                this.mBits[u_i] = this.dec.createSymbolModel(this.u_corr_bits + 1);
            }
            this.mCorrector = new ArithmeticModel[this.u_corr_bits + 1];
            this.mCorrector0 = this.dec.createBitModel();
            for (u_i = 1; u_i <= this.u_corr_bits; ++u_i) {
                this.mCorrector[u_i] = u_i <= this.u_bits_high ? this.dec.createSymbolModel(1 << u_i) : this.dec.createSymbolModel(1 << this.u_bits_high);
            }
        }
        for (u_i = 0; u_i < this.u_contexts; ++u_i) {
            this.dec.initSymbolModel(this.mBits[u_i]);
        }
        this.dec.initBitModel(this.mCorrector0);
        for (u_i = 1; u_i <= this.u_corr_bits; ++u_i) {
            this.dec.initSymbolModel(this.mCorrector[u_i]);
        }
    }

    public int decompress(int pred) {
        return this.decompress(pred, 0);
    }

    public int decompress(int pred, int u_context) {
        assert (this.dec != null);
        int real = pred + this.readCorrector(this.mBits[u_context]);
        if (real < 0) {
            real += this.u_corr_range;
        } else if (Integer.compareUnsigned(real, this.u_corr_range) >= 0) {
            real -= this.u_corr_range;
        }
        return real;
    }

    void writeCorrector(int c, ArithmeticModel mBits) {
        int u_c1;
        this.u_k = 0;
        int n = u_c1 = c <= 0 ? -c : c - 1;
        while (u_c1 != 0) {
            u_c1 >>>= 1;
            ++this.u_k;
        }
        this.enc.encodeSymbol(mBits, this.u_k);
        if (this.u_k != 0) {
            assert (c != 0 && c != 1);
            if (Integer.compareUnsigned(this.u_k, 32) < 0) {
                c = c < 0 ? (c += (1 << this.u_k) - 1) : --c;
                if (this.u_k <= this.u_bits_high) {
                    this.enc.encodeSymbol(this.mCorrector[this.u_k], c);
                } else {
                    int k1 = this.u_k - this.u_bits_high;
                    u_c1 = c & (1 << k1) - 1;
                    this.enc.encodeSymbol(this.mCorrector[this.u_k], c >>= k1);
                    this.enc.writeBits(k1, u_c1);
                }
            }
        } else {
            assert (c == 0 || c == 1);
            this.enc.encodeBit(this.mCorrector0, c);
        }
    }

    int readCorrector(ArithmeticModel mBits) {
        int c;
        this.u_k = this.dec.decodeSymbol(mBits);
        if (this.u_k != 0) {
            if (Integer.compareUnsigned(this.u_k, 32) < 0) {
                if (Integer.compareUnsigned(this.u_k, this.u_bits_high) <= 0) {
                    c = this.dec.decodeSymbol(this.mCorrector[this.u_k]);
                } else {
                    int k1 = this.u_k - this.u_bits_high;
                    c = this.dec.decodeSymbol(this.mCorrector[this.u_k]);
                    int c1 = this.dec.readBits(k1);
                    c = c << k1 | c1;
                }
                c = c >= 1 << this.u_k - 1 ? ++c : (c -= (1 << this.u_k) - 1);
            } else {
                c = this.corr_min;
            }
        } else {
            c = this.dec.decodeBit(this.mCorrector0);
        }
        return c;
    }
}

