/*
 * Decompiled with CFR 0.152.
 */
package com.github.mreutegg.laszip4j.laszip;

import com.github.mreutegg.laszip4j.clib.Cstring;
import com.github.mreutegg.laszip4j.laszip.ArithmeticDecoder;
import com.github.mreutegg.laszip4j.laszip.IntegerCompressor;
import com.github.mreutegg.laszip4j.laszip.LASreadItemCompressed;

public class LASreadItemCompressed_BYTE_v1
extends LASreadItemCompressed {
    private ArithmeticDecoder dec;
    private int number;
    private byte[] last_item;
    private IntegerCompressor ic_byte;

    public LASreadItemCompressed_BYTE_v1(ArithmeticDecoder dec, int number) {
        assert (dec != null);
        this.dec = dec;
        assert (number != 0);
        this.number = number;
        this.ic_byte = new IntegerCompressor(dec, 8, number);
        this.last_item = new byte[number];
    }

    @Override
    public boolean init(byte[] item) {
        this.ic_byte.initDecompressor();
        Cstring.memcpy(this.last_item, item, this.number);
        return Boolean.TRUE;
    }

    @Override
    public void read(byte[] item) {
        for (int i = 0; i < this.number; ++i) {
            item[i] = (byte)this.ic_byte.decompress(this.last_item[i], i);
        }
        Cstring.memcpy(this.last_item, item, this.number);
    }
}

