/*
 * Decompiled with CFR 0.152.
 */
package com.github.mreutegg.laszip4j.laszip;

import com.github.mreutegg.laszip4j.clib.Cstring;
import com.github.mreutegg.laszip4j.laszip.ArithmeticDecoder;
import com.github.mreutegg.laszip4j.laszip.ArithmeticModel;
import com.github.mreutegg.laszip4j.laszip.Common_v2;
import com.github.mreutegg.laszip4j.laszip.IntegerCompressor;
import com.github.mreutegg.laszip4j.laszip.LASreadItemCompressed;
import com.github.mreutegg.laszip4j.laszip.MyDefs;
import com.github.mreutegg.laszip4j.laszip.StreamingMedian5;
import java.nio.ByteBuffer;

public class LASreadItemCompressed_POINT10_v2
extends LASreadItemCompressed {
    private ArithmeticDecoder dec;
    private byte[] last_item = new byte[20];
    private char[] last_intensity = new char[16];
    private StreamingMedian5[] last_x_diff_median5 = StreamingMedian5.newStreamingMedian5(16);
    private StreamingMedian5[] last_y_diff_median5 = StreamingMedian5.newStreamingMedian5(16);
    private int[] last_height = new int[8];
    private ArithmeticModel m_changed_values;
    private IntegerCompressor ic_intensity;
    private ArithmeticModel[] m_scan_angle_rank = new ArithmeticModel[2];
    private IntegerCompressor ic_point_source_ID;
    private ArithmeticModel[] m_bit_byte = new ArithmeticModel[256];
    private ArithmeticModel[] m_classification = new ArithmeticModel[256];
    private ArithmeticModel[] m_user_data = new ArithmeticModel[256];
    private IntegerCompressor ic_dx;
    private IntegerCompressor ic_dy;
    private IntegerCompressor ic_z;

    public LASreadItemCompressed_POINT10_v2(ArithmeticDecoder dec) {
        assert (dec != null);
        this.dec = dec;
        this.m_changed_values = dec.createSymbolModel(64);
        this.ic_intensity = new IntegerCompressor(dec, 16, 4);
        this.m_scan_angle_rank[0] = dec.createSymbolModel(256);
        this.m_scan_angle_rank[1] = dec.createSymbolModel(256);
        this.ic_point_source_ID = new IntegerCompressor(dec, 16);
        for (int i = 0; i < 256; ++i) {
            this.m_bit_byte[i] = null;
            this.m_classification[i] = null;
            this.m_user_data[i] = null;
        }
        this.ic_dx = new IntegerCompressor(dec, 32, 2);
        this.ic_dy = new IntegerCompressor(dec, 32, 22);
        this.ic_z = new IntegerCompressor(dec, 32, 20);
    }

    @Override
    public boolean init(byte[] item) {
        int i;
        for (i = 0; i < 16; ++i) {
            this.last_x_diff_median5[i].init();
            this.last_y_diff_median5[i].init();
            this.last_intensity[i] = '\u0000';
            this.last_height[i / 2] = 0;
        }
        this.dec.initSymbolModel(this.m_changed_values);
        this.ic_intensity.initDecompressor();
        this.dec.initSymbolModel(this.m_scan_angle_rank[0]);
        this.dec.initSymbolModel(this.m_scan_angle_rank[1]);
        this.ic_point_source_ID.initDecompressor();
        for (i = 0; i < 256; ++i) {
            if (this.m_bit_byte[i] != null) {
                this.dec.initSymbolModel(this.m_bit_byte[i]);
            }
            if (this.m_classification[i] != null) {
                this.dec.initSymbolModel(this.m_classification[i]);
            }
            if (this.m_user_data[i] == null) continue;
            this.dec.initSymbolModel(this.m_user_data[i]);
        }
        this.ic_dx.initDecompressor();
        this.ic_dy.initDecompressor();
        this.ic_z.initDecompressor();
        Cstring.memcpy(this.last_item, item, 20);
        this.last_item[12] = 0;
        this.last_item[13] = 0;
        return Boolean.TRUE;
    }

    @Override
    public void read(byte[] item) {
        byte l;
        int m;
        int n;
        int changed_values = this.dec.decodeSymbol(this.m_changed_values);
        LASpoint10 lp = LASpoint10.wrap(this.last_item);
        if (changed_values != 0) {
            if ((changed_values & 0x20) != 0) {
                if (this.m_bit_byte[Byte.toUnsignedInt(this.last_item[14])] == null) {
                    this.m_bit_byte[Byte.toUnsignedInt((byte)this.last_item[14])] = this.dec.createSymbolModel(256);
                    this.dec.initSymbolModel(this.m_bit_byte[Byte.toUnsignedInt(this.last_item[14])]);
                }
                this.last_item[14] = (byte)this.dec.decodeSymbol(this.m_bit_byte[Byte.toUnsignedInt(this.last_item[14])]);
            }
            int r = lp.getReturn_number();
            n = lp.getNumber_of_returns_of_given_pulse();
            m = Common_v2.number_return_map[n][r];
            l = Common_v2.number_return_level[n][r];
            if ((changed_values & 0x10) != 0) {
                lp.setIntensity((char)this.ic_intensity.decompress(this.last_intensity[m], m < 3 ? m : 3));
                this.last_intensity[m] = lp.getIntensity();
            } else {
                lp.setIntensity(this.last_intensity[m]);
            }
            if ((changed_values & 8) != 0) {
                if (this.m_classification[Byte.toUnsignedInt(this.last_item[15])] == null) {
                    this.m_classification[Byte.toUnsignedInt((byte)this.last_item[15])] = this.dec.createSymbolModel(256);
                    this.dec.initSymbolModel(this.m_classification[Byte.toUnsignedInt(this.last_item[15])]);
                }
                this.last_item[15] = (byte)this.dec.decodeSymbol(this.m_classification[Byte.toUnsignedInt(this.last_item[15])]);
            }
            if ((changed_values & 4) != 0) {
                int val = this.dec.decodeSymbol(this.m_scan_angle_rank[lp.getScan_direction_flag()]);
                this.last_item[16] = MyDefs.U8_FOLD(val + this.last_item[16]);
            }
            if ((changed_values & 2) != 0) {
                if (this.m_user_data[Byte.toUnsignedInt(this.last_item[17])] == null) {
                    this.m_user_data[Byte.toUnsignedInt((byte)this.last_item[17])] = this.dec.createSymbolModel(256);
                    this.dec.initSymbolModel(this.m_user_data[Byte.toUnsignedInt(this.last_item[17])]);
                }
                this.last_item[17] = (byte)this.dec.decodeSymbol(this.m_user_data[Byte.toUnsignedInt(this.last_item[17])]);
            }
            if ((changed_values & 1) != 0) {
                lp.setPoint_source_ID((char)this.ic_point_source_ID.decompress(lp.getPoint_source_ID()));
            }
        } else {
            int r = lp.getReturn_number();
            n = lp.getNumber_of_returns_of_given_pulse();
            m = Common_v2.number_return_map[n][r];
            l = Common_v2.number_return_level[n][r];
        }
        int median = this.last_x_diff_median5[m].get();
        int diff = this.ic_dx.decompress(median, n == 1 ? 1 : 0);
        lp.setX(lp.getX() + diff);
        this.last_x_diff_median5[m].add(diff);
        median = this.last_y_diff_median5[m].get();
        int k_bits = this.ic_dx.getK();
        diff = this.ic_dy.decompress(median, (n == 1 ? 1 : 0) + (k_bits < 20 ? MyDefs.U32_ZERO_BIT_0(k_bits) : 20));
        lp.setY(lp.getY() + diff);
        this.last_y_diff_median5[m].add(diff);
        k_bits = (this.ic_dx.getK() + this.ic_dy.getK()) / 2;
        lp.setZ(this.ic_z.decompress(this.last_height[l], (n == 1 ? 1 : 0) + (k_bits < 18 ? MyDefs.U32_ZERO_BIT_0(k_bits) : 18)));
        this.last_height[l] = lp.getZ();
        Cstring.memcpy(item, this.last_item, 20);
    }

    static class LASpoint10 {
        private final ByteBuffer bb;

        private LASpoint10(ByteBuffer bb) {
            this.bb = bb;
        }

        public LASpoint10() {
            this(ByteBuffer.allocate(20));
        }

        static LASpoint10 wrap(byte[] data) {
            return new LASpoint10(ByteBuffer.wrap(data));
        }

        int getX() {
            return this.bb.getInt(0);
        }

        void setX(int x) {
            this.bb.putInt(0, x);
        }

        int getY() {
            return this.bb.getInt(4);
        }

        void setY(int y) {
            this.bb.putInt(4, y);
        }

        int getZ() {
            return this.bb.getInt(8);
        }

        void setZ(int z) {
            this.bb.putInt(8, z);
        }

        char getIntensity() {
            return this.bb.getChar(12);
        }

        void setIntensity(char i) {
            this.bb.putChar(12, i);
        }

        char getPoint_source_ID() {
            return this.bb.getChar(18);
        }

        void setPoint_source_ID(char id) {
            this.bb.putChar(18, id);
        }

        int getReturn_number() {
            byte b = this.bb.get(14);
            return b & 7;
        }

        int getNumber_of_returns_of_given_pulse() {
            byte b = this.bb.get(14);
            return b >>> 3 & 7;
        }

        int getScan_direction_flag() {
            byte b = this.bb.get(14);
            return b >>> 6 & 1;
        }
    }
}

