/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.common;

import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.util.ArrayList;
import java.util.List;
import org.tinfour.common.IConstraint;
import org.tinfour.common.PolyLineConstraintAdapter;
import org.tinfour.common.Vertex;

public class LinearConstraint
extends PolyLineConstraintAdapter
implements IConstraint {
    public LinearConstraint() {
    }

    public LinearConstraint(Vertex v0, Vertex v1) {
        this.add(v0);
        this.add(v1);
        this.complete();
    }

    public LinearConstraint(List<Vertex> vList) {
        super(vList);
    }

    @Override
    public final void complete() {
        this.isComplete = true;
    }

    @Override
    public boolean isPolygon() {
        return false;
    }

    @Override
    public boolean definesConstrainedRegion() {
        return false;
    }

    @Override
    public double getNominalPointSpacing() {
        if (this.list.size() < 2) {
            return Double.NaN;
        }
        return this.length / (double)(this.list.size() - 1);
    }

    @Override
    public LinearConstraint getConstraintWithNewGeometry(List<Vertex> geometry) {
        LinearConstraint c = new LinearConstraint(geometry);
        c.applicationData = this.applicationData;
        c.constraintIndex = this.constraintIndex;
        c.maintainingTin = this.maintainingTin;
        c.constraintLinkingEdge = this.constraintLinkingEdge;
        c.complete();
        return c;
    }

    @Override
    public LinearConstraint refactor(Iterable<Vertex> geometry) {
        ArrayList<Vertex> gList = new ArrayList<Vertex>();
        for (Vertex v : geometry) {
            gList.add(v);
        }
        return this.getConstraintWithNewGeometry(gList);
    }

    @Override
    public boolean isValid() {
        return this.list.size() >= 2;
    }

    @Override
    public Path2D getPath2D(AffineTransform transform) {
        AffineTransform af = transform;
        if (transform == null) {
            af = new AffineTransform();
        }
        double[] c = new double[4];
        Path2D.Double path = new Path2D.Double();
        boolean moveFlag = true;
        for (Vertex v : this.list) {
            c[0] = v.x;
            c[1] = v.y;
            af.transform(c, 0, c, 2, 1);
            if (moveFlag) {
                moveFlag = false;
                ((Path2D)path).moveTo(c[2], c[3]);
                continue;
            }
            ((Path2D)path).lineTo(c[2], c[3]);
        }
        return path;
    }
}

